<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForgottenPassword StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ForgottenPassword
 * @subpackage Structs
 */
class ForgottenPassword extends TransactionInfo
{
    /**
     * The ForgottenPasswordRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ForgottenPassword
     */
    public $ForgottenPasswordRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The LanguageCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LanguageCode;
    /**
     * The EmailAddressInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\EmailAddressInfo
     */
    public $EmailAddressInfo;
    /**
     * The UserNameInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\UserNameInfo
     */
    public $UserNameInfo;
    /**
     * The StaffIDInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\StaffIDInfo
     */
    public $StaffIDInfo;
    /**
     * The ActionSuccessful
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ActionSuccessful;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for ForgottenPassword
     * @uses ForgottenPassword::setForgottenPasswordRequest()
     * @uses ForgottenPassword::setActionType()
     * @uses ForgottenPassword::setLanguageCode()
     * @uses ForgottenPassword::setEmailAddressInfo()
     * @uses ForgottenPassword::setUserNameInfo()
     * @uses ForgottenPassword::setStaffIDInfo()
     * @uses ForgottenPassword::setActionSuccessful()
     * @uses ForgottenPassword::setExceptions()
     * @param \StructType\ForgottenPassword $forgottenPasswordRequest
     * @param string $actionType
     * @param string $languageCode
     * @param \StructType\EmailAddressInfo $emailAddressInfo
     * @param \StructType\UserNameInfo $userNameInfo
     * @param \StructType\StaffIDInfo $staffIDInfo
     * @param bool $actionSuccessful
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct(\StructType\ForgottenPassword $forgottenPasswordRequest = null, $actionType = null, $languageCode = null, \StructType\EmailAddressInfo $emailAddressInfo = null, \StructType\UserNameInfo $userNameInfo = null, \StructType\StaffIDInfo $staffIDInfo = null, $actionSuccessful = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setForgottenPasswordRequest($forgottenPasswordRequest)
            ->setActionType($actionType)
            ->setLanguageCode($languageCode)
            ->setEmailAddressInfo($emailAddressInfo)
            ->setUserNameInfo($userNameInfo)
            ->setStaffIDInfo($staffIDInfo)
            ->setActionSuccessful($actionSuccessful)
            ->setExceptions($exceptions);
    }
    /**
     * Get ForgottenPasswordRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ForgottenPassword|null
     */
    public function getForgottenPasswordRequest()
    {
        return isset($this->ForgottenPasswordRequest) ? $this->ForgottenPasswordRequest : null;
    }
    /**
     * Set ForgottenPasswordRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ForgottenPassword $forgottenPasswordRequest
     * @return \StructType\ForgottenPassword
     */
    public function setForgottenPasswordRequest(\StructType\ForgottenPassword $forgottenPasswordRequest = null)
    {
        if (is_null($forgottenPasswordRequest) || (is_array($forgottenPasswordRequest) && empty($forgottenPasswordRequest))) {
            unset($this->ForgottenPasswordRequest);
        } else {
            $this->ForgottenPasswordRequest = $forgottenPasswordRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ForgottenPassword_ActionTypes::valueIsValid()
     * @uses \EnumType\ForgottenPassword_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\ForgottenPassword
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ForgottenPassword_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ForgottenPassword_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\ForgottenPassword_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get LanguageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }
    /**
     * Set LanguageCode value
     * @param string $languageCode
     * @return \StructType\ForgottenPassword
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCode, true), gettype($languageCode)), __LINE__);
        }
        $this->LanguageCode = $languageCode;
        return $this;
    }
    /**
     * Get EmailAddressInfo value
     * @return \StructType\EmailAddressInfo|null
     */
    public function getEmailAddressInfo()
    {
        return $this->EmailAddressInfo;
    }
    /**
     * Set EmailAddressInfo value
     * @param \StructType\EmailAddressInfo $emailAddressInfo
     * @return \StructType\ForgottenPassword
     */
    public function setEmailAddressInfo(\StructType\EmailAddressInfo $emailAddressInfo = null)
    {
        $this->EmailAddressInfo = $emailAddressInfo;
        return $this;
    }
    /**
     * Get UserNameInfo value
     * @return \StructType\UserNameInfo|null
     */
    public function getUserNameInfo()
    {
        return $this->UserNameInfo;
    }
    /**
     * Set UserNameInfo value
     * @param \StructType\UserNameInfo $userNameInfo
     * @return \StructType\ForgottenPassword
     */
    public function setUserNameInfo(\StructType\UserNameInfo $userNameInfo = null)
    {
        $this->UserNameInfo = $userNameInfo;
        return $this;
    }
    /**
     * Get StaffIDInfo value
     * @return \StructType\StaffIDInfo|null
     */
    public function getStaffIDInfo()
    {
        return $this->StaffIDInfo;
    }
    /**
     * Set StaffIDInfo value
     * @param \StructType\StaffIDInfo $staffIDInfo
     * @return \StructType\ForgottenPassword
     */
    public function setStaffIDInfo(\StructType\StaffIDInfo $staffIDInfo = null)
    {
        $this->StaffIDInfo = $staffIDInfo;
        return $this;
    }
    /**
     * Get ActionSuccessful value
     * @return bool|null
     */
    public function getActionSuccessful()
    {
        return $this->ActionSuccessful;
    }
    /**
     * Set ActionSuccessful value
     * @param bool $actionSuccessful
     * @return \StructType\ForgottenPassword
     */
    public function setActionSuccessful($actionSuccessful = null)
    {
        // validation for constraint: boolean
        if (!is_null($actionSuccessful) && !is_bool($actionSuccessful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($actionSuccessful, true), gettype($actionSuccessful)), __LINE__);
        }
        $this->ActionSuccessful = $actionSuccessful;
        return $this;
    }
    /**
     * Get Exceptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return isset($this->Exceptions) ? $this->Exceptions : null;
    }
    /**
     * Set Exceptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ForgottenPassword
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        if (is_null($exceptions) || (is_array($exceptions) && empty($exceptions))) {
            unset($this->Exceptions);
        } else {
            $this->Exceptions = $exceptions;
        }
        return $this;
    }
}
