<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateProfile StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateProfile
 * @subpackage Structs
 */
class CreateProfile extends TransactionInfo
{
    /**
     * The CreateProfileRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CreateProfile
     */
    public $CreateProfileRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ProfileInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ProfileInfo
     */
    public $ProfileInfo;
    /**
     * The Profile
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Profile
     */
    public $Profile;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfAddress
     */
    public $Address;
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfContactInfo
     */
    public $ContactInfo;
    /**
     * The Identification
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfIdentification
     */
    public $Identification;
    /**
     * The Payment
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfPayment
     */
    public $Payment;
    /**
     * The Preference
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfPreference
     */
    public $Preference;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfCompany
     */
    public $Company;
    /**
     * The BuddyList
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfBuddyList
     */
    public $BuddyList;
    /**
     * Constructor method for CreateProfile
     * @uses CreateProfile::setCreateProfileRequest()
     * @uses CreateProfile::setActionType()
     * @uses CreateProfile::setProfileInfo()
     * @uses CreateProfile::setProfile()
     * @uses CreateProfile::setAddress()
     * @uses CreateProfile::setContactInfo()
     * @uses CreateProfile::setIdentification()
     * @uses CreateProfile::setPayment()
     * @uses CreateProfile::setPreference()
     * @uses CreateProfile::setCompany()
     * @uses CreateProfile::setBuddyList()
     * @param \StructType\CreateProfile $createProfileRequest
     * @param string $actionType
     * @param \StructType\ProfileInfo $profileInfo
     * @param \StructType\Profile $profile
     * @param \ArrayType\ArrayOfAddress $address
     * @param \ArrayType\ArrayOfContactInfo $contactInfo
     * @param \ArrayType\ArrayOfIdentification $identification
     * @param \ArrayType\ArrayOfPayment $payment
     * @param \ArrayType\ArrayOfPreference $preference
     * @param \ArrayType\ArrayOfCompany $company
     * @param \ArrayType\ArrayOfBuddyList $buddyList
     */
    public function __construct(\StructType\CreateProfile $createProfileRequest = null, $actionType = null, \StructType\ProfileInfo $profileInfo = null, \StructType\Profile $profile = null, \ArrayType\ArrayOfAddress $address = null, \ArrayType\ArrayOfContactInfo $contactInfo = null, \ArrayType\ArrayOfIdentification $identification = null, \ArrayType\ArrayOfPayment $payment = null, \ArrayType\ArrayOfPreference $preference = null, \ArrayType\ArrayOfCompany $company = null, \ArrayType\ArrayOfBuddyList $buddyList = null)
    {
        $this
            ->setCreateProfileRequest($createProfileRequest)
            ->setActionType($actionType)
            ->setProfileInfo($profileInfo)
            ->setProfile($profile)
            ->setAddress($address)
            ->setContactInfo($contactInfo)
            ->setIdentification($identification)
            ->setPayment($payment)
            ->setPreference($preference)
            ->setCompany($company)
            ->setBuddyList($buddyList);
    }
    /**
     * Get CreateProfileRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CreateProfile|null
     */
    public function getCreateProfileRequest()
    {
        return isset($this->CreateProfileRequest) ? $this->CreateProfileRequest : null;
    }
    /**
     * Set CreateProfileRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CreateProfile $createProfileRequest
     * @return \StructType\CreateProfile
     */
    public function setCreateProfileRequest(\StructType\CreateProfile $createProfileRequest = null)
    {
        if (is_null($createProfileRequest) || (is_array($createProfileRequest) && empty($createProfileRequest))) {
            unset($this->CreateProfileRequest);
        } else {
            $this->CreateProfileRequest = $createProfileRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\CreateProfile_ActionTypes::valueIsValid()
     * @uses \EnumType\CreateProfile_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\CreateProfile
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CreateProfile_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CreateProfile_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\CreateProfile_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ProfileInfo value
     * @return \StructType\ProfileInfo|null
     */
    public function getProfileInfo()
    {
        return $this->ProfileInfo;
    }
    /**
     * Set ProfileInfo value
     * @param \StructType\ProfileInfo $profileInfo
     * @return \StructType\CreateProfile
     */
    public function setProfileInfo(\StructType\ProfileInfo $profileInfo = null)
    {
        $this->ProfileInfo = $profileInfo;
        return $this;
    }
    /**
     * Get Profile value
     * @return \StructType\Profile|null
     */
    public function getProfile()
    {
        return $this->Profile;
    }
    /**
     * Set Profile value
     * @param \StructType\Profile $profile
     * @return \StructType\CreateProfile
     */
    public function setProfile(\StructType\Profile $profile = null)
    {
        $this->Profile = $profile;
        return $this;
    }
    /**
     * Get Address value
     * @return \ArrayType\ArrayOfAddress|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \ArrayType\ArrayOfAddress $address
     * @return \StructType\CreateProfile
     */
    public function setAddress(\ArrayType\ArrayOfAddress $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \ArrayType\ArrayOfContactInfo|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \ArrayType\ArrayOfContactInfo $contactInfo
     * @return \StructType\CreateProfile
     */
    public function setContactInfo(\ArrayType\ArrayOfContactInfo $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get Identification value
     * @return \ArrayType\ArrayOfIdentification|null
     */
    public function getIdentification()
    {
        return $this->Identification;
    }
    /**
     * Set Identification value
     * @param \ArrayType\ArrayOfIdentification $identification
     * @return \StructType\CreateProfile
     */
    public function setIdentification(\ArrayType\ArrayOfIdentification $identification = null)
    {
        $this->Identification = $identification;
        return $this;
    }
    /**
     * Get Payment value
     * @return \ArrayType\ArrayOfPayment|null
     */
    public function getPayment()
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param \ArrayType\ArrayOfPayment $payment
     * @return \StructType\CreateProfile
     */
    public function setPayment(\ArrayType\ArrayOfPayment $payment = null)
    {
        $this->Payment = $payment;
        return $this;
    }
    /**
     * Get Preference value
     * @return \ArrayType\ArrayOfPreference|null
     */
    public function getPreference()
    {
        return $this->Preference;
    }
    /**
     * Set Preference value
     * @param \ArrayType\ArrayOfPreference $preference
     * @return \StructType\CreateProfile
     */
    public function setPreference(\ArrayType\ArrayOfPreference $preference = null)
    {
        $this->Preference = $preference;
        return $this;
    }
    /**
     * Get Company value
     * @return \ArrayType\ArrayOfCompany|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param \ArrayType\ArrayOfCompany $company
     * @return \StructType\CreateProfile
     */
    public function setCompany(\ArrayType\ArrayOfCompany $company = null)
    {
        $this->Company = $company;
        return $this;
    }
    /**
     * Get BuddyList value
     * @return \ArrayType\ArrayOfBuddyList|null
     */
    public function getBuddyList()
    {
        return $this->BuddyList;
    }
    /**
     * Set BuddyList value
     * @param \ArrayType\ArrayOfBuddyList $buddyList
     * @return \StructType\CreateProfile
     */
    public function setBuddyList(\ArrayType\ArrayOfBuddyList $buddyList = null)
    {
        $this->BuddyList = $buddyList;
        return $this;
    }
}
