<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPreference ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPreference
 * @subpackage Arrays
 */
class ArrayOfPreference extends AbstractStructArrayBase
{
    /**
     * The Preference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Preference[]
     */
    public $Preference;
    /**
     * Constructor method for ArrayOfPreference
     * @uses ArrayOfPreference::setPreference()
     * @param \StructType\Preference[] $preference
     */
    public function __construct(array $preference = array())
    {
        $this
            ->setPreference($preference);
    }
    /**
     * Get Preference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Preference[]|null
     */
    public function getPreference()
    {
        return isset($this->Preference) ? $this->Preference : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPreference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPreference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePreferenceForArrayConstraintsFromSetPreference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPreferencePreferenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfPreferencePreferenceItem instanceof \StructType\Preference) {
                $invalidValues[] = is_object($arrayOfPreferencePreferenceItem) ? get_class($arrayOfPreferencePreferenceItem) : sprintf('%s(%s)', gettype($arrayOfPreferencePreferenceItem), var_export($arrayOfPreferencePreferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Preference property can only contain items of type \StructType\Preference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Preference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Preference[] $preference
     * @return \ArrayType\ArrayOfPreference
     */
    public function setPreference(array $preference = array())
    {
        // validation for constraint: array
        if ('' !== ($preferenceArrayErrorMessage = self::validatePreferenceForArrayConstraintsFromSetPreference($preference))) {
            throw new \InvalidArgumentException($preferenceArrayErrorMessage, __LINE__);
        }
        if (is_null($preference) || (is_array($preference) && empty($preference))) {
            unset($this->Preference);
        } else {
            $this->Preference = $preference;
        }
        return $this;
    }
    /**
     * Add item to Preference value
     * @throws \InvalidArgumentException
     * @param \StructType\Preference $item
     * @return \ArrayType\ArrayOfPreference
     */
    public function addToPreference(\StructType\Preference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Preference) {
            throw new \InvalidArgumentException(sprintf('The Preference property can only contain items of type \StructType\Preference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Preference[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Preference|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Preference|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Preference|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Preference|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Preference|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Preference
     */
    public function getAttributeName()
    {
        return 'Preference';
    }
}
