<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewProfile StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewProfile
 * @subpackage Structs
 */
class ViewProfile extends Profile
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAddress
     */
    public $Address;
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfContactInfo
     */
    public $ContactInfo;
    /**
     * The Identification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfIdentification
     */
    public $Identification;
    /**
     * The Payment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPayment
     */
    public $Payment;
    /**
     * The Preference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPreference
     */
    public $Preference;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCompany
     */
    public $Company;
    /**
     * The BuddyList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBuddyList
     */
    public $BuddyList;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for ViewProfile
     * @uses ViewProfile::setAddress()
     * @uses ViewProfile::setContactInfo()
     * @uses ViewProfile::setIdentification()
     * @uses ViewProfile::setPayment()
     * @uses ViewProfile::setPreference()
     * @uses ViewProfile::setCompany()
     * @uses ViewProfile::setBuddyList()
     * @uses ViewProfile::setExceptions()
     * @param \ArrayType\ArrayOfAddress $address
     * @param \ArrayType\ArrayOfContactInfo $contactInfo
     * @param \ArrayType\ArrayOfIdentification $identification
     * @param \ArrayType\ArrayOfPayment $payment
     * @param \ArrayType\ArrayOfPreference $preference
     * @param \ArrayType\ArrayOfCompany $company
     * @param \ArrayType\ArrayOfBuddyList $buddyList
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct(\ArrayType\ArrayOfAddress $address = null, \ArrayType\ArrayOfContactInfo $contactInfo = null, \ArrayType\ArrayOfIdentification $identification = null, \ArrayType\ArrayOfPayment $payment = null, \ArrayType\ArrayOfPreference $preference = null, \ArrayType\ArrayOfCompany $company = null, \ArrayType\ArrayOfBuddyList $buddyList = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setAddress($address)
            ->setContactInfo($contactInfo)
            ->setIdentification($identification)
            ->setPayment($payment)
            ->setPreference($preference)
            ->setCompany($company)
            ->setBuddyList($buddyList)
            ->setExceptions($exceptions);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAddress|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAddress $address
     * @return \StructType\ViewProfile
     */
    public function setAddress(\ArrayType\ArrayOfAddress $address = null)
    {
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get ContactInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfContactInfo|null
     */
    public function getContactInfo()
    {
        return isset($this->ContactInfo) ? $this->ContactInfo : null;
    }
    /**
     * Set ContactInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfContactInfo $contactInfo
     * @return \StructType\ViewProfile
     */
    public function setContactInfo(\ArrayType\ArrayOfContactInfo $contactInfo = null)
    {
        if (is_null($contactInfo) || (is_array($contactInfo) && empty($contactInfo))) {
            unset($this->ContactInfo);
        } else {
            $this->ContactInfo = $contactInfo;
        }
        return $this;
    }
    /**
     * Get Identification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfIdentification|null
     */
    public function getIdentification()
    {
        return isset($this->Identification) ? $this->Identification : null;
    }
    /**
     * Set Identification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfIdentification $identification
     * @return \StructType\ViewProfile
     */
    public function setIdentification(\ArrayType\ArrayOfIdentification $identification = null)
    {
        if (is_null($identification) || (is_array($identification) && empty($identification))) {
            unset($this->Identification);
        } else {
            $this->Identification = $identification;
        }
        return $this;
    }
    /**
     * Get Payment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPayment|null
     */
    public function getPayment()
    {
        return isset($this->Payment) ? $this->Payment : null;
    }
    /**
     * Set Payment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPayment $payment
     * @return \StructType\ViewProfile
     */
    public function setPayment(\ArrayType\ArrayOfPayment $payment = null)
    {
        if (is_null($payment) || (is_array($payment) && empty($payment))) {
            unset($this->Payment);
        } else {
            $this->Payment = $payment;
        }
        return $this;
    }
    /**
     * Get Preference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPreference|null
     */
    public function getPreference()
    {
        return isset($this->Preference) ? $this->Preference : null;
    }
    /**
     * Set Preference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPreference $preference
     * @return \StructType\ViewProfile
     */
    public function setPreference(\ArrayType\ArrayOfPreference $preference = null)
    {
        if (is_null($preference) || (is_array($preference) && empty($preference))) {
            unset($this->Preference);
        } else {
            $this->Preference = $preference;
        }
        return $this;
    }
    /**
     * Get Company value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCompany|null
     */
    public function getCompany()
    {
        return isset($this->Company) ? $this->Company : null;
    }
    /**
     * Set Company value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCompany $company
     * @return \StructType\ViewProfile
     */
    public function setCompany(\ArrayType\ArrayOfCompany $company = null)
    {
        if (is_null($company) || (is_array($company) && empty($company))) {
            unset($this->Company);
        } else {
            $this->Company = $company;
        }
        return $this;
    }
    /**
     * Get BuddyList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBuddyList|null
     */
    public function getBuddyList()
    {
        return isset($this->BuddyList) ? $this->BuddyList : null;
    }
    /**
     * Set BuddyList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBuddyList $buddyList
     * @return \StructType\ViewProfile
     */
    public function setBuddyList(\ArrayType\ArrayOfBuddyList $buddyList = null)
    {
        if (is_null($buddyList) || (is_array($buddyList) && empty($buddyList))) {
            unset($this->BuddyList);
        } else {
            $this->BuddyList = $buddyList;
        }
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ViewProfile
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
}
