<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveProfileVouchers StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveProfileVouchers
 * @subpackage Structs
 */
class RetrieveProfileVouchers extends TransactionInfo
{
    /**
     * The RetrieveProfileVouchersRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveProfileVouchers
     */
    public $RetrieveProfileVouchersRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ActiveOnly
     * @var bool
     */
    public $ActiveOnly;
    /**
     * The ProfileId
     * @var int
     */
    public $ProfileId;
    /**
     * The ProfileUserId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ProfileUserId;
    /**
     * Constructor method for RetrieveProfileVouchers
     * @uses RetrieveProfileVouchers::setRetrieveProfileVouchersRequest()
     * @uses RetrieveProfileVouchers::setActionType()
     * @uses RetrieveProfileVouchers::setActiveOnly()
     * @uses RetrieveProfileVouchers::setProfileId()
     * @uses RetrieveProfileVouchers::setProfileUserId()
     * @param \StructType\RetrieveProfileVouchers $retrieveProfileVouchersRequest
     * @param string $actionType
     * @param bool $activeOnly
     * @param int $profileId
     * @param string $profileUserId
     */
    public function __construct(\StructType\RetrieveProfileVouchers $retrieveProfileVouchersRequest = null, $actionType = null, $activeOnly = null, $profileId = null, $profileUserId = null)
    {
        $this
            ->setRetrieveProfileVouchersRequest($retrieveProfileVouchersRequest)
            ->setActionType($actionType)
            ->setActiveOnly($activeOnly)
            ->setProfileId($profileId)
            ->setProfileUserId($profileUserId);
    }
    /**
     * Get RetrieveProfileVouchersRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveProfileVouchers|null
     */
    public function getRetrieveProfileVouchersRequest()
    {
        return isset($this->RetrieveProfileVouchersRequest) ? $this->RetrieveProfileVouchersRequest : null;
    }
    /**
     * Set RetrieveProfileVouchersRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveProfileVouchers $retrieveProfileVouchersRequest
     * @return \StructType\RetrieveProfileVouchers
     */
    public function setRetrieveProfileVouchersRequest(\StructType\RetrieveProfileVouchers $retrieveProfileVouchersRequest = null)
    {
        if (is_null($retrieveProfileVouchersRequest) || (is_array($retrieveProfileVouchersRequest) && empty($retrieveProfileVouchersRequest))) {
            unset($this->RetrieveProfileVouchersRequest);
        } else {
            $this->RetrieveProfileVouchersRequest = $retrieveProfileVouchersRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\RetrieveProfileVouchers_ActionTypes::valueIsValid()
     * @uses \EnumType\RetrieveProfileVouchers_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\RetrieveProfileVouchers
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RetrieveProfileVouchers_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RetrieveProfileVouchers_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\RetrieveProfileVouchers_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ActiveOnly value
     * @return bool|null
     */
    public function getActiveOnly()
    {
        return $this->ActiveOnly;
    }
    /**
     * Set ActiveOnly value
     * @param bool $activeOnly
     * @return \StructType\RetrieveProfileVouchers
     */
    public function setActiveOnly($activeOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($activeOnly) && !is_bool($activeOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activeOnly, true), gettype($activeOnly)), __LINE__);
        }
        $this->ActiveOnly = $activeOnly;
        return $this;
    }
    /**
     * Get ProfileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->ProfileId;
    }
    /**
     * Set ProfileId value
     * @param int $profileId
     * @return \StructType\RetrieveProfileVouchers
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !(is_int($profileId) || ctype_digit($profileId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileId, true), gettype($profileId)), __LINE__);
        }
        $this->ProfileId = $profileId;
        return $this;
    }
    /**
     * Get ProfileUserId value
     * @return string|null
     */
    public function getProfileUserId()
    {
        return $this->ProfileUserId;
    }
    /**
     * Set ProfileUserId value
     * @param string $profileUserId
     * @return \StructType\RetrieveProfileVouchers
     */
    public function setProfileUserId($profileUserId = null)
    {
        // validation for constraint: string
        if (!is_null($profileUserId) && !is_string($profileUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileUserId, true), gettype($profileUserId)), __LINE__);
        }
        $this->ProfileUserId = $profileUserId;
        return $this;
    }
}
