<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveProfileReservations StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveProfileReservations
 * @subpackage Structs
 */
class RetrieveProfileReservations extends TransactionInfo
{
    /**
     * The RetrieveProfileReservationsRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveProfileReservations
     */
    public $RetrieveProfileReservationsRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ProfileID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProfileID;
    /**
     * The ProfileReservation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRetrieveProfileReservation
     */
    public $ProfileReservation;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for RetrieveProfileReservations
     * @uses RetrieveProfileReservations::setRetrieveProfileReservationsRequest()
     * @uses RetrieveProfileReservations::setActionType()
     * @uses RetrieveProfileReservations::setProfileID()
     * @uses RetrieveProfileReservations::setProfileReservation()
     * @uses RetrieveProfileReservations::setExceptions()
     * @param \StructType\RetrieveProfileReservations $retrieveProfileReservationsRequest
     * @param string $actionType
     * @param int $profileID
     * @param \ArrayType\ArrayOfRetrieveProfileReservation $profileReservation
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct(\StructType\RetrieveProfileReservations $retrieveProfileReservationsRequest = null, $actionType = null, $profileID = null, \ArrayType\ArrayOfRetrieveProfileReservation $profileReservation = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setRetrieveProfileReservationsRequest($retrieveProfileReservationsRequest)
            ->setActionType($actionType)
            ->setProfileID($profileID)
            ->setProfileReservation($profileReservation)
            ->setExceptions($exceptions);
    }
    /**
     * Get RetrieveProfileReservationsRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveProfileReservations|null
     */
    public function getRetrieveProfileReservationsRequest()
    {
        return isset($this->RetrieveProfileReservationsRequest) ? $this->RetrieveProfileReservationsRequest : null;
    }
    /**
     * Set RetrieveProfileReservationsRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveProfileReservations $retrieveProfileReservationsRequest
     * @return \StructType\RetrieveProfileReservations
     */
    public function setRetrieveProfileReservationsRequest(\StructType\RetrieveProfileReservations $retrieveProfileReservationsRequest = null)
    {
        if (is_null($retrieveProfileReservationsRequest) || (is_array($retrieveProfileReservationsRequest) && empty($retrieveProfileReservationsRequest))) {
            unset($this->RetrieveProfileReservationsRequest);
        } else {
            $this->RetrieveProfileReservationsRequest = $retrieveProfileReservationsRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\RetrieveProfileReservations_ActionTypes::valueIsValid()
     * @uses \EnumType\RetrieveProfileReservations_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\RetrieveProfileReservations
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RetrieveProfileReservations_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RetrieveProfileReservations_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\RetrieveProfileReservations_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ProfileID value
     * @return int|null
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param int $profileID
     * @return \StructType\RetrieveProfileReservations
     */
    public function setProfileID($profileID = null)
    {
        // validation for constraint: int
        if (!is_null($profileID) && !(is_int($profileID) || ctype_digit($profileID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileID, true), gettype($profileID)), __LINE__);
        }
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get ProfileReservation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRetrieveProfileReservation|null
     */
    public function getProfileReservation()
    {
        return isset($this->ProfileReservation) ? $this->ProfileReservation : null;
    }
    /**
     * Set ProfileReservation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRetrieveProfileReservation $profileReservation
     * @return \StructType\RetrieveProfileReservations
     */
    public function setProfileReservation(\ArrayType\ArrayOfRetrieveProfileReservation $profileReservation = null)
    {
        if (is_null($profileReservation) || (is_array($profileReservation) && empty($profileReservation))) {
            unset($this->ProfileReservation);
        } else {
            $this->ProfileReservation = $profileReservation;
        }
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\RetrieveProfileReservations
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
}
