<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Profile StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Profile
 * @subpackage Structs
 */
class Profile extends Person
{
    /**
     * The ProfileID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProfileID;
    /**
     * The ProfileType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProfileType;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comment;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The LastLogIn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LastLogIn;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The CreateChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateChannel;
    /**
     * The MealPrefID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MealPrefID;
    /**
     * The SeatingPrefID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatingPrefID;
    /**
     * The LanguageID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LanguageID;
    /**
     * The LoyaltyPgmID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoyaltyPgmID;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyName;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The SecurityQuestion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecurityQuestion;
    /**
     * The PassengerTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PassengerTypeCode;
    /**
     * The ActivationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ActivationCode;
    /**
     * The StaffID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StaffID;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * Constructor method for Profile
     * @uses Profile::setProfileID()
     * @uses Profile::setProfileType()
     * @uses Profile::setPassword()
     * @uses Profile::setEmail()
     * @uses Profile::setComment()
     * @uses Profile::setActive()
     * @uses Profile::setLastLogIn()
     * @uses Profile::setCreateDate()
     * @uses Profile::setCreateChannel()
     * @uses Profile::setMealPrefID()
     * @uses Profile::setSeatingPrefID()
     * @uses Profile::setLanguageID()
     * @uses Profile::setLoyaltyPgmID()
     * @uses Profile::setCompanyName()
     * @uses Profile::setUserName()
     * @uses Profile::setSecurityQuestion()
     * @uses Profile::setPassengerTypeCode()
     * @uses Profile::setActivationCode()
     * @uses Profile::setStaffID()
     * @uses Profile::setIATANumber()
     * @param int $profileID
     * @param int $profileType
     * @param string $password
     * @param string $email
     * @param string $comment
     * @param bool $active
     * @param string $lastLogIn
     * @param string $createDate
     * @param string $createChannel
     * @param int $mealPrefID
     * @param int $seatingPrefID
     * @param int $languageID
     * @param string $loyaltyPgmID
     * @param string $companyName
     * @param string $userName
     * @param string $securityQuestion
     * @param int $passengerTypeCode
     * @param int $activationCode
     * @param string $staffID
     * @param string $iATANumber
     */
    public function __construct($profileID = null, $profileType = null, $password = null, $email = null, $comment = null, $active = null, $lastLogIn = null, $createDate = null, $createChannel = null, $mealPrefID = null, $seatingPrefID = null, $languageID = null, $loyaltyPgmID = null, $companyName = null, $userName = null, $securityQuestion = null, $passengerTypeCode = null, $activationCode = null, $staffID = null, $iATANumber = null)
    {
        $this
            ->setProfileID($profileID)
            ->setProfileType($profileType)
            ->setPassword($password)
            ->setEmail($email)
            ->setComment($comment)
            ->setActive($active)
            ->setLastLogIn($lastLogIn)
            ->setCreateDate($createDate)
            ->setCreateChannel($createChannel)
            ->setMealPrefID($mealPrefID)
            ->setSeatingPrefID($seatingPrefID)
            ->setLanguageID($languageID)
            ->setLoyaltyPgmID($loyaltyPgmID)
            ->setCompanyName($companyName)
            ->setUserName($userName)
            ->setSecurityQuestion($securityQuestion)
            ->setPassengerTypeCode($passengerTypeCode)
            ->setActivationCode($activationCode)
            ->setStaffID($staffID)
            ->setIATANumber($iATANumber);
    }
    /**
     * Get ProfileID value
     * @return int|null
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param int $profileID
     * @return \StructType\Profile
     */
    public function setProfileID($profileID = null)
    {
        // validation for constraint: int
        if (!is_null($profileID) && !(is_int($profileID) || ctype_digit($profileID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileID, true), gettype($profileID)), __LINE__);
        }
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get ProfileType value
     * @return int|null
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * Set ProfileType value
     * @param int $profileType
     * @return \StructType\Profile
     */
    public function setProfileType($profileType = null)
    {
        // validation for constraint: int
        if (!is_null($profileType) && !(is_int($profileType) || ctype_digit($profileType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileType, true), gettype($profileType)), __LINE__);
        }
        $this->ProfileType = $profileType;
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \StructType\Profile
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\Profile
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comment
     * @return \StructType\Profile
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\Profile
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get LastLogIn value
     * @return string|null
     */
    public function getLastLogIn()
    {
        return $this->LastLogIn;
    }
    /**
     * Set LastLogIn value
     * @param string $lastLogIn
     * @return \StructType\Profile
     */
    public function setLastLogIn($lastLogIn = null)
    {
        // validation for constraint: string
        if (!is_null($lastLogIn) && !is_string($lastLogIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastLogIn, true), gettype($lastLogIn)), __LINE__);
        }
        $this->LastLogIn = $lastLogIn;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\Profile
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CreateChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateChannel()
    {
        return isset($this->CreateChannel) ? $this->CreateChannel : null;
    }
    /**
     * Set CreateChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createChannel
     * @return \StructType\Profile
     */
    public function setCreateChannel($createChannel = null)
    {
        // validation for constraint: string
        if (!is_null($createChannel) && !is_string($createChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createChannel, true), gettype($createChannel)), __LINE__);
        }
        if (is_null($createChannel) || (is_array($createChannel) && empty($createChannel))) {
            unset($this->CreateChannel);
        } else {
            $this->CreateChannel = $createChannel;
        }
        return $this;
    }
    /**
     * Get MealPrefID value
     * @return int|null
     */
    public function getMealPrefID()
    {
        return $this->MealPrefID;
    }
    /**
     * Set MealPrefID value
     * @param int $mealPrefID
     * @return \StructType\Profile
     */
    public function setMealPrefID($mealPrefID = null)
    {
        // validation for constraint: int
        if (!is_null($mealPrefID) && !(is_int($mealPrefID) || ctype_digit($mealPrefID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mealPrefID, true), gettype($mealPrefID)), __LINE__);
        }
        $this->MealPrefID = $mealPrefID;
        return $this;
    }
    /**
     * Get SeatingPrefID value
     * @return int|null
     */
    public function getSeatingPrefID()
    {
        return $this->SeatingPrefID;
    }
    /**
     * Set SeatingPrefID value
     * @param int $seatingPrefID
     * @return \StructType\Profile
     */
    public function setSeatingPrefID($seatingPrefID = null)
    {
        // validation for constraint: int
        if (!is_null($seatingPrefID) && !(is_int($seatingPrefID) || ctype_digit($seatingPrefID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatingPrefID, true), gettype($seatingPrefID)), __LINE__);
        }
        $this->SeatingPrefID = $seatingPrefID;
        return $this;
    }
    /**
     * Get LanguageID value
     * @return int|null
     */
    public function getLanguageID()
    {
        return $this->LanguageID;
    }
    /**
     * Set LanguageID value
     * @param int $languageID
     * @return \StructType\Profile
     */
    public function setLanguageID($languageID = null)
    {
        // validation for constraint: int
        if (!is_null($languageID) && !(is_int($languageID) || ctype_digit($languageID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($languageID, true), gettype($languageID)), __LINE__);
        }
        $this->LanguageID = $languageID;
        return $this;
    }
    /**
     * Get LoyaltyPgmID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoyaltyPgmID()
    {
        return isset($this->LoyaltyPgmID) ? $this->LoyaltyPgmID : null;
    }
    /**
     * Set LoyaltyPgmID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loyaltyPgmID
     * @return \StructType\Profile
     */
    public function setLoyaltyPgmID($loyaltyPgmID = null)
    {
        // validation for constraint: string
        if (!is_null($loyaltyPgmID) && !is_string($loyaltyPgmID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyaltyPgmID, true), gettype($loyaltyPgmID)), __LINE__);
        }
        if (is_null($loyaltyPgmID) || (is_array($loyaltyPgmID) && empty($loyaltyPgmID))) {
            unset($this->LoyaltyPgmID);
        } else {
            $this->LoyaltyPgmID = $loyaltyPgmID;
        }
        return $this;
    }
    /**
     * Get CompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyName()
    {
        return isset($this->CompanyName) ? $this->CompanyName : null;
    }
    /**
     * Set CompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyName
     * @return \StructType\Profile
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        if (is_null($companyName) || (is_array($companyName) && empty($companyName))) {
            unset($this->CompanyName);
        } else {
            $this->CompanyName = $companyName;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \StructType\Profile
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
    /**
     * Get SecurityQuestion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityQuestion()
    {
        return isset($this->SecurityQuestion) ? $this->SecurityQuestion : null;
    }
    /**
     * Set SecurityQuestion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityQuestion
     * @return \StructType\Profile
     */
    public function setSecurityQuestion($securityQuestion = null)
    {
        // validation for constraint: string
        if (!is_null($securityQuestion) && !is_string($securityQuestion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityQuestion, true), gettype($securityQuestion)), __LINE__);
        }
        if (is_null($securityQuestion) || (is_array($securityQuestion) && empty($securityQuestion))) {
            unset($this->SecurityQuestion);
        } else {
            $this->SecurityQuestion = $securityQuestion;
        }
        return $this;
    }
    /**
     * Get PassengerTypeCode value
     * @return int|null
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param int $passengerTypeCode
     * @return \StructType\Profile
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        // validation for constraint: int
        if (!is_null($passengerTypeCode) && !(is_int($passengerTypeCode) || ctype_digit($passengerTypeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passengerTypeCode, true), gettype($passengerTypeCode)), __LINE__);
        }
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
    /**
     * Get ActivationCode value
     * @return int|null
     */
    public function getActivationCode()
    {
        return $this->ActivationCode;
    }
    /**
     * Set ActivationCode value
     * @param int $activationCode
     * @return \StructType\Profile
     */
    public function setActivationCode($activationCode = null)
    {
        // validation for constraint: int
        if (!is_null($activationCode) && !(is_int($activationCode) || ctype_digit($activationCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($activationCode, true), gettype($activationCode)), __LINE__);
        }
        $this->ActivationCode = $activationCode;
        return $this;
    }
    /**
     * Get StaffID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStaffID()
    {
        return isset($this->StaffID) ? $this->StaffID : null;
    }
    /**
     * Set StaffID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $staffID
     * @return \StructType\Profile
     */
    public function setStaffID($staffID = null)
    {
        // validation for constraint: string
        if (!is_null($staffID) && !is_string($staffID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($staffID, true), gettype($staffID)), __LINE__);
        }
        if (is_null($staffID) || (is_array($staffID) && empty($staffID))) {
            unset($this->StaffID);
        } else {
            $this->StaffID = $staffID;
        }
        return $this;
    }
    /**
     * Get IATANumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIATANumber()
    {
        return isset($this->IATANumber) ? $this->IATANumber : null;
    }
    /**
     * Set IATANumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iATANumber
     * @return \StructType\Profile
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        if (is_null($iATANumber) || (is_array($iATANumber) && empty($iATANumber))) {
            unset($this->IATANumber);
        } else {
            $this->IATANumber = $iATANumber;
        }
        return $this;
    }
}
