<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ContactInfo
 * @subpackage Structs
 */
class ContactInfo extends AbstractStructBase
{
    /**
     * The ContactID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ContactID;
    /**
     * The ContactTypeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ContactTypeID;
    /**
     * The ContactName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactName;
    /**
     * The ContactValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactValue;
    /**
     * The Extension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Extension;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * Constructor method for ContactInfo
     * @uses ContactInfo::setContactID()
     * @uses ContactInfo::setContactTypeID()
     * @uses ContactInfo::setContactName()
     * @uses ContactInfo::setContactValue()
     * @uses ContactInfo::setExtension()
     * @uses ContactInfo::setActive()
     * @uses ContactInfo::setCreateDate()
     * @param int $contactID
     * @param int $contactTypeID
     * @param string $contactName
     * @param string $contactValue
     * @param string $extension
     * @param bool $active
     * @param string $createDate
     */
    public function __construct($contactID = null, $contactTypeID = null, $contactName = null, $contactValue = null, $extension = null, $active = null, $createDate = null)
    {
        $this
            ->setContactID($contactID)
            ->setContactTypeID($contactTypeID)
            ->setContactName($contactName)
            ->setContactValue($contactValue)
            ->setExtension($extension)
            ->setActive($active)
            ->setCreateDate($createDate);
    }
    /**
     * Get ContactID value
     * @return int|null
     */
    public function getContactID()
    {
        return $this->ContactID;
    }
    /**
     * Set ContactID value
     * @param int $contactID
     * @return \StructType\ContactInfo
     */
    public function setContactID($contactID = null)
    {
        // validation for constraint: int
        if (!is_null($contactID) && !(is_int($contactID) || ctype_digit($contactID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contactID, true), gettype($contactID)), __LINE__);
        }
        $this->ContactID = $contactID;
        return $this;
    }
    /**
     * Get ContactTypeID value
     * @return int|null
     */
    public function getContactTypeID()
    {
        return $this->ContactTypeID;
    }
    /**
     * Set ContactTypeID value
     * @param int $contactTypeID
     * @return \StructType\ContactInfo
     */
    public function setContactTypeID($contactTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($contactTypeID) && !(is_int($contactTypeID) || ctype_digit($contactTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contactTypeID, true), gettype($contactTypeID)), __LINE__);
        }
        $this->ContactTypeID = $contactTypeID;
        return $this;
    }
    /**
     * Get ContactName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactName()
    {
        return isset($this->ContactName) ? $this->ContactName : null;
    }
    /**
     * Set ContactName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactName
     * @return \StructType\ContactInfo
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        if (is_null($contactName) || (is_array($contactName) && empty($contactName))) {
            unset($this->ContactName);
        } else {
            $this->ContactName = $contactName;
        }
        return $this;
    }
    /**
     * Get ContactValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactValue()
    {
        return isset($this->ContactValue) ? $this->ContactValue : null;
    }
    /**
     * Set ContactValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactValue
     * @return \StructType\ContactInfo
     */
    public function setContactValue($contactValue = null)
    {
        // validation for constraint: string
        if (!is_null($contactValue) && !is_string($contactValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactValue, true), gettype($contactValue)), __LINE__);
        }
        if (is_null($contactValue) || (is_array($contactValue) && empty($contactValue))) {
            unset($this->ContactValue);
        } else {
            $this->ContactValue = $contactValue;
        }
        return $this;
    }
    /**
     * Get Extension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtension()
    {
        return isset($this->Extension) ? $this->Extension : null;
    }
    /**
     * Set Extension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extension
     * @return \StructType\ContactInfo
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extension, true), gettype($extension)), __LINE__);
        }
        if (is_null($extension) || (is_array($extension) && empty($extension))) {
            unset($this->Extension);
        } else {
            $this->Extension = $extension;
        }
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\ContactInfo
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\ContactInfo
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
}
