<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Company StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Company
 * @subpackage Structs
 */
class Company extends AbstractStructBase
{
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompanyID;
    /**
     * The JobTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JobTitle;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyName;
    /**
     * The IndustrySector
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IndustrySector;
    /**
     * The CompanySize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanySize;
    /**
     * The CompanyLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompanyLocation;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * Constructor method for Company
     * @uses Company::setCompanyID()
     * @uses Company::setJobTitle()
     * @uses Company::setCompanyName()
     * @uses Company::setIndustrySector()
     * @uses Company::setCompanySize()
     * @uses Company::setCompanyLocation()
     * @uses Company::setActive()
     * @param int $companyID
     * @param string $jobTitle
     * @param string $companyName
     * @param string $industrySector
     * @param string $companySize
     * @param int $companyLocation
     * @param bool $active
     */
    public function __construct($companyID = null, $jobTitle = null, $companyName = null, $industrySector = null, $companySize = null, $companyLocation = null, $active = null)
    {
        $this
            ->setCompanyID($companyID)
            ->setJobTitle($jobTitle)
            ->setCompanyName($companyName)
            ->setIndustrySector($industrySector)
            ->setCompanySize($companySize)
            ->setCompanyLocation($companyLocation)
            ->setActive($active);
    }
    /**
     * Get CompanyID value
     * @return int|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \StructType\Company
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !(is_int($companyID) || ctype_digit($companyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get JobTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJobTitle()
    {
        return isset($this->JobTitle) ? $this->JobTitle : null;
    }
    /**
     * Set JobTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jobTitle
     * @return \StructType\Company
     */
    public function setJobTitle($jobTitle = null)
    {
        // validation for constraint: string
        if (!is_null($jobTitle) && !is_string($jobTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobTitle, true), gettype($jobTitle)), __LINE__);
        }
        if (is_null($jobTitle) || (is_array($jobTitle) && empty($jobTitle))) {
            unset($this->JobTitle);
        } else {
            $this->JobTitle = $jobTitle;
        }
        return $this;
    }
    /**
     * Get CompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyName()
    {
        return isset($this->CompanyName) ? $this->CompanyName : null;
    }
    /**
     * Set CompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyName
     * @return \StructType\Company
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        if (is_null($companyName) || (is_array($companyName) && empty($companyName))) {
            unset($this->CompanyName);
        } else {
            $this->CompanyName = $companyName;
        }
        return $this;
    }
    /**
     * Get IndustrySector value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndustrySector()
    {
        return isset($this->IndustrySector) ? $this->IndustrySector : null;
    }
    /**
     * Set IndustrySector value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $industrySector
     * @return \StructType\Company
     */
    public function setIndustrySector($industrySector = null)
    {
        // validation for constraint: string
        if (!is_null($industrySector) && !is_string($industrySector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($industrySector, true), gettype($industrySector)), __LINE__);
        }
        if (is_null($industrySector) || (is_array($industrySector) && empty($industrySector))) {
            unset($this->IndustrySector);
        } else {
            $this->IndustrySector = $industrySector;
        }
        return $this;
    }
    /**
     * Get CompanySize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanySize()
    {
        return isset($this->CompanySize) ? $this->CompanySize : null;
    }
    /**
     * Set CompanySize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companySize
     * @return \StructType\Company
     */
    public function setCompanySize($companySize = null)
    {
        // validation for constraint: string
        if (!is_null($companySize) && !is_string($companySize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companySize, true), gettype($companySize)), __LINE__);
        }
        if (is_null($companySize) || (is_array($companySize) && empty($companySize))) {
            unset($this->CompanySize);
        } else {
            $this->CompanySize = $companySize;
        }
        return $this;
    }
    /**
     * Get CompanyLocation value
     * @return int|null
     */
    public function getCompanyLocation()
    {
        return $this->CompanyLocation;
    }
    /**
     * Set CompanyLocation value
     * @param int $companyLocation
     * @return \StructType\Company
     */
    public function setCompanyLocation($companyLocation = null)
    {
        // validation for constraint: int
        if (!is_null($companyLocation) && !(is_int($companyLocation) || ctype_digit($companyLocation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyLocation, true), gettype($companyLocation)), __LINE__);
        }
        $this->CompanyLocation = $companyLocation;
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\Company
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
}
