<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBuddyList ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfBuddyList
 * @subpackage Arrays
 */
class ArrayOfBuddyList extends AbstractStructArrayBase
{
    /**
     * The BuddyList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BuddyList[]
     */
    public $BuddyList;
    /**
     * Constructor method for ArrayOfBuddyList
     * @uses ArrayOfBuddyList::setBuddyList()
     * @param \StructType\BuddyList[] $buddyList
     */
    public function __construct(array $buddyList = array())
    {
        $this
            ->setBuddyList($buddyList);
    }
    /**
     * Get BuddyList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BuddyList[]|null
     */
    public function getBuddyList()
    {
        return isset($this->BuddyList) ? $this->BuddyList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBuddyList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBuddyList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBuddyListForArrayConstraintsFromSetBuddyList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBuddyListBuddyListItem) {
            // validation for constraint: itemType
            if (!$arrayOfBuddyListBuddyListItem instanceof \StructType\BuddyList) {
                $invalidValues[] = is_object($arrayOfBuddyListBuddyListItem) ? get_class($arrayOfBuddyListBuddyListItem) : sprintf('%s(%s)', gettype($arrayOfBuddyListBuddyListItem), var_export($arrayOfBuddyListBuddyListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BuddyList property can only contain items of type \StructType\BuddyList, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BuddyList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BuddyList[] $buddyList
     * @return \ArrayType\ArrayOfBuddyList
     */
    public function setBuddyList(array $buddyList = array())
    {
        // validation for constraint: array
        if ('' !== ($buddyListArrayErrorMessage = self::validateBuddyListForArrayConstraintsFromSetBuddyList($buddyList))) {
            throw new \InvalidArgumentException($buddyListArrayErrorMessage, __LINE__);
        }
        if (is_null($buddyList) || (is_array($buddyList) && empty($buddyList))) {
            unset($this->BuddyList);
        } else {
            $this->BuddyList = $buddyList;
        }
        return $this;
    }
    /**
     * Add item to BuddyList value
     * @throws \InvalidArgumentException
     * @param \StructType\BuddyList $item
     * @return \ArrayType\ArrayOfBuddyList
     */
    public function addToBuddyList(\StructType\BuddyList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BuddyList) {
            throw new \InvalidArgumentException(sprintf('The BuddyList property can only contain items of type \StructType\BuddyList, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BuddyList[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BuddyList|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BuddyList|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BuddyList|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BuddyList|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BuddyList|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BuddyList
     */
    public function getAttributeName()
    {
        return 'BuddyList';
    }
}
