<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://rdxappint.radixxuat.com/RDX/Radixx.ConnectPoint/ConnectPoint.Profiles.svc?singleWSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://rdxappint.radixxuat.com/RDX/Radixx.ConnectPoint/ConnectPoint.Profiles.svc?singleWSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Retrieve ServiceType
 */
$retrieve = new \ServiceType\Retrieve($options);
/**
 * Sample call for RetrieveProfile operation/method
 */
if ($retrieve->RetrieveProfile(new \StructType\RetrieveProfile()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveProfileReservations operation/method
 */
if ($retrieve->RetrieveProfileReservations(new \StructType\RetrieveProfileReservations()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveProfileVouchers operation/method
 */
if ($retrieve->RetrieveProfileVouchers(new \StructType\RetrieveProfileVouchers()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for CreateProfile operation/method
 */
if ($create->CreateProfile(new \StructType\CreateProfile()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Forgotten ServiceType
 */
$forgotten = new \ServiceType\Forgotten($options);
/**
 * Sample call for ForgottenPassword operation/method
 */
if ($forgotten->ForgottenPassword(new \StructType\ForgottenPassword()) !== false) {
    print_r($forgotten->getResult());
} else {
    print_r($forgotten->getLastError());
}
/**
 * Samples for Modify ServiceType
 */
$modify = new \ServiceType\Modify($options);
/**
 * Sample call for ModifyProfilePassword operation/method
 */
if ($modify->ModifyProfilePassword(new \StructType\ModifyProfilePassword()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for CheckForExistingProfileEmail operation/method
 */
if ($check->CheckForExistingProfileEmail(new \StructType\CheckForExistingProfileEmail()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetProfileReservations operation/method
 */
if ($get->GetProfileReservations(new \StructType\GetProfileReservations()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \ServiceType\Validate($options);
/**
 * Sample call for ValidateProfile operation/method
 */
if ($validate->ValidateProfile(new \StructType\ValidateProfile()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
