<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileVoucher StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProfileVoucher
 * @subpackage Structs
 */
class ProfileVoucher extends AbstractStructBase
{
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserId;
    /**
     * The ProfileId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProfileId;
    /**
     * The VoucherNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VoucherNum;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReasonCode;
    /**
     * The VoucherReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VoucherReason;
    /**
     * The SeriesNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesNum;
    /**
     * The ConfirmationNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmationNum;
    /**
     * The Sponsor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sponsor;
    /**
     * The VoucherType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VoucherType;
    /**
     * The TripType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TripType;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationDate;
    /**
     * The TravelEffectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TravelEffectiveDate;
    /**
     * The TravelExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TravelExpirationDate;
    /**
     * The StartTimeRestrict
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartTimeRestrict;
    /**
     * The EndTimeRestrict
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EndTimeRestrict;
    /**
     * The OriginalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $OriginalAmount;
    /**
     * The BalanceAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BalanceAmount;
    /**
     * The NonTransferable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NonTransferable;
    /**
     * The IncludesTaxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludesTaxes;
    /**
     * The IncludesSsr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludesSsr;
    /**
     * The IncludesAuto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludesAuto;
    /**
     * The IncludesHotel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludesHotel;
    /**
     * The IncludesPenalties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludesPenalties;
    /**
     * The RestrictSunday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RestrictSunday;
    /**
     * The RestrictMonday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RestrictMonday;
    /**
     * The RestrictTueday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RestrictTueday;
    /**
     * The RestrictWednesday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RestrictWednesday;
    /**
     * The RestrictThursday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RestrictThursday;
    /**
     * The RestrictFriday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RestrictFriday;
    /**
     * The RestrictSaturday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RestrictSaturday;
    /**
     * The VoucherNumberFull
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VoucherNumberFull;
    /**
     * The MinimumValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MinimumValue;
    /**
     * The WebBookingOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $WebBookingOnly;
    /**
     * The PromotionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PromotionCode;
    /**
     * The VoucherComments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VoucherComments;
    /**
     * Constructor method for ProfileVoucher
     * @uses ProfileVoucher::setUserId()
     * @uses ProfileVoucher::setProfileId()
     * @uses ProfileVoucher::setVoucherNum()
     * @uses ProfileVoucher::setCurrencyCode()
     * @uses ProfileVoucher::setReasonCode()
     * @uses ProfileVoucher::setVoucherReason()
     * @uses ProfileVoucher::setSeriesNum()
     * @uses ProfileVoucher::setConfirmationNum()
     * @uses ProfileVoucher::setSponsor()
     * @uses ProfileVoucher::setVoucherType()
     * @uses ProfileVoucher::setTripType()
     * @uses ProfileVoucher::setEffectiveDate()
     * @uses ProfileVoucher::setExpirationDate()
     * @uses ProfileVoucher::setTravelEffectiveDate()
     * @uses ProfileVoucher::setTravelExpirationDate()
     * @uses ProfileVoucher::setStartTimeRestrict()
     * @uses ProfileVoucher::setEndTimeRestrict()
     * @uses ProfileVoucher::setOriginalAmount()
     * @uses ProfileVoucher::setBalanceAmount()
     * @uses ProfileVoucher::setNonTransferable()
     * @uses ProfileVoucher::setIncludesTaxes()
     * @uses ProfileVoucher::setIncludesSsr()
     * @uses ProfileVoucher::setIncludesAuto()
     * @uses ProfileVoucher::setIncludesHotel()
     * @uses ProfileVoucher::setIncludesPenalties()
     * @uses ProfileVoucher::setRestrictSunday()
     * @uses ProfileVoucher::setRestrictMonday()
     * @uses ProfileVoucher::setRestrictTueday()
     * @uses ProfileVoucher::setRestrictWednesday()
     * @uses ProfileVoucher::setRestrictThursday()
     * @uses ProfileVoucher::setRestrictFriday()
     * @uses ProfileVoucher::setRestrictSaturday()
     * @uses ProfileVoucher::setVoucherNumberFull()
     * @uses ProfileVoucher::setMinimumValue()
     * @uses ProfileVoucher::setWebBookingOnly()
     * @uses ProfileVoucher::setPromotionCode()
     * @uses ProfileVoucher::setVoucherComments()
     * @param string $userId
     * @param int $profileId
     * @param int $voucherNum
     * @param string $currencyCode
     * @param string $reasonCode
     * @param string $voucherReason
     * @param string $seriesNum
     * @param string $confirmationNum
     * @param string $sponsor
     * @param int $voucherType
     * @param int $tripType
     * @param string $effectiveDate
     * @param string $expirationDate
     * @param string $travelEffectiveDate
     * @param string $travelExpirationDate
     * @param string $startTimeRestrict
     * @param string $endTimeRestrict
     * @param float $originalAmount
     * @param float $balanceAmount
     * @param int $nonTransferable
     * @param bool $includesTaxes
     * @param bool $includesSsr
     * @param bool $includesAuto
     * @param bool $includesHotel
     * @param bool $includesPenalties
     * @param bool $restrictSunday
     * @param bool $restrictMonday
     * @param bool $restrictTueday
     * @param bool $restrictWednesday
     * @param bool $restrictThursday
     * @param bool $restrictFriday
     * @param bool $restrictSaturday
     * @param string $voucherNumberFull
     * @param float $minimumValue
     * @param bool $webBookingOnly
     * @param string $promotionCode
     * @param string $voucherComments
     */
    public function __construct($userId = null, $profileId = null, $voucherNum = null, $currencyCode = null, $reasonCode = null, $voucherReason = null, $seriesNum = null, $confirmationNum = null, $sponsor = null, $voucherType = null, $tripType = null, $effectiveDate = null, $expirationDate = null, $travelEffectiveDate = null, $travelExpirationDate = null, $startTimeRestrict = null, $endTimeRestrict = null, $originalAmount = null, $balanceAmount = null, $nonTransferable = null, $includesTaxes = null, $includesSsr = null, $includesAuto = null, $includesHotel = null, $includesPenalties = null, $restrictSunday = null, $restrictMonday = null, $restrictTueday = null, $restrictWednesday = null, $restrictThursday = null, $restrictFriday = null, $restrictSaturday = null, $voucherNumberFull = null, $minimumValue = null, $webBookingOnly = null, $promotionCode = null, $voucherComments = null)
    {
        $this
            ->setUserId($userId)
            ->setProfileId($profileId)
            ->setVoucherNum($voucherNum)
            ->setCurrencyCode($currencyCode)
            ->setReasonCode($reasonCode)
            ->setVoucherReason($voucherReason)
            ->setSeriesNum($seriesNum)
            ->setConfirmationNum($confirmationNum)
            ->setSponsor($sponsor)
            ->setVoucherType($voucherType)
            ->setTripType($tripType)
            ->setEffectiveDate($effectiveDate)
            ->setExpirationDate($expirationDate)
            ->setTravelEffectiveDate($travelEffectiveDate)
            ->setTravelExpirationDate($travelExpirationDate)
            ->setStartTimeRestrict($startTimeRestrict)
            ->setEndTimeRestrict($endTimeRestrict)
            ->setOriginalAmount($originalAmount)
            ->setBalanceAmount($balanceAmount)
            ->setNonTransferable($nonTransferable)
            ->setIncludesTaxes($includesTaxes)
            ->setIncludesSsr($includesSsr)
            ->setIncludesAuto($includesAuto)
            ->setIncludesHotel($includesHotel)
            ->setIncludesPenalties($includesPenalties)
            ->setRestrictSunday($restrictSunday)
            ->setRestrictMonday($restrictMonday)
            ->setRestrictTueday($restrictTueday)
            ->setRestrictWednesday($restrictWednesday)
            ->setRestrictThursday($restrictThursday)
            ->setRestrictFriday($restrictFriday)
            ->setRestrictSaturday($restrictSaturday)
            ->setVoucherNumberFull($voucherNumberFull)
            ->setMinimumValue($minimumValue)
            ->setWebBookingOnly($webBookingOnly)
            ->setPromotionCode($promotionCode)
            ->setVoucherComments($voucherComments);
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \StructType\ProfileVoucher
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get ProfileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->ProfileId;
    }
    /**
     * Set ProfileId value
     * @param int $profileId
     * @return \StructType\ProfileVoucher
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !(is_int($profileId) || ctype_digit($profileId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileId, true), gettype($profileId)), __LINE__);
        }
        $this->ProfileId = $profileId;
        return $this;
    }
    /**
     * Get VoucherNum value
     * @return int|null
     */
    public function getVoucherNum()
    {
        return $this->VoucherNum;
    }
    /**
     * Set VoucherNum value
     * @param int $voucherNum
     * @return \StructType\ProfileVoucher
     */
    public function setVoucherNum($voucherNum = null)
    {
        // validation for constraint: int
        if (!is_null($voucherNum) && !(is_int($voucherNum) || ctype_digit($voucherNum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($voucherNum, true), gettype($voucherNum)), __LINE__);
        }
        $this->VoucherNum = $voucherNum;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\ProfileVoucher
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get ReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReasonCode()
    {
        return isset($this->ReasonCode) ? $this->ReasonCode : null;
    }
    /**
     * Set ReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reasonCode
     * @return \StructType\ProfileVoucher
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonCode, true), gettype($reasonCode)), __LINE__);
        }
        if (is_null($reasonCode) || (is_array($reasonCode) && empty($reasonCode))) {
            unset($this->ReasonCode);
        } else {
            $this->ReasonCode = $reasonCode;
        }
        return $this;
    }
    /**
     * Get VoucherReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoucherReason()
    {
        return isset($this->VoucherReason) ? $this->VoucherReason : null;
    }
    /**
     * Set VoucherReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voucherReason
     * @return \StructType\ProfileVoucher
     */
    public function setVoucherReason($voucherReason = null)
    {
        // validation for constraint: string
        if (!is_null($voucherReason) && !is_string($voucherReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherReason, true), gettype($voucherReason)), __LINE__);
        }
        if (is_null($voucherReason) || (is_array($voucherReason) && empty($voucherReason))) {
            unset($this->VoucherReason);
        } else {
            $this->VoucherReason = $voucherReason;
        }
        return $this;
    }
    /**
     * Get SeriesNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesNum()
    {
        return isset($this->SeriesNum) ? $this->SeriesNum : null;
    }
    /**
     * Set SeriesNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesNum
     * @return \StructType\ProfileVoucher
     */
    public function setSeriesNum($seriesNum = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNum) && !is_string($seriesNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNum, true), gettype($seriesNum)), __LINE__);
        }
        if (is_null($seriesNum) || (is_array($seriesNum) && empty($seriesNum))) {
            unset($this->SeriesNum);
        } else {
            $this->SeriesNum = $seriesNum;
        }
        return $this;
    }
    /**
     * Get ConfirmationNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmationNum()
    {
        return isset($this->ConfirmationNum) ? $this->ConfirmationNum : null;
    }
    /**
     * Set ConfirmationNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $confirmationNum
     * @return \StructType\ProfileVoucher
     */
    public function setConfirmationNum($confirmationNum = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNum) && !is_string($confirmationNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNum, true), gettype($confirmationNum)), __LINE__);
        }
        if (is_null($confirmationNum) || (is_array($confirmationNum) && empty($confirmationNum))) {
            unset($this->ConfirmationNum);
        } else {
            $this->ConfirmationNum = $confirmationNum;
        }
        return $this;
    }
    /**
     * Get Sponsor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSponsor()
    {
        return isset($this->Sponsor) ? $this->Sponsor : null;
    }
    /**
     * Set Sponsor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sponsor
     * @return \StructType\ProfileVoucher
     */
    public function setSponsor($sponsor = null)
    {
        // validation for constraint: string
        if (!is_null($sponsor) && !is_string($sponsor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sponsor, true), gettype($sponsor)), __LINE__);
        }
        if (is_null($sponsor) || (is_array($sponsor) && empty($sponsor))) {
            unset($this->Sponsor);
        } else {
            $this->Sponsor = $sponsor;
        }
        return $this;
    }
    /**
     * Get VoucherType value
     * @return int|null
     */
    public function getVoucherType()
    {
        return $this->VoucherType;
    }
    /**
     * Set VoucherType value
     * @param int $voucherType
     * @return \StructType\ProfileVoucher
     */
    public function setVoucherType($voucherType = null)
    {
        // validation for constraint: int
        if (!is_null($voucherType) && !(is_int($voucherType) || ctype_digit($voucherType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($voucherType, true), gettype($voucherType)), __LINE__);
        }
        $this->VoucherType = $voucherType;
        return $this;
    }
    /**
     * Get TripType value
     * @return int|null
     */
    public function getTripType()
    {
        return $this->TripType;
    }
    /**
     * Set TripType value
     * @param int $tripType
     * @return \StructType\ProfileVoucher
     */
    public function setTripType($tripType = null)
    {
        // validation for constraint: int
        if (!is_null($tripType) && !(is_int($tripType) || ctype_digit($tripType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tripType, true), gettype($tripType)), __LINE__);
        }
        $this->TripType = $tripType;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\ProfileVoucher
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\ProfileVoucher
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get TravelEffectiveDate value
     * @return string|null
     */
    public function getTravelEffectiveDate()
    {
        return $this->TravelEffectiveDate;
    }
    /**
     * Set TravelEffectiveDate value
     * @param string $travelEffectiveDate
     * @return \StructType\ProfileVoucher
     */
    public function setTravelEffectiveDate($travelEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($travelEffectiveDate) && !is_string($travelEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelEffectiveDate, true), gettype($travelEffectiveDate)), __LINE__);
        }
        $this->TravelEffectiveDate = $travelEffectiveDate;
        return $this;
    }
    /**
     * Get TravelExpirationDate value
     * @return string|null
     */
    public function getTravelExpirationDate()
    {
        return $this->TravelExpirationDate;
    }
    /**
     * Set TravelExpirationDate value
     * @param string $travelExpirationDate
     * @return \StructType\ProfileVoucher
     */
    public function setTravelExpirationDate($travelExpirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($travelExpirationDate) && !is_string($travelExpirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelExpirationDate, true), gettype($travelExpirationDate)), __LINE__);
        }
        $this->TravelExpirationDate = $travelExpirationDate;
        return $this;
    }
    /**
     * Get StartTimeRestrict value
     * @return string|null
     */
    public function getStartTimeRestrict()
    {
        return $this->StartTimeRestrict;
    }
    /**
     * Set StartTimeRestrict value
     * @param string $startTimeRestrict
     * @return \StructType\ProfileVoucher
     */
    public function setStartTimeRestrict($startTimeRestrict = null)
    {
        // validation for constraint: string
        if (!is_null($startTimeRestrict) && !is_string($startTimeRestrict)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTimeRestrict, true), gettype($startTimeRestrict)), __LINE__);
        }
        $this->StartTimeRestrict = $startTimeRestrict;
        return $this;
    }
    /**
     * Get EndTimeRestrict value
     * @return string|null
     */
    public function getEndTimeRestrict()
    {
        return $this->EndTimeRestrict;
    }
    /**
     * Set EndTimeRestrict value
     * @param string $endTimeRestrict
     * @return \StructType\ProfileVoucher
     */
    public function setEndTimeRestrict($endTimeRestrict = null)
    {
        // validation for constraint: string
        if (!is_null($endTimeRestrict) && !is_string($endTimeRestrict)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endTimeRestrict, true), gettype($endTimeRestrict)), __LINE__);
        }
        $this->EndTimeRestrict = $endTimeRestrict;
        return $this;
    }
    /**
     * Get OriginalAmount value
     * @return float|null
     */
    public function getOriginalAmount()
    {
        return $this->OriginalAmount;
    }
    /**
     * Set OriginalAmount value
     * @param float $originalAmount
     * @return \StructType\ProfileVoucher
     */
    public function setOriginalAmount($originalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($originalAmount) && !(is_float($originalAmount) || is_numeric($originalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($originalAmount, true), gettype($originalAmount)), __LINE__);
        }
        $this->OriginalAmount = $originalAmount;
        return $this;
    }
    /**
     * Get BalanceAmount value
     * @return float|null
     */
    public function getBalanceAmount()
    {
        return $this->BalanceAmount;
    }
    /**
     * Set BalanceAmount value
     * @param float $balanceAmount
     * @return \StructType\ProfileVoucher
     */
    public function setBalanceAmount($balanceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($balanceAmount) && !(is_float($balanceAmount) || is_numeric($balanceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balanceAmount, true), gettype($balanceAmount)), __LINE__);
        }
        $this->BalanceAmount = $balanceAmount;
        return $this;
    }
    /**
     * Get NonTransferable value
     * @return int|null
     */
    public function getNonTransferable()
    {
        return $this->NonTransferable;
    }
    /**
     * Set NonTransferable value
     * @param int $nonTransferable
     * @return \StructType\ProfileVoucher
     */
    public function setNonTransferable($nonTransferable = null)
    {
        // validation for constraint: int
        if (!is_null($nonTransferable) && !(is_int($nonTransferable) || ctype_digit($nonTransferable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nonTransferable, true), gettype($nonTransferable)), __LINE__);
        }
        $this->NonTransferable = $nonTransferable;
        return $this;
    }
    /**
     * Get IncludesTaxes value
     * @return bool|null
     */
    public function getIncludesTaxes()
    {
        return $this->IncludesTaxes;
    }
    /**
     * Set IncludesTaxes value
     * @param bool $includesTaxes
     * @return \StructType\ProfileVoucher
     */
    public function setIncludesTaxes($includesTaxes = null)
    {
        // validation for constraint: boolean
        if (!is_null($includesTaxes) && !is_bool($includesTaxes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includesTaxes, true), gettype($includesTaxes)), __LINE__);
        }
        $this->IncludesTaxes = $includesTaxes;
        return $this;
    }
    /**
     * Get IncludesSsr value
     * @return bool|null
     */
    public function getIncludesSsr()
    {
        return $this->IncludesSsr;
    }
    /**
     * Set IncludesSsr value
     * @param bool $includesSsr
     * @return \StructType\ProfileVoucher
     */
    public function setIncludesSsr($includesSsr = null)
    {
        // validation for constraint: boolean
        if (!is_null($includesSsr) && !is_bool($includesSsr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includesSsr, true), gettype($includesSsr)), __LINE__);
        }
        $this->IncludesSsr = $includesSsr;
        return $this;
    }
    /**
     * Get IncludesAuto value
     * @return bool|null
     */
    public function getIncludesAuto()
    {
        return $this->IncludesAuto;
    }
    /**
     * Set IncludesAuto value
     * @param bool $includesAuto
     * @return \StructType\ProfileVoucher
     */
    public function setIncludesAuto($includesAuto = null)
    {
        // validation for constraint: boolean
        if (!is_null($includesAuto) && !is_bool($includesAuto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includesAuto, true), gettype($includesAuto)), __LINE__);
        }
        $this->IncludesAuto = $includesAuto;
        return $this;
    }
    /**
     * Get IncludesHotel value
     * @return bool|null
     */
    public function getIncludesHotel()
    {
        return $this->IncludesHotel;
    }
    /**
     * Set IncludesHotel value
     * @param bool $includesHotel
     * @return \StructType\ProfileVoucher
     */
    public function setIncludesHotel($includesHotel = null)
    {
        // validation for constraint: boolean
        if (!is_null($includesHotel) && !is_bool($includesHotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includesHotel, true), gettype($includesHotel)), __LINE__);
        }
        $this->IncludesHotel = $includesHotel;
        return $this;
    }
    /**
     * Get IncludesPenalties value
     * @return bool|null
     */
    public function getIncludesPenalties()
    {
        return $this->IncludesPenalties;
    }
    /**
     * Set IncludesPenalties value
     * @param bool $includesPenalties
     * @return \StructType\ProfileVoucher
     */
    public function setIncludesPenalties($includesPenalties = null)
    {
        // validation for constraint: boolean
        if (!is_null($includesPenalties) && !is_bool($includesPenalties)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includesPenalties, true), gettype($includesPenalties)), __LINE__);
        }
        $this->IncludesPenalties = $includesPenalties;
        return $this;
    }
    /**
     * Get RestrictSunday value
     * @return bool|null
     */
    public function getRestrictSunday()
    {
        return $this->RestrictSunday;
    }
    /**
     * Set RestrictSunday value
     * @param bool $restrictSunday
     * @return \StructType\ProfileVoucher
     */
    public function setRestrictSunday($restrictSunday = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictSunday) && !is_bool($restrictSunday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restrictSunday, true), gettype($restrictSunday)), __LINE__);
        }
        $this->RestrictSunday = $restrictSunday;
        return $this;
    }
    /**
     * Get RestrictMonday value
     * @return bool|null
     */
    public function getRestrictMonday()
    {
        return $this->RestrictMonday;
    }
    /**
     * Set RestrictMonday value
     * @param bool $restrictMonday
     * @return \StructType\ProfileVoucher
     */
    public function setRestrictMonday($restrictMonday = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictMonday) && !is_bool($restrictMonday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restrictMonday, true), gettype($restrictMonday)), __LINE__);
        }
        $this->RestrictMonday = $restrictMonday;
        return $this;
    }
    /**
     * Get RestrictTueday value
     * @return bool|null
     */
    public function getRestrictTueday()
    {
        return $this->RestrictTueday;
    }
    /**
     * Set RestrictTueday value
     * @param bool $restrictTueday
     * @return \StructType\ProfileVoucher
     */
    public function setRestrictTueday($restrictTueday = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictTueday) && !is_bool($restrictTueday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restrictTueday, true), gettype($restrictTueday)), __LINE__);
        }
        $this->RestrictTueday = $restrictTueday;
        return $this;
    }
    /**
     * Get RestrictWednesday value
     * @return bool|null
     */
    public function getRestrictWednesday()
    {
        return $this->RestrictWednesday;
    }
    /**
     * Set RestrictWednesday value
     * @param bool $restrictWednesday
     * @return \StructType\ProfileVoucher
     */
    public function setRestrictWednesday($restrictWednesday = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictWednesday) && !is_bool($restrictWednesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restrictWednesday, true), gettype($restrictWednesday)), __LINE__);
        }
        $this->RestrictWednesday = $restrictWednesday;
        return $this;
    }
    /**
     * Get RestrictThursday value
     * @return bool|null
     */
    public function getRestrictThursday()
    {
        return $this->RestrictThursday;
    }
    /**
     * Set RestrictThursday value
     * @param bool $restrictThursday
     * @return \StructType\ProfileVoucher
     */
    public function setRestrictThursday($restrictThursday = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictThursday) && !is_bool($restrictThursday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restrictThursday, true), gettype($restrictThursday)), __LINE__);
        }
        $this->RestrictThursday = $restrictThursday;
        return $this;
    }
    /**
     * Get RestrictFriday value
     * @return bool|null
     */
    public function getRestrictFriday()
    {
        return $this->RestrictFriday;
    }
    /**
     * Set RestrictFriday value
     * @param bool $restrictFriday
     * @return \StructType\ProfileVoucher
     */
    public function setRestrictFriday($restrictFriday = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictFriday) && !is_bool($restrictFriday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restrictFriday, true), gettype($restrictFriday)), __LINE__);
        }
        $this->RestrictFriday = $restrictFriday;
        return $this;
    }
    /**
     * Get RestrictSaturday value
     * @return bool|null
     */
    public function getRestrictSaturday()
    {
        return $this->RestrictSaturday;
    }
    /**
     * Set RestrictSaturday value
     * @param bool $restrictSaturday
     * @return \StructType\ProfileVoucher
     */
    public function setRestrictSaturday($restrictSaturday = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictSaturday) && !is_bool($restrictSaturday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restrictSaturday, true), gettype($restrictSaturday)), __LINE__);
        }
        $this->RestrictSaturday = $restrictSaturday;
        return $this;
    }
    /**
     * Get VoucherNumberFull value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoucherNumberFull()
    {
        return isset($this->VoucherNumberFull) ? $this->VoucherNumberFull : null;
    }
    /**
     * Set VoucherNumberFull value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voucherNumberFull
     * @return \StructType\ProfileVoucher
     */
    public function setVoucherNumberFull($voucherNumberFull = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNumberFull) && !is_string($voucherNumberFull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNumberFull, true), gettype($voucherNumberFull)), __LINE__);
        }
        if (is_null($voucherNumberFull) || (is_array($voucherNumberFull) && empty($voucherNumberFull))) {
            unset($this->VoucherNumberFull);
        } else {
            $this->VoucherNumberFull = $voucherNumberFull;
        }
        return $this;
    }
    /**
     * Get MinimumValue value
     * @return float|null
     */
    public function getMinimumValue()
    {
        return $this->MinimumValue;
    }
    /**
     * Set MinimumValue value
     * @param float $minimumValue
     * @return \StructType\ProfileVoucher
     */
    public function setMinimumValue($minimumValue = null)
    {
        // validation for constraint: float
        if (!is_null($minimumValue) && !(is_float($minimumValue) || is_numeric($minimumValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimumValue, true), gettype($minimumValue)), __LINE__);
        }
        $this->MinimumValue = $minimumValue;
        return $this;
    }
    /**
     * Get WebBookingOnly value
     * @return bool|null
     */
    public function getWebBookingOnly()
    {
        return $this->WebBookingOnly;
    }
    /**
     * Set WebBookingOnly value
     * @param bool $webBookingOnly
     * @return \StructType\ProfileVoucher
     */
    public function setWebBookingOnly($webBookingOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($webBookingOnly) && !is_bool($webBookingOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($webBookingOnly, true), gettype($webBookingOnly)), __LINE__);
        }
        $this->WebBookingOnly = $webBookingOnly;
        return $this;
    }
    /**
     * Get PromotionCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromotionCode()
    {
        return isset($this->PromotionCode) ? $this->PromotionCode : null;
    }
    /**
     * Set PromotionCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promotionCode
     * @return \StructType\ProfileVoucher
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        if (is_null($promotionCode) || (is_array($promotionCode) && empty($promotionCode))) {
            unset($this->PromotionCode);
        } else {
            $this->PromotionCode = $promotionCode;
        }
        return $this;
    }
    /**
     * Get VoucherComments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoucherComments()
    {
        return isset($this->VoucherComments) ? $this->VoucherComments : null;
    }
    /**
     * Set VoucherComments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voucherComments
     * @return \StructType\ProfileVoucher
     */
    public function setVoucherComments($voucherComments = null)
    {
        // validation for constraint: string
        if (!is_null($voucherComments) && !is_string($voucherComments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherComments, true), gettype($voucherComments)), __LINE__);
        }
        if (is_null($voucherComments) || (is_array($voucherComments) && empty($voucherComments))) {
            unset($this->VoucherComments);
        } else {
            $this->VoucherComments = $voucherComments;
        }
        return $this;
    }
}
