<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProfileReservations StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetProfileReservations
 * @subpackage Structs
 */
class GetProfileReservations extends TransactionInfo
{
    /**
     * The GetProfileReservationsRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GetProfileReservations
     */
    public $GetProfileReservationsRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ProfileID
     * @var int
     */
    public $ProfileID;
    /**
     * The Active
     * @var bool
     */
    public $Active;
    /**
     * The GetProfileReservations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfGetProfileReservation
     */
    public $GetProfileReservations;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for GetProfileReservations
     * @uses GetProfileReservations::setGetProfileReservationsRequest()
     * @uses GetProfileReservations::setActionType()
     * @uses GetProfileReservations::setProfileID()
     * @uses GetProfileReservations::setActive()
     * @uses GetProfileReservations::setGetProfileReservations()
     * @uses GetProfileReservations::setExceptions()
     * @param \StructType\GetProfileReservations $getProfileReservationsRequest
     * @param string $actionType
     * @param int $profileID
     * @param bool $active
     * @param \ArrayType\ArrayOfGetProfileReservation $getProfileReservations
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct(\StructType\GetProfileReservations $getProfileReservationsRequest = null, $actionType = null, $profileID = null, $active = null, \ArrayType\ArrayOfGetProfileReservation $getProfileReservations = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setGetProfileReservationsRequest($getProfileReservationsRequest)
            ->setActionType($actionType)
            ->setProfileID($profileID)
            ->setActive($active)
            ->setGetProfileReservations($getProfileReservations)
            ->setExceptions($exceptions);
    }
    /**
     * Get GetProfileReservationsRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GetProfileReservations|null
     */
    public function getGetProfileReservationsRequest()
    {
        return isset($this->GetProfileReservationsRequest) ? $this->GetProfileReservationsRequest : null;
    }
    /**
     * Set GetProfileReservationsRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GetProfileReservations $getProfileReservationsRequest
     * @return \StructType\GetProfileReservations
     */
    public function setGetProfileReservationsRequest(\StructType\GetProfileReservations $getProfileReservationsRequest = null)
    {
        if (is_null($getProfileReservationsRequest) || (is_array($getProfileReservationsRequest) && empty($getProfileReservationsRequest))) {
            unset($this->GetProfileReservationsRequest);
        } else {
            $this->GetProfileReservationsRequest = $getProfileReservationsRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\RetrieveProfileReservations_ActionTypes::valueIsValid()
     * @uses \EnumType\RetrieveProfileReservations_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\GetProfileReservations
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RetrieveProfileReservations_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RetrieveProfileReservations_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\RetrieveProfileReservations_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ProfileID value
     * @return int|null
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param int $profileID
     * @return \StructType\GetProfileReservations
     */
    public function setProfileID($profileID = null)
    {
        // validation for constraint: int
        if (!is_null($profileID) && !(is_int($profileID) || ctype_digit($profileID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileID, true), gettype($profileID)), __LINE__);
        }
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\GetProfileReservations
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get GetProfileReservations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfGetProfileReservation|null
     */
    public function getGetProfileReservations()
    {
        return isset($this->GetProfileReservations) ? $this->GetProfileReservations : null;
    }
    /**
     * Set GetProfileReservations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfGetProfileReservation $getProfileReservations
     * @return \StructType\GetProfileReservations
     */
    public function setGetProfileReservations(\ArrayType\ArrayOfGetProfileReservation $getProfileReservations = null)
    {
        if (is_null($getProfileReservations) || (is_array($getProfileReservations) && empty($getProfileReservations))) {
            unset($this->GetProfileReservations);
        } else {
            $this->GetProfileReservations = $getProfileReservations;
        }
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\GetProfileReservations
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
}
