<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceQuote StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ServiceQuote
 * @subpackage Structs
 */
class ServiceQuote extends AbstractStructBase
{
    /**
     * The LogicalFlightID
     * @var int
     */
    public $LogicalFlightID;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The AirportCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AirportCode;
    /**
     * The ServiceCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ServiceCode;
    /**
     * The Cabin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Cabin;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Category;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The UTCOffset
     * @var int
     */
    public $UTCOffset;
    /**
     * The OperatingCarrierCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OperatingCarrierCode;
    /**
     * The MarketingCarrierCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $MarketingCarrierCode;
    /**
     * The FareClass
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FareClass;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FareBasisCode;
    /**
     * The ReservationChannel
     * @var string
     */
    public $ReservationChannel;
    /**
     * The DestinationAirportCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DestinationAirportCode;
    /**
     * The ServiceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $ServiceTypes;
    /**
     * Constructor method for ServiceQuote
     * @uses ServiceQuote::setLogicalFlightID()
     * @uses ServiceQuote::setDepartureDate()
     * @uses ServiceQuote::setAirportCode()
     * @uses ServiceQuote::setServiceCode()
     * @uses ServiceQuote::setCabin()
     * @uses ServiceQuote::setCategory()
     * @uses ServiceQuote::setCurrency()
     * @uses ServiceQuote::setUTCOffset()
     * @uses ServiceQuote::setOperatingCarrierCode()
     * @uses ServiceQuote::setMarketingCarrierCode()
     * @uses ServiceQuote::setFareClass()
     * @uses ServiceQuote::setFareBasisCode()
     * @uses ServiceQuote::setReservationChannel()
     * @uses ServiceQuote::setDestinationAirportCode()
     * @uses ServiceQuote::setServiceTypes()
     * @param int $logicalFlightID
     * @param string $departureDate
     * @param string $airportCode
     * @param string $serviceCode
     * @param string $cabin
     * @param string $category
     * @param string $currency
     * @param int $uTCOffset
     * @param string $operatingCarrierCode
     * @param string $marketingCarrierCode
     * @param string $fareClass
     * @param string $fareBasisCode
     * @param string $reservationChannel
     * @param string $destinationAirportCode
     * @param \ArrayType\ArrayOfint $serviceTypes
     */
    public function __construct($logicalFlightID = null, $departureDate = null, $airportCode = null, $serviceCode = null, $cabin = null, $category = null, $currency = null, $uTCOffset = null, $operatingCarrierCode = null, $marketingCarrierCode = null, $fareClass = null, $fareBasisCode = null, $reservationChannel = null, $destinationAirportCode = null, \ArrayType\ArrayOfint $serviceTypes = null)
    {
        $this
            ->setLogicalFlightID($logicalFlightID)
            ->setDepartureDate($departureDate)
            ->setAirportCode($airportCode)
            ->setServiceCode($serviceCode)
            ->setCabin($cabin)
            ->setCategory($category)
            ->setCurrency($currency)
            ->setUTCOffset($uTCOffset)
            ->setOperatingCarrierCode($operatingCarrierCode)
            ->setMarketingCarrierCode($marketingCarrierCode)
            ->setFareClass($fareClass)
            ->setFareBasisCode($fareBasisCode)
            ->setReservationChannel($reservationChannel)
            ->setDestinationAirportCode($destinationAirportCode)
            ->setServiceTypes($serviceTypes);
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\ServiceQuote
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\ServiceQuote
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get AirportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->AirportCode;
    }
    /**
     * Set AirportCode value
     * @param string $airportCode
     * @return \StructType\ServiceQuote
     */
    public function setAirportCode($airportCode = null)
    {
        // validation for constraint: string
        if (!is_null($airportCode) && !is_string($airportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airportCode, true), gettype($airportCode)), __LINE__);
        }
        $this->AirportCode = $airportCode;
        return $this;
    }
    /**
     * Get ServiceCode value
     * @return string|null
     */
    public function getServiceCode()
    {
        return $this->ServiceCode;
    }
    /**
     * Set ServiceCode value
     * @param string $serviceCode
     * @return \StructType\ServiceQuote
     */
    public function setServiceCode($serviceCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCode) && !is_string($serviceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceCode, true), gettype($serviceCode)), __LINE__);
        }
        $this->ServiceCode = $serviceCode;
        return $this;
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param string $cabin
     * @return \StructType\ServiceQuote
     */
    public function setCabin($cabin = null)
    {
        // validation for constraint: string
        if (!is_null($cabin) && !is_string($cabin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabin, true), gettype($cabin)), __LINE__);
        }
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\ServiceQuote
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\ServiceQuote
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($currency) ? implode(', ', $currency) : var_export($currency, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get UTCOffset value
     * @return int|null
     */
    public function getUTCOffset()
    {
        return $this->UTCOffset;
    }
    /**
     * Set UTCOffset value
     * @param int $uTCOffset
     * @return \StructType\ServiceQuote
     */
    public function setUTCOffset($uTCOffset = null)
    {
        // validation for constraint: int
        if (!is_null($uTCOffset) && !(is_int($uTCOffset) || ctype_digit($uTCOffset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uTCOffset, true), gettype($uTCOffset)), __LINE__);
        }
        $this->UTCOffset = $uTCOffset;
        return $this;
    }
    /**
     * Get OperatingCarrierCode value
     * @return string|null
     */
    public function getOperatingCarrierCode()
    {
        return $this->OperatingCarrierCode;
    }
    /**
     * Set OperatingCarrierCode value
     * @param string $operatingCarrierCode
     * @return \StructType\ServiceQuote
     */
    public function setOperatingCarrierCode($operatingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCarrierCode) && !is_string($operatingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingCarrierCode, true), gettype($operatingCarrierCode)), __LINE__);
        }
        $this->OperatingCarrierCode = $operatingCarrierCode;
        return $this;
    }
    /**
     * Get MarketingCarrierCode value
     * @return string|null
     */
    public function getMarketingCarrierCode()
    {
        return $this->MarketingCarrierCode;
    }
    /**
     * Set MarketingCarrierCode value
     * @param string $marketingCarrierCode
     * @return \StructType\ServiceQuote
     */
    public function setMarketingCarrierCode($marketingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCarrierCode) && !is_string($marketingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketingCarrierCode, true), gettype($marketingCarrierCode)), __LINE__);
        }
        $this->MarketingCarrierCode = $marketingCarrierCode;
        return $this;
    }
    /**
     * Get FareClass value
     * @return string|null
     */
    public function getFareClass()
    {
        return $this->FareClass;
    }
    /**
     * Set FareClass value
     * @param string $fareClass
     * @return \StructType\ServiceQuote
     */
    public function setFareClass($fareClass = null)
    {
        // validation for constraint: string
        if (!is_null($fareClass) && !is_string($fareClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareClass, true), gettype($fareClass)), __LINE__);
        }
        $this->FareClass = $fareClass;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\ServiceQuote
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get ReservationChannel value
     * @return string|null
     */
    public function getReservationChannel()
    {
        return $this->ReservationChannel;
    }
    /**
     * Set ReservationChannel value
     * @uses \EnumType\Enumerations_ReservationChannelTypes::valueIsValid()
     * @uses \EnumType\Enumerations_ReservationChannelTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservationChannel
     * @return \StructType\ServiceQuote
     */
    public function setReservationChannel($reservationChannel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_ReservationChannelTypes::valueIsValid($reservationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_ReservationChannelTypes', is_array($reservationChannel) ? implode(', ', $reservationChannel) : var_export($reservationChannel, true), implode(', ', \EnumType\Enumerations_ReservationChannelTypes::getValidValues())), __LINE__);
        }
        $this->ReservationChannel = $reservationChannel;
        return $this;
    }
    /**
     * Get DestinationAirportCode value
     * @return string|null
     */
    public function getDestinationAirportCode()
    {
        return $this->DestinationAirportCode;
    }
    /**
     * Set DestinationAirportCode value
     * @param string $destinationAirportCode
     * @return \StructType\ServiceQuote
     */
    public function setDestinationAirportCode($destinationAirportCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAirportCode) && !is_string($destinationAirportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationAirportCode, true), gettype($destinationAirportCode)), __LINE__);
        }
        $this->DestinationAirportCode = $destinationAirportCode;
        return $this;
    }
    /**
     * Get ServiceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getServiceTypes()
    {
        return isset($this->ServiceTypes) ? $this->ServiceTypes : null;
    }
    /**
     * Set ServiceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $serviceTypes
     * @return \StructType\ServiceQuote
     */
    public function setServiceTypes(\ArrayType\ArrayOfint $serviceTypes = null)
    {
        if (is_null($serviceTypes) || (is_array($serviceTypes) && empty($serviceTypes))) {
            unset($this->ServiceTypes);
        } else {
            $this->ServiceTypes = $serviceTypes;
        }
        return $this;
    }
}
