<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetriveServiceBundleDetailsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetriveServiceBundleDetailsRequest
 * @subpackage Structs
 */
class RetriveServiceBundleDetailsRequest extends TransactionInfo
{
    /**
     * The ServiceBundleCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceBundleCode;
    /**
     * Constructor method for RetriveServiceBundleDetailsRequest
     * @uses RetriveServiceBundleDetailsRequest::setServiceBundleCode()
     * @param string $serviceBundleCode
     */
    public function __construct($serviceBundleCode = null)
    {
        $this
            ->setServiceBundleCode($serviceBundleCode);
    }
    /**
     * Get ServiceBundleCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceBundleCode()
    {
        return isset($this->ServiceBundleCode) ? $this->ServiceBundleCode : null;
    }
    /**
     * Set ServiceBundleCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceBundleCode
     * @return \StructType\RetriveServiceBundleDetailsRequest
     */
    public function setServiceBundleCode($serviceBundleCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceBundleCode) && !is_string($serviceBundleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceBundleCode, true), gettype($serviceBundleCode)), __LINE__);
        }
        if (is_null($serviceBundleCode) || (is_array($serviceBundleCode) && empty($serviceBundleCode))) {
            unset($this->ServiceBundleCode);
        } else {
            $this->ServiceBundleCode = $serviceBundleCode;
        }
        return $this;
    }
}
