<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FastFareSearchTripDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FastFareSearchTripDetail
 * @subpackage Structs
 */
class FastFareSearchTripDetail extends AbstractStructBase
{
    /**
     * The DepartureLocation
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DepartureLocation;
    /**
     * The ArrivalLocation
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ArrivalLocation;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The NumberOfFlexibleDaysBefore
     * @var int
     */
    public $NumberOfFlexibleDaysBefore;
    /**
     * The NumberOfFlexibleDaysAfter
     * @var int
     */
    public $NumberOfFlexibleDaysAfter;
    /**
     * The DepartureDateBeginRange
     * @var string
     */
    public $DepartureDateBeginRange;
    /**
     * The DepartureDateEndRange
     * @var string
     */
    public $DepartureDateEndRange;
    /**
     * The TripOrderIndex
     * @var int
     */
    public $TripOrderIndex;
    /**
     * The MinimumTripLength
     * @var int
     */
    public $MinimumTripLength;
    /**
     * The FastFareSearchTravelerInfos
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfFastFareSearchTravelerInfo
     */
    public $FastFareSearchTravelerInfos;
    /**
     * The OverrideEffectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OverrideEffectiveDate;
    /**
     * The PrivateFareOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrivateFareOption;
    /**
     * Constructor method for FastFareSearchTripDetail
     * @uses FastFareSearchTripDetail::setDepartureLocation()
     * @uses FastFareSearchTripDetail::setArrivalLocation()
     * @uses FastFareSearchTripDetail::setDepartureDate()
     * @uses FastFareSearchTripDetail::setNumberOfFlexibleDaysBefore()
     * @uses FastFareSearchTripDetail::setNumberOfFlexibleDaysAfter()
     * @uses FastFareSearchTripDetail::setDepartureDateBeginRange()
     * @uses FastFareSearchTripDetail::setDepartureDateEndRange()
     * @uses FastFareSearchTripDetail::setTripOrderIndex()
     * @uses FastFareSearchTripDetail::setMinimumTripLength()
     * @uses FastFareSearchTripDetail::setFastFareSearchTravelerInfos()
     * @uses FastFareSearchTripDetail::setOverrideEffectiveDate()
     * @uses FastFareSearchTripDetail::setPrivateFareOption()
     * @param string $departureLocation
     * @param string $arrivalLocation
     * @param string $departureDate
     * @param int $numberOfFlexibleDaysBefore
     * @param int $numberOfFlexibleDaysAfter
     * @param string $departureDateBeginRange
     * @param string $departureDateEndRange
     * @param int $tripOrderIndex
     * @param int $minimumTripLength
     * @param \ArrayType\ArrayOfFastFareSearchTravelerInfo $fastFareSearchTravelerInfos
     * @param string $overrideEffectiveDate
     * @param int $privateFareOption
     */
    public function __construct($departureLocation = null, $arrivalLocation = null, $departureDate = null, $numberOfFlexibleDaysBefore = null, $numberOfFlexibleDaysAfter = null, $departureDateBeginRange = null, $departureDateEndRange = null, $tripOrderIndex = null, $minimumTripLength = null, \ArrayType\ArrayOfFastFareSearchTravelerInfo $fastFareSearchTravelerInfos = null, $overrideEffectiveDate = null, $privateFareOption = null)
    {
        $this
            ->setDepartureLocation($departureLocation)
            ->setArrivalLocation($arrivalLocation)
            ->setDepartureDate($departureDate)
            ->setNumberOfFlexibleDaysBefore($numberOfFlexibleDaysBefore)
            ->setNumberOfFlexibleDaysAfter($numberOfFlexibleDaysAfter)
            ->setDepartureDateBeginRange($departureDateBeginRange)
            ->setDepartureDateEndRange($departureDateEndRange)
            ->setTripOrderIndex($tripOrderIndex)
            ->setMinimumTripLength($minimumTripLength)
            ->setFastFareSearchTravelerInfos($fastFareSearchTravelerInfos)
            ->setOverrideEffectiveDate($overrideEffectiveDate)
            ->setPrivateFareOption($privateFareOption);
    }
    /**
     * Get DepartureLocation value
     * @return string|null
     */
    public function getDepartureLocation()
    {
        return $this->DepartureLocation;
    }
    /**
     * Set DepartureLocation value
     * @param string $departureLocation
     * @return \StructType\FastFareSearchTripDetail
     */
    public function setDepartureLocation($departureLocation = null)
    {
        // validation for constraint: string
        if (!is_null($departureLocation) && !is_string($departureLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureLocation, true), gettype($departureLocation)), __LINE__);
        }
        $this->DepartureLocation = $departureLocation;
        return $this;
    }
    /**
     * Get ArrivalLocation value
     * @return string|null
     */
    public function getArrivalLocation()
    {
        return $this->ArrivalLocation;
    }
    /**
     * Set ArrivalLocation value
     * @param string $arrivalLocation
     * @return \StructType\FastFareSearchTripDetail
     */
    public function setArrivalLocation($arrivalLocation = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalLocation) && !is_string($arrivalLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalLocation, true), gettype($arrivalLocation)), __LINE__);
        }
        $this->ArrivalLocation = $arrivalLocation;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\FastFareSearchTripDetail
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get NumberOfFlexibleDaysBefore value
     * @return int|null
     */
    public function getNumberOfFlexibleDaysBefore()
    {
        return $this->NumberOfFlexibleDaysBefore;
    }
    /**
     * Set NumberOfFlexibleDaysBefore value
     * @param int $numberOfFlexibleDaysBefore
     * @return \StructType\FastFareSearchTripDetail
     */
    public function setNumberOfFlexibleDaysBefore($numberOfFlexibleDaysBefore = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfFlexibleDaysBefore) && !(is_int($numberOfFlexibleDaysBefore) || ctype_digit($numberOfFlexibleDaysBefore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfFlexibleDaysBefore, true), gettype($numberOfFlexibleDaysBefore)), __LINE__);
        }
        $this->NumberOfFlexibleDaysBefore = $numberOfFlexibleDaysBefore;
        return $this;
    }
    /**
     * Get NumberOfFlexibleDaysAfter value
     * @return int|null
     */
    public function getNumberOfFlexibleDaysAfter()
    {
        return $this->NumberOfFlexibleDaysAfter;
    }
    /**
     * Set NumberOfFlexibleDaysAfter value
     * @param int $numberOfFlexibleDaysAfter
     * @return \StructType\FastFareSearchTripDetail
     */
    public function setNumberOfFlexibleDaysAfter($numberOfFlexibleDaysAfter = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfFlexibleDaysAfter) && !(is_int($numberOfFlexibleDaysAfter) || ctype_digit($numberOfFlexibleDaysAfter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfFlexibleDaysAfter, true), gettype($numberOfFlexibleDaysAfter)), __LINE__);
        }
        $this->NumberOfFlexibleDaysAfter = $numberOfFlexibleDaysAfter;
        return $this;
    }
    /**
     * Get DepartureDateBeginRange value
     * @return string|null
     */
    public function getDepartureDateBeginRange()
    {
        return $this->DepartureDateBeginRange;
    }
    /**
     * Set DepartureDateBeginRange value
     * @param string $departureDateBeginRange
     * @return \StructType\FastFareSearchTripDetail
     */
    public function setDepartureDateBeginRange($departureDateBeginRange = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateBeginRange) && !is_string($departureDateBeginRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDateBeginRange, true), gettype($departureDateBeginRange)), __LINE__);
        }
        $this->DepartureDateBeginRange = $departureDateBeginRange;
        return $this;
    }
    /**
     * Get DepartureDateEndRange value
     * @return string|null
     */
    public function getDepartureDateEndRange()
    {
        return $this->DepartureDateEndRange;
    }
    /**
     * Set DepartureDateEndRange value
     * @param string $departureDateEndRange
     * @return \StructType\FastFareSearchTripDetail
     */
    public function setDepartureDateEndRange($departureDateEndRange = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateEndRange) && !is_string($departureDateEndRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDateEndRange, true), gettype($departureDateEndRange)), __LINE__);
        }
        $this->DepartureDateEndRange = $departureDateEndRange;
        return $this;
    }
    /**
     * Get TripOrderIndex value
     * @return int|null
     */
    public function getTripOrderIndex()
    {
        return $this->TripOrderIndex;
    }
    /**
     * Set TripOrderIndex value
     * @param int $tripOrderIndex
     * @return \StructType\FastFareSearchTripDetail
     */
    public function setTripOrderIndex($tripOrderIndex = null)
    {
        // validation for constraint: int
        if (!is_null($tripOrderIndex) && !(is_int($tripOrderIndex) || ctype_digit($tripOrderIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tripOrderIndex, true), gettype($tripOrderIndex)), __LINE__);
        }
        $this->TripOrderIndex = $tripOrderIndex;
        return $this;
    }
    /**
     * Get MinimumTripLength value
     * @return int|null
     */
    public function getMinimumTripLength()
    {
        return $this->MinimumTripLength;
    }
    /**
     * Set MinimumTripLength value
     * @param int $minimumTripLength
     * @return \StructType\FastFareSearchTripDetail
     */
    public function setMinimumTripLength($minimumTripLength = null)
    {
        // validation for constraint: int
        if (!is_null($minimumTripLength) && !(is_int($minimumTripLength) || ctype_digit($minimumTripLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumTripLength, true), gettype($minimumTripLength)), __LINE__);
        }
        $this->MinimumTripLength = $minimumTripLength;
        return $this;
    }
    /**
     * Get FastFareSearchTravelerInfos value
     * @return \ArrayType\ArrayOfFastFareSearchTravelerInfo|null
     */
    public function getFastFareSearchTravelerInfos()
    {
        return $this->FastFareSearchTravelerInfos;
    }
    /**
     * Set FastFareSearchTravelerInfos value
     * @param \ArrayType\ArrayOfFastFareSearchTravelerInfo $fastFareSearchTravelerInfos
     * @return \StructType\FastFareSearchTripDetail
     */
    public function setFastFareSearchTravelerInfos(\ArrayType\ArrayOfFastFareSearchTravelerInfo $fastFareSearchTravelerInfos = null)
    {
        $this->FastFareSearchTravelerInfos = $fastFareSearchTravelerInfos;
        return $this;
    }
    /**
     * Get OverrideEffectiveDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOverrideEffectiveDate()
    {
        return isset($this->OverrideEffectiveDate) ? $this->OverrideEffectiveDate : null;
    }
    /**
     * Set OverrideEffectiveDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $overrideEffectiveDate
     * @return \StructType\FastFareSearchTripDetail
     */
    public function setOverrideEffectiveDate($overrideEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($overrideEffectiveDate) && !is_string($overrideEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overrideEffectiveDate, true), gettype($overrideEffectiveDate)), __LINE__);
        }
        if (is_null($overrideEffectiveDate) || (is_array($overrideEffectiveDate) && empty($overrideEffectiveDate))) {
            unset($this->OverrideEffectiveDate);
        } else {
            $this->OverrideEffectiveDate = $overrideEffectiveDate;
        }
        return $this;
    }
    /**
     * Get PrivateFareOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrivateFareOption()
    {
        return isset($this->PrivateFareOption) ? $this->PrivateFareOption : null;
    }
    /**
     * Set PrivateFareOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $privateFareOption
     * @return \StructType\FastFareSearchTripDetail
     */
    public function setPrivateFareOption($privateFareOption = null)
    {
        // validation for constraint: int
        if (!is_null($privateFareOption) && !(is_int($privateFareOption) || ctype_digit($privateFareOption))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($privateFareOption, true), gettype($privateFareOption)), __LINE__);
        }
        if (is_null($privateFareOption) || (is_array($privateFareOption) && empty($privateFareOption))) {
            unset($this->PrivateFareOption);
        } else {
            $this->PrivateFareOption = $privateFareOption;
        }
        return $this;
    }
}
