<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareTypeInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FareTypeInfo
 * @subpackage Structs
 */
class FareTypeInfo extends AbstractStructBase
{
    /**
     * The FareTypeIdentifier
     * @var int
     */
    public $FareTypeIdentifier;
    /**
     * The FareTypeName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FareTypeName;
    /**
     * The ApplicableFareInfos
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfApplicableFareInfo
     */
    public $ApplicableFareInfos;
    /**
     * Constructor method for FareTypeInfo
     * @uses FareTypeInfo::setFareTypeIdentifier()
     * @uses FareTypeInfo::setFareTypeName()
     * @uses FareTypeInfo::setApplicableFareInfos()
     * @param int $fareTypeIdentifier
     * @param string $fareTypeName
     * @param \ArrayType\ArrayOfApplicableFareInfo $applicableFareInfos
     */
    public function __construct($fareTypeIdentifier = null, $fareTypeName = null, \ArrayType\ArrayOfApplicableFareInfo $applicableFareInfos = null)
    {
        $this
            ->setFareTypeIdentifier($fareTypeIdentifier)
            ->setFareTypeName($fareTypeName)
            ->setApplicableFareInfos($applicableFareInfos);
    }
    /**
     * Get FareTypeIdentifier value
     * @return int|null
     */
    public function getFareTypeIdentifier()
    {
        return $this->FareTypeIdentifier;
    }
    /**
     * Set FareTypeIdentifier value
     * @param int $fareTypeIdentifier
     * @return \StructType\FareTypeInfo
     */
    public function setFareTypeIdentifier($fareTypeIdentifier = null)
    {
        // validation for constraint: int
        if (!is_null($fareTypeIdentifier) && !(is_int($fareTypeIdentifier) || ctype_digit($fareTypeIdentifier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fareTypeIdentifier, true), gettype($fareTypeIdentifier)), __LINE__);
        }
        $this->FareTypeIdentifier = $fareTypeIdentifier;
        return $this;
    }
    /**
     * Get FareTypeName value
     * @return string|null
     */
    public function getFareTypeName()
    {
        return $this->FareTypeName;
    }
    /**
     * Set FareTypeName value
     * @param string $fareTypeName
     * @return \StructType\FareTypeInfo
     */
    public function setFareTypeName($fareTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($fareTypeName) && !is_string($fareTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareTypeName, true), gettype($fareTypeName)), __LINE__);
        }
        $this->FareTypeName = $fareTypeName;
        return $this;
    }
    /**
     * Get ApplicableFareInfos value
     * @return \ArrayType\ArrayOfApplicableFareInfo|null
     */
    public function getApplicableFareInfos()
    {
        return $this->ApplicableFareInfos;
    }
    /**
     * Set ApplicableFareInfos value
     * @param \ArrayType\ArrayOfApplicableFareInfo $applicableFareInfos
     * @return \StructType\FareTypeInfo
     */
    public function setApplicableFareInfos(\ArrayType\ArrayOfApplicableFareInfo $applicableFareInfos = null)
    {
        $this->ApplicableFareInfos = $applicableFareInfos;
        return $this;
    }
}
