<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareShopAdjustmentDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FareShopAdjustmentDetail
 * @subpackage Structs
 */
class FareShopAdjustmentDetail extends AbstractStructBase
{
    /**
     * The Cabin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Cabin;
    /**
     * The DateOfDeparture
     * @var string
     */
    public $DateOfDeparture;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FareBasisCode;
    /**
     * The FareClass
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FareClass;
    /**
     * The FareID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FareID;
    /**
     * The LFID
     * @var int
     */
    public $LFID;
    /**
     * The Level
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Level;
    /**
     * The MarketingCarrierCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $MarketingCarrierCode;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The OutgoingFlightSegmentOrigin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OutgoingFlightSegmentOrigin;
    /**
     * The OverrideEffectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OverrideEffectiveDate;
    /**
     * The OverrideFareAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $OverrideFareAmount;
    /**
     * The PassengerTypeID
     * @var int
     */
    public $PassengerTypeID;
    /**
     * The RoundTrip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RoundTrip;
    /**
     * The RoundTripFare
     * @var bool
     */
    public $RoundTripFare;
    /**
     * Constructor method for FareShopAdjustmentDetail
     * @uses FareShopAdjustmentDetail::setCabin()
     * @uses FareShopAdjustmentDetail::setDateOfDeparture()
     * @uses FareShopAdjustmentDetail::setDestination()
     * @uses FareShopAdjustmentDetail::setFareBasisCode()
     * @uses FareShopAdjustmentDetail::setFareClass()
     * @uses FareShopAdjustmentDetail::setFareID()
     * @uses FareShopAdjustmentDetail::setLFID()
     * @uses FareShopAdjustmentDetail::setLevel()
     * @uses FareShopAdjustmentDetail::setMarketingCarrierCode()
     * @uses FareShopAdjustmentDetail::setOrigin()
     * @uses FareShopAdjustmentDetail::setOutgoingFlightSegmentOrigin()
     * @uses FareShopAdjustmentDetail::setOverrideEffectiveDate()
     * @uses FareShopAdjustmentDetail::setOverrideFareAmount()
     * @uses FareShopAdjustmentDetail::setPassengerTypeID()
     * @uses FareShopAdjustmentDetail::setRoundTrip()
     * @uses FareShopAdjustmentDetail::setRoundTripFare()
     * @param string $cabin
     * @param string $dateOfDeparture
     * @param string $destination
     * @param string $fareBasisCode
     * @param string $fareClass
     * @param int $fareID
     * @param int $lFID
     * @param string $level
     * @param string $marketingCarrierCode
     * @param string $origin
     * @param string $outgoingFlightSegmentOrigin
     * @param string $overrideEffectiveDate
     * @param float $overrideFareAmount
     * @param int $passengerTypeID
     * @param bool $roundTrip
     * @param bool $roundTripFare
     */
    public function __construct($cabin = null, $dateOfDeparture = null, $destination = null, $fareBasisCode = null, $fareClass = null, $fareID = null, $lFID = null, $level = null, $marketingCarrierCode = null, $origin = null, $outgoingFlightSegmentOrigin = null, $overrideEffectiveDate = null, $overrideFareAmount = null, $passengerTypeID = null, $roundTrip = null, $roundTripFare = null)
    {
        $this
            ->setCabin($cabin)
            ->setDateOfDeparture($dateOfDeparture)
            ->setDestination($destination)
            ->setFareBasisCode($fareBasisCode)
            ->setFareClass($fareClass)
            ->setFareID($fareID)
            ->setLFID($lFID)
            ->setLevel($level)
            ->setMarketingCarrierCode($marketingCarrierCode)
            ->setOrigin($origin)
            ->setOutgoingFlightSegmentOrigin($outgoingFlightSegmentOrigin)
            ->setOverrideEffectiveDate($overrideEffectiveDate)
            ->setOverrideFareAmount($overrideFareAmount)
            ->setPassengerTypeID($passengerTypeID)
            ->setRoundTrip($roundTrip)
            ->setRoundTripFare($roundTripFare);
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param string $cabin
     * @return \StructType\FareShopAdjustmentDetail
     */
    public function setCabin($cabin = null)
    {
        // validation for constraint: string
        if (!is_null($cabin) && !is_string($cabin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabin, true), gettype($cabin)), __LINE__);
        }
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get DateOfDeparture value
     * @return string|null
     */
    public function getDateOfDeparture()
    {
        return $this->DateOfDeparture;
    }
    /**
     * Set DateOfDeparture value
     * @param string $dateOfDeparture
     * @return \StructType\FareShopAdjustmentDetail
     */
    public function setDateOfDeparture($dateOfDeparture = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfDeparture) && !is_string($dateOfDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfDeparture, true), gettype($dateOfDeparture)), __LINE__);
        }
        $this->DateOfDeparture = $dateOfDeparture;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \StructType\FareShopAdjustmentDetail
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\FareShopAdjustmentDetail
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get FareClass value
     * @return string|null
     */
    public function getFareClass()
    {
        return $this->FareClass;
    }
    /**
     * Set FareClass value
     * @param string $fareClass
     * @return \StructType\FareShopAdjustmentDetail
     */
    public function setFareClass($fareClass = null)
    {
        // validation for constraint: string
        if (!is_null($fareClass) && !is_string($fareClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareClass, true), gettype($fareClass)), __LINE__);
        }
        $this->FareClass = $fareClass;
        return $this;
    }
    /**
     * Get FareID value
     * @return int|null
     */
    public function getFareID()
    {
        return $this->FareID;
    }
    /**
     * Set FareID value
     * @param int $fareID
     * @return \StructType\FareShopAdjustmentDetail
     */
    public function setFareID($fareID = null)
    {
        // validation for constraint: int
        if (!is_null($fareID) && !(is_int($fareID) || ctype_digit($fareID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fareID, true), gettype($fareID)), __LINE__);
        }
        $this->FareID = $fareID;
        return $this;
    }
    /**
     * Get LFID value
     * @return int|null
     */
    public function getLFID()
    {
        return $this->LFID;
    }
    /**
     * Set LFID value
     * @param int $lFID
     * @return \StructType\FareShopAdjustmentDetail
     */
    public function setLFID($lFID = null)
    {
        // validation for constraint: int
        if (!is_null($lFID) && !(is_int($lFID) || ctype_digit($lFID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lFID, true), gettype($lFID)), __LINE__);
        }
        $this->LFID = $lFID;
        return $this;
    }
    /**
     * Get Level value
     * @return string|null
     */
    public function getLevel()
    {
        return $this->Level;
    }
    /**
     * Set Level value
     * @uses \EnumType\AdjustmentLevel::valueIsValid()
     * @uses \EnumType\AdjustmentLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $level
     * @return \StructType\FareShopAdjustmentDetail
     */
    public function setLevel($level = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdjustmentLevel::valueIsValid($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdjustmentLevel', is_array($level) ? implode(', ', $level) : var_export($level, true), implode(', ', \EnumType\AdjustmentLevel::getValidValues())), __LINE__);
        }
        $this->Level = $level;
        return $this;
    }
    /**
     * Get MarketingCarrierCode value
     * @return string|null
     */
    public function getMarketingCarrierCode()
    {
        return $this->MarketingCarrierCode;
    }
    /**
     * Set MarketingCarrierCode value
     * @param string $marketingCarrierCode
     * @return \StructType\FareShopAdjustmentDetail
     */
    public function setMarketingCarrierCode($marketingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCarrierCode) && !is_string($marketingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketingCarrierCode, true), gettype($marketingCarrierCode)), __LINE__);
        }
        $this->MarketingCarrierCode = $marketingCarrierCode;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\FareShopAdjustmentDetail
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get OutgoingFlightSegmentOrigin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOutgoingFlightSegmentOrigin()
    {
        return isset($this->OutgoingFlightSegmentOrigin) ? $this->OutgoingFlightSegmentOrigin : null;
    }
    /**
     * Set OutgoingFlightSegmentOrigin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $outgoingFlightSegmentOrigin
     * @return \StructType\FareShopAdjustmentDetail
     */
    public function setOutgoingFlightSegmentOrigin($outgoingFlightSegmentOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($outgoingFlightSegmentOrigin) && !is_string($outgoingFlightSegmentOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outgoingFlightSegmentOrigin, true), gettype($outgoingFlightSegmentOrigin)), __LINE__);
        }
        if (is_null($outgoingFlightSegmentOrigin) || (is_array($outgoingFlightSegmentOrigin) && empty($outgoingFlightSegmentOrigin))) {
            unset($this->OutgoingFlightSegmentOrigin);
        } else {
            $this->OutgoingFlightSegmentOrigin = $outgoingFlightSegmentOrigin;
        }
        return $this;
    }
    /**
     * Get OverrideEffectiveDate value
     * @return string|null
     */
    public function getOverrideEffectiveDate()
    {
        return $this->OverrideEffectiveDate;
    }
    /**
     * Set OverrideEffectiveDate value
     * @param string $overrideEffectiveDate
     * @return \StructType\FareShopAdjustmentDetail
     */
    public function setOverrideEffectiveDate($overrideEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($overrideEffectiveDate) && !is_string($overrideEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overrideEffectiveDate, true), gettype($overrideEffectiveDate)), __LINE__);
        }
        $this->OverrideEffectiveDate = $overrideEffectiveDate;
        return $this;
    }
    /**
     * Get OverrideFareAmount value
     * @return float|null
     */
    public function getOverrideFareAmount()
    {
        return $this->OverrideFareAmount;
    }
    /**
     * Set OverrideFareAmount value
     * @param float $overrideFareAmount
     * @return \StructType\FareShopAdjustmentDetail
     */
    public function setOverrideFareAmount($overrideFareAmount = null)
    {
        // validation for constraint: float
        if (!is_null($overrideFareAmount) && !(is_float($overrideFareAmount) || is_numeric($overrideFareAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($overrideFareAmount, true), gettype($overrideFareAmount)), __LINE__);
        }
        $this->OverrideFareAmount = $overrideFareAmount;
        return $this;
    }
    /**
     * Get PassengerTypeID value
     * @return int|null
     */
    public function getPassengerTypeID()
    {
        return $this->PassengerTypeID;
    }
    /**
     * Set PassengerTypeID value
     * @param int $passengerTypeID
     * @return \StructType\FareShopAdjustmentDetail
     */
    public function setPassengerTypeID($passengerTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($passengerTypeID) && !(is_int($passengerTypeID) || ctype_digit($passengerTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passengerTypeID, true), gettype($passengerTypeID)), __LINE__);
        }
        $this->PassengerTypeID = $passengerTypeID;
        return $this;
    }
    /**
     * Get RoundTrip value
     * @return bool|null
     */
    public function getRoundTrip()
    {
        return $this->RoundTrip;
    }
    /**
     * Set RoundTrip value
     * @param bool $roundTrip
     * @return \StructType\FareShopAdjustmentDetail
     */
    public function setRoundTrip($roundTrip = null)
    {
        // validation for constraint: boolean
        if (!is_null($roundTrip) && !is_bool($roundTrip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($roundTrip, true), gettype($roundTrip)), __LINE__);
        }
        $this->RoundTrip = $roundTrip;
        return $this;
    }
    /**
     * Get RoundTripFare value
     * @return bool|null
     */
    public function getRoundTripFare()
    {
        return $this->RoundTripFare;
    }
    /**
     * Set RoundTripFare value
     * @param bool $roundTripFare
     * @return \StructType\FareShopAdjustmentDetail
     */
    public function setRoundTripFare($roundTripFare = null)
    {
        // validation for constraint: boolean
        if (!is_null($roundTripFare) && !is_bool($roundTripFare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($roundTripFare, true), gettype($roundTripFare)), __LINE__);
        }
        $this->RoundTripFare = $roundTripFare;
        return $this;
    }
}
