<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareQuoteDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FareQuoteDetail
 * @subpackage Structs
 */
class FareQuoteDetail extends AbstractStructBase
{
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The UseAirportsNotMetroGroups
     * @var bool
     */
    public $UseAirportsNotMetroGroups;
    /**
     * The UseAirportsNotMetroGroupsAsRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseAirportsNotMetroGroupsAsRule;
    /**
     * The UseAirportsNotMetroGroupsForFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseAirportsNotMetroGroupsForFrom;
    /**
     * The UseAirportsNotMetroGroupsForTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseAirportsNotMetroGroupsForTo;
    /**
     * The DateOfDeparture
     * @var string
     */
    public $DateOfDeparture;
    /**
     * The FareTypeCategory
     * @var int
     */
    public $FareTypeCategory;
    /**
     * The FareClass
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FareClass;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FareBasisCode;
    /**
     * The Cabin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Cabin;
    /**
     * The LFID
     * @var int
     */
    public $LFID;
    /**
     * The OperatingCarrierCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OperatingCarrierCode;
    /**
     * The MarketingCarrierCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $MarketingCarrierCode;
    /**
     * The NumberOfDaysBefore
     * @var int
     */
    public $NumberOfDaysBefore;
    /**
     * The NumberOfDaysAfter
     * @var int
     */
    public $NumberOfDaysAfter;
    /**
     * The LanguageCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LanguageCode;
    /**
     * The TicketPackageID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TicketPackageID;
    /**
     * The FareQuoteRequestInfos
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfFareQuoteRequestInfo
     */
    public $FareQuoteRequestInfos;
    /**
     * The OverrideEffectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OverrideEffectiveDate;
    /**
     * The FareTypeCategories
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $FareTypeCategories;
    /**
     * The ActionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionType;
    /**
     * The LogicalFlightKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LogicalFlightKey;
    /**
     * Constructor method for FareQuoteDetail
     * @uses FareQuoteDetail::setOrigin()
     * @uses FareQuoteDetail::setDestination()
     * @uses FareQuoteDetail::setUseAirportsNotMetroGroups()
     * @uses FareQuoteDetail::setUseAirportsNotMetroGroupsAsRule()
     * @uses FareQuoteDetail::setUseAirportsNotMetroGroupsForFrom()
     * @uses FareQuoteDetail::setUseAirportsNotMetroGroupsForTo()
     * @uses FareQuoteDetail::setDateOfDeparture()
     * @uses FareQuoteDetail::setFareTypeCategory()
     * @uses FareQuoteDetail::setFareClass()
     * @uses FareQuoteDetail::setFareBasisCode()
     * @uses FareQuoteDetail::setCabin()
     * @uses FareQuoteDetail::setLFID()
     * @uses FareQuoteDetail::setOperatingCarrierCode()
     * @uses FareQuoteDetail::setMarketingCarrierCode()
     * @uses FareQuoteDetail::setNumberOfDaysBefore()
     * @uses FareQuoteDetail::setNumberOfDaysAfter()
     * @uses FareQuoteDetail::setLanguageCode()
     * @uses FareQuoteDetail::setTicketPackageID()
     * @uses FareQuoteDetail::setFareQuoteRequestInfos()
     * @uses FareQuoteDetail::setOverrideEffectiveDate()
     * @uses FareQuoteDetail::setFareTypeCategories()
     * @uses FareQuoteDetail::setActionType()
     * @uses FareQuoteDetail::setLogicalFlightKey()
     * @param string $origin
     * @param string $destination
     * @param bool $useAirportsNotMetroGroups
     * @param bool $useAirportsNotMetroGroupsAsRule
     * @param bool $useAirportsNotMetroGroupsForFrom
     * @param bool $useAirportsNotMetroGroupsForTo
     * @param string $dateOfDeparture
     * @param int $fareTypeCategory
     * @param string $fareClass
     * @param string $fareBasisCode
     * @param string $cabin
     * @param int $lFID
     * @param string $operatingCarrierCode
     * @param string $marketingCarrierCode
     * @param int $numberOfDaysBefore
     * @param int $numberOfDaysAfter
     * @param string $languageCode
     * @param string $ticketPackageID
     * @param \ArrayType\ArrayOfFareQuoteRequestInfo $fareQuoteRequestInfos
     * @param string $overrideEffectiveDate
     * @param \ArrayType\ArrayOfint $fareTypeCategories
     * @param string $actionType
     * @param string $logicalFlightKey
     */
    public function __construct($origin = null, $destination = null, $useAirportsNotMetroGroups = null, $useAirportsNotMetroGroupsAsRule = null, $useAirportsNotMetroGroupsForFrom = null, $useAirportsNotMetroGroupsForTo = null, $dateOfDeparture = null, $fareTypeCategory = null, $fareClass = null, $fareBasisCode = null, $cabin = null, $lFID = null, $operatingCarrierCode = null, $marketingCarrierCode = null, $numberOfDaysBefore = null, $numberOfDaysAfter = null, $languageCode = null, $ticketPackageID = null, \ArrayType\ArrayOfFareQuoteRequestInfo $fareQuoteRequestInfos = null, $overrideEffectiveDate = null, \ArrayType\ArrayOfint $fareTypeCategories = null, $actionType = null, $logicalFlightKey = null)
    {
        $this
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setUseAirportsNotMetroGroups($useAirportsNotMetroGroups)
            ->setUseAirportsNotMetroGroupsAsRule($useAirportsNotMetroGroupsAsRule)
            ->setUseAirportsNotMetroGroupsForFrom($useAirportsNotMetroGroupsForFrom)
            ->setUseAirportsNotMetroGroupsForTo($useAirportsNotMetroGroupsForTo)
            ->setDateOfDeparture($dateOfDeparture)
            ->setFareTypeCategory($fareTypeCategory)
            ->setFareClass($fareClass)
            ->setFareBasisCode($fareBasisCode)
            ->setCabin($cabin)
            ->setLFID($lFID)
            ->setOperatingCarrierCode($operatingCarrierCode)
            ->setMarketingCarrierCode($marketingCarrierCode)
            ->setNumberOfDaysBefore($numberOfDaysBefore)
            ->setNumberOfDaysAfter($numberOfDaysAfter)
            ->setLanguageCode($languageCode)
            ->setTicketPackageID($ticketPackageID)
            ->setFareQuoteRequestInfos($fareQuoteRequestInfos)
            ->setOverrideEffectiveDate($overrideEffectiveDate)
            ->setFareTypeCategories($fareTypeCategories)
            ->setActionType($actionType)
            ->setLogicalFlightKey($logicalFlightKey);
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\FareQuoteDetail
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \StructType\FareQuoteDetail
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get UseAirportsNotMetroGroups value
     * @return bool|null
     */
    public function getUseAirportsNotMetroGroups()
    {
        return $this->UseAirportsNotMetroGroups;
    }
    /**
     * Set UseAirportsNotMetroGroups value
     * @param bool $useAirportsNotMetroGroups
     * @return \StructType\FareQuoteDetail
     */
    public function setUseAirportsNotMetroGroups($useAirportsNotMetroGroups = null)
    {
        // validation for constraint: boolean
        if (!is_null($useAirportsNotMetroGroups) && !is_bool($useAirportsNotMetroGroups)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useAirportsNotMetroGroups, true), gettype($useAirportsNotMetroGroups)), __LINE__);
        }
        $this->UseAirportsNotMetroGroups = $useAirportsNotMetroGroups;
        return $this;
    }
    /**
     * Get UseAirportsNotMetroGroupsAsRule value
     * @return bool|null
     */
    public function getUseAirportsNotMetroGroupsAsRule()
    {
        return $this->UseAirportsNotMetroGroupsAsRule;
    }
    /**
     * Set UseAirportsNotMetroGroupsAsRule value
     * @param bool $useAirportsNotMetroGroupsAsRule
     * @return \StructType\FareQuoteDetail
     */
    public function setUseAirportsNotMetroGroupsAsRule($useAirportsNotMetroGroupsAsRule = null)
    {
        // validation for constraint: boolean
        if (!is_null($useAirportsNotMetroGroupsAsRule) && !is_bool($useAirportsNotMetroGroupsAsRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useAirportsNotMetroGroupsAsRule, true), gettype($useAirportsNotMetroGroupsAsRule)), __LINE__);
        }
        $this->UseAirportsNotMetroGroupsAsRule = $useAirportsNotMetroGroupsAsRule;
        return $this;
    }
    /**
     * Get UseAirportsNotMetroGroupsForFrom value
     * @return bool|null
     */
    public function getUseAirportsNotMetroGroupsForFrom()
    {
        return $this->UseAirportsNotMetroGroupsForFrom;
    }
    /**
     * Set UseAirportsNotMetroGroupsForFrom value
     * @param bool $useAirportsNotMetroGroupsForFrom
     * @return \StructType\FareQuoteDetail
     */
    public function setUseAirportsNotMetroGroupsForFrom($useAirportsNotMetroGroupsForFrom = null)
    {
        // validation for constraint: boolean
        if (!is_null($useAirportsNotMetroGroupsForFrom) && !is_bool($useAirportsNotMetroGroupsForFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useAirportsNotMetroGroupsForFrom, true), gettype($useAirportsNotMetroGroupsForFrom)), __LINE__);
        }
        $this->UseAirportsNotMetroGroupsForFrom = $useAirportsNotMetroGroupsForFrom;
        return $this;
    }
    /**
     * Get UseAirportsNotMetroGroupsForTo value
     * @return bool|null
     */
    public function getUseAirportsNotMetroGroupsForTo()
    {
        return $this->UseAirportsNotMetroGroupsForTo;
    }
    /**
     * Set UseAirportsNotMetroGroupsForTo value
     * @param bool $useAirportsNotMetroGroupsForTo
     * @return \StructType\FareQuoteDetail
     */
    public function setUseAirportsNotMetroGroupsForTo($useAirportsNotMetroGroupsForTo = null)
    {
        // validation for constraint: boolean
        if (!is_null($useAirportsNotMetroGroupsForTo) && !is_bool($useAirportsNotMetroGroupsForTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useAirportsNotMetroGroupsForTo, true), gettype($useAirportsNotMetroGroupsForTo)), __LINE__);
        }
        $this->UseAirportsNotMetroGroupsForTo = $useAirportsNotMetroGroupsForTo;
        return $this;
    }
    /**
     * Get DateOfDeparture value
     * @return string|null
     */
    public function getDateOfDeparture()
    {
        return $this->DateOfDeparture;
    }
    /**
     * Set DateOfDeparture value
     * @param string $dateOfDeparture
     * @return \StructType\FareQuoteDetail
     */
    public function setDateOfDeparture($dateOfDeparture = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfDeparture) && !is_string($dateOfDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfDeparture, true), gettype($dateOfDeparture)), __LINE__);
        }
        $this->DateOfDeparture = $dateOfDeparture;
        return $this;
    }
    /**
     * Get FareTypeCategory value
     * @return int|null
     */
    public function getFareTypeCategory()
    {
        return $this->FareTypeCategory;
    }
    /**
     * Set FareTypeCategory value
     * @param int $fareTypeCategory
     * @return \StructType\FareQuoteDetail
     */
    public function setFareTypeCategory($fareTypeCategory = null)
    {
        // validation for constraint: int
        if (!is_null($fareTypeCategory) && !(is_int($fareTypeCategory) || ctype_digit($fareTypeCategory))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fareTypeCategory, true), gettype($fareTypeCategory)), __LINE__);
        }
        $this->FareTypeCategory = $fareTypeCategory;
        return $this;
    }
    /**
     * Get FareClass value
     * @return string|null
     */
    public function getFareClass()
    {
        return $this->FareClass;
    }
    /**
     * Set FareClass value
     * @param string $fareClass
     * @return \StructType\FareQuoteDetail
     */
    public function setFareClass($fareClass = null)
    {
        // validation for constraint: string
        if (!is_null($fareClass) && !is_string($fareClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareClass, true), gettype($fareClass)), __LINE__);
        }
        $this->FareClass = $fareClass;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\FareQuoteDetail
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param string $cabin
     * @return \StructType\FareQuoteDetail
     */
    public function setCabin($cabin = null)
    {
        // validation for constraint: string
        if (!is_null($cabin) && !is_string($cabin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabin, true), gettype($cabin)), __LINE__);
        }
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get LFID value
     * @return int|null
     */
    public function getLFID()
    {
        return $this->LFID;
    }
    /**
     * Set LFID value
     * @param int $lFID
     * @return \StructType\FareQuoteDetail
     */
    public function setLFID($lFID = null)
    {
        // validation for constraint: int
        if (!is_null($lFID) && !(is_int($lFID) || ctype_digit($lFID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lFID, true), gettype($lFID)), __LINE__);
        }
        $this->LFID = $lFID;
        return $this;
    }
    /**
     * Get OperatingCarrierCode value
     * @return string|null
     */
    public function getOperatingCarrierCode()
    {
        return $this->OperatingCarrierCode;
    }
    /**
     * Set OperatingCarrierCode value
     * @param string $operatingCarrierCode
     * @return \StructType\FareQuoteDetail
     */
    public function setOperatingCarrierCode($operatingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCarrierCode) && !is_string($operatingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingCarrierCode, true), gettype($operatingCarrierCode)), __LINE__);
        }
        $this->OperatingCarrierCode = $operatingCarrierCode;
        return $this;
    }
    /**
     * Get MarketingCarrierCode value
     * @return string|null
     */
    public function getMarketingCarrierCode()
    {
        return $this->MarketingCarrierCode;
    }
    /**
     * Set MarketingCarrierCode value
     * @param string $marketingCarrierCode
     * @return \StructType\FareQuoteDetail
     */
    public function setMarketingCarrierCode($marketingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCarrierCode) && !is_string($marketingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketingCarrierCode, true), gettype($marketingCarrierCode)), __LINE__);
        }
        $this->MarketingCarrierCode = $marketingCarrierCode;
        return $this;
    }
    /**
     * Get NumberOfDaysBefore value
     * @return int|null
     */
    public function getNumberOfDaysBefore()
    {
        return $this->NumberOfDaysBefore;
    }
    /**
     * Set NumberOfDaysBefore value
     * @param int $numberOfDaysBefore
     * @return \StructType\FareQuoteDetail
     */
    public function setNumberOfDaysBefore($numberOfDaysBefore = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDaysBefore) && !(is_int($numberOfDaysBefore) || ctype_digit($numberOfDaysBefore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfDaysBefore, true), gettype($numberOfDaysBefore)), __LINE__);
        }
        $this->NumberOfDaysBefore = $numberOfDaysBefore;
        return $this;
    }
    /**
     * Get NumberOfDaysAfter value
     * @return int|null
     */
    public function getNumberOfDaysAfter()
    {
        return $this->NumberOfDaysAfter;
    }
    /**
     * Set NumberOfDaysAfter value
     * @param int $numberOfDaysAfter
     * @return \StructType\FareQuoteDetail
     */
    public function setNumberOfDaysAfter($numberOfDaysAfter = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDaysAfter) && !(is_int($numberOfDaysAfter) || ctype_digit($numberOfDaysAfter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfDaysAfter, true), gettype($numberOfDaysAfter)), __LINE__);
        }
        $this->NumberOfDaysAfter = $numberOfDaysAfter;
        return $this;
    }
    /**
     * Get LanguageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }
    /**
     * Set LanguageCode value
     * @param string $languageCode
     * @return \StructType\FareQuoteDetail
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCode, true), gettype($languageCode)), __LINE__);
        }
        $this->LanguageCode = $languageCode;
        return $this;
    }
    /**
     * Get TicketPackageID value
     * @return string|null
     */
    public function getTicketPackageID()
    {
        return $this->TicketPackageID;
    }
    /**
     * Set TicketPackageID value
     * @param string $ticketPackageID
     * @return \StructType\FareQuoteDetail
     */
    public function setTicketPackageID($ticketPackageID = null)
    {
        // validation for constraint: string
        if (!is_null($ticketPackageID) && !is_string($ticketPackageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketPackageID, true), gettype($ticketPackageID)), __LINE__);
        }
        $this->TicketPackageID = $ticketPackageID;
        return $this;
    }
    /**
     * Get FareQuoteRequestInfos value
     * @return \ArrayType\ArrayOfFareQuoteRequestInfo|null
     */
    public function getFareQuoteRequestInfos()
    {
        return $this->FareQuoteRequestInfos;
    }
    /**
     * Set FareQuoteRequestInfos value
     * @param \ArrayType\ArrayOfFareQuoteRequestInfo $fareQuoteRequestInfos
     * @return \StructType\FareQuoteDetail
     */
    public function setFareQuoteRequestInfos(\ArrayType\ArrayOfFareQuoteRequestInfo $fareQuoteRequestInfos = null)
    {
        $this->FareQuoteRequestInfos = $fareQuoteRequestInfos;
        return $this;
    }
    /**
     * Get OverrideEffectiveDate value
     * @return string|null
     */
    public function getOverrideEffectiveDate()
    {
        return $this->OverrideEffectiveDate;
    }
    /**
     * Set OverrideEffectiveDate value
     * @param string $overrideEffectiveDate
     * @return \StructType\FareQuoteDetail
     */
    public function setOverrideEffectiveDate($overrideEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($overrideEffectiveDate) && !is_string($overrideEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overrideEffectiveDate, true), gettype($overrideEffectiveDate)), __LINE__);
        }
        $this->OverrideEffectiveDate = $overrideEffectiveDate;
        return $this;
    }
    /**
     * Get FareTypeCategories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getFareTypeCategories()
    {
        return isset($this->FareTypeCategories) ? $this->FareTypeCategories : null;
    }
    /**
     * Set FareTypeCategories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $fareTypeCategories
     * @return \StructType\FareQuoteDetail
     */
    public function setFareTypeCategories(\ArrayType\ArrayOfint $fareTypeCategories = null)
    {
        if (is_null($fareTypeCategories) || (is_array($fareTypeCategories) && empty($fareTypeCategories))) {
            unset($this->FareTypeCategories);
        } else {
            $this->FareTypeCategories = $fareTypeCategories;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\EnumInterlineShoppingAction::valueIsValid()
     * @uses \EnumType\EnumInterlineShoppingAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\FareQuoteDetail
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumInterlineShoppingAction::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumInterlineShoppingAction', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\EnumInterlineShoppingAction::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get LogicalFlightKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogicalFlightKey()
    {
        return isset($this->LogicalFlightKey) ? $this->LogicalFlightKey : null;
    }
    /**
     * Set LogicalFlightKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $logicalFlightKey
     * @return \StructType\FareQuoteDetail
     */
    public function setLogicalFlightKey($logicalFlightKey = null)
    {
        // validation for constraint: string
        if (!is_null($logicalFlightKey) && !is_string($logicalFlightKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logicalFlightKey, true), gettype($logicalFlightKey)), __LINE__);
        }
        if (is_null($logicalFlightKey) || (is_array($logicalFlightKey) && empty($logicalFlightKey))) {
            unset($this->LogicalFlightKey);
        } else {
            $this->LogicalFlightKey = $logicalFlightKey;
        }
        return $this;
    }
}
