<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareAdjustmentBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FareAdjustmentBase
 * @subpackage Structs
 */
class FareAdjustmentBase extends AbstractStructBase
{
    /**
     * The AdjustmentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AdjustmentType;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The Level
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Level;
    /**
     * The OutgoingFlightSegmentOrigin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OutgoingFlightSegmentOrigin;
    /**
     * The RoundTrip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RoundTrip;
    /**
     * Constructor method for FareAdjustmentBase
     * @uses FareAdjustmentBase::setAdjustmentType()
     * @uses FareAdjustmentBase::setAmount()
     * @uses FareAdjustmentBase::setLevel()
     * @uses FareAdjustmentBase::setOutgoingFlightSegmentOrigin()
     * @uses FareAdjustmentBase::setRoundTrip()
     * @param string $adjustmentType
     * @param float $amount
     * @param string $level
     * @param string $outgoingFlightSegmentOrigin
     * @param bool $roundTrip
     */
    public function __construct($adjustmentType = null, $amount = null, $level = null, $outgoingFlightSegmentOrigin = null, $roundTrip = null)
    {
        $this
            ->setAdjustmentType($adjustmentType)
            ->setAmount($amount)
            ->setLevel($level)
            ->setOutgoingFlightSegmentOrigin($outgoingFlightSegmentOrigin)
            ->setRoundTrip($roundTrip);
    }
    /**
     * Get AdjustmentType value
     * @return string|null
     */
    public function getAdjustmentType()
    {
        return $this->AdjustmentType;
    }
    /**
     * Set AdjustmentType value
     * @uses \EnumType\AdjustmentDetailType::valueIsValid()
     * @uses \EnumType\AdjustmentDetailType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $adjustmentType
     * @return \StructType\FareAdjustmentBase
     */
    public function setAdjustmentType($adjustmentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdjustmentDetailType::valueIsValid($adjustmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdjustmentDetailType', is_array($adjustmentType) ? implode(', ', $adjustmentType) : var_export($adjustmentType, true), implode(', ', \EnumType\AdjustmentDetailType::getValidValues())), __LINE__);
        }
        $this->AdjustmentType = $adjustmentType;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\FareAdjustmentBase
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Level value
     * @return string|null
     */
    public function getLevel()
    {
        return $this->Level;
    }
    /**
     * Set Level value
     * @uses \EnumType\AdjustmentLevel::valueIsValid()
     * @uses \EnumType\AdjustmentLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $level
     * @return \StructType\FareAdjustmentBase
     */
    public function setLevel($level = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdjustmentLevel::valueIsValid($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdjustmentLevel', is_array($level) ? implode(', ', $level) : var_export($level, true), implode(', ', \EnumType\AdjustmentLevel::getValidValues())), __LINE__);
        }
        $this->Level = $level;
        return $this;
    }
    /**
     * Get OutgoingFlightSegmentOrigin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOutgoingFlightSegmentOrigin()
    {
        return isset($this->OutgoingFlightSegmentOrigin) ? $this->OutgoingFlightSegmentOrigin : null;
    }
    /**
     * Set OutgoingFlightSegmentOrigin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $outgoingFlightSegmentOrigin
     * @return \StructType\FareAdjustmentBase
     */
    public function setOutgoingFlightSegmentOrigin($outgoingFlightSegmentOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($outgoingFlightSegmentOrigin) && !is_string($outgoingFlightSegmentOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outgoingFlightSegmentOrigin, true), gettype($outgoingFlightSegmentOrigin)), __LINE__);
        }
        if (is_null($outgoingFlightSegmentOrigin) || (is_array($outgoingFlightSegmentOrigin) && empty($outgoingFlightSegmentOrigin))) {
            unset($this->OutgoingFlightSegmentOrigin);
        } else {
            $this->OutgoingFlightSegmentOrigin = $outgoingFlightSegmentOrigin;
        }
        return $this;
    }
    /**
     * Get RoundTrip value
     * @return bool|null
     */
    public function getRoundTrip()
    {
        return $this->RoundTrip;
    }
    /**
     * Set RoundTrip value
     * @param bool $roundTrip
     * @return \StructType\FareAdjustmentBase
     */
    public function setRoundTrip($roundTrip = null)
    {
        // validation for constraint: boolean
        if (!is_null($roundTrip) && !is_bool($roundTrip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($roundTrip, true), gettype($roundTrip)), __LINE__);
        }
        $this->RoundTrip = $roundTrip;
        return $this;
    }
}
