<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAARRequestPtc ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAARRequestPtc
 * @subpackage Arrays
 */
class ArrayOfAARRequestPtc extends AbstractStructArrayBase
{
    /**
     * The AARRequestPtc
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AARRequestPtc[]
     */
    public $AARRequestPtc;
    /**
     * Constructor method for ArrayOfAARRequestPtc
     * @uses ArrayOfAARRequestPtc::setAARRequestPtc()
     * @param \StructType\AARRequestPtc[] $aARRequestPtc
     */
    public function __construct(array $aARRequestPtc = array())
    {
        $this
            ->setAARRequestPtc($aARRequestPtc);
    }
    /**
     * Get AARRequestPtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AARRequestPtc[]|null
     */
    public function getAARRequestPtc()
    {
        return isset($this->AARRequestPtc) ? $this->AARRequestPtc : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAARRequestPtc method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAARRequestPtc method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAARRequestPtcForArrayConstraintsFromSetAARRequestPtc(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAARRequestPtcAARRequestPtcItem) {
            // validation for constraint: itemType
            if (!$arrayOfAARRequestPtcAARRequestPtcItem instanceof \StructType\AARRequestPtc) {
                $invalidValues[] = is_object($arrayOfAARRequestPtcAARRequestPtcItem) ? get_class($arrayOfAARRequestPtcAARRequestPtcItem) : sprintf('%s(%s)', gettype($arrayOfAARRequestPtcAARRequestPtcItem), var_export($arrayOfAARRequestPtcAARRequestPtcItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AARRequestPtc property can only contain items of type \StructType\AARRequestPtc, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AARRequestPtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AARRequestPtc[] $aARRequestPtc
     * @return \ArrayType\ArrayOfAARRequestPtc
     */
    public function setAARRequestPtc(array $aARRequestPtc = array())
    {
        // validation for constraint: array
        if ('' !== ($aARRequestPtcArrayErrorMessage = self::validateAARRequestPtcForArrayConstraintsFromSetAARRequestPtc($aARRequestPtc))) {
            throw new \InvalidArgumentException($aARRequestPtcArrayErrorMessage, __LINE__);
        }
        if (is_null($aARRequestPtc) || (is_array($aARRequestPtc) && empty($aARRequestPtc))) {
            unset($this->AARRequestPtc);
        } else {
            $this->AARRequestPtc = $aARRequestPtc;
        }
        return $this;
    }
    /**
     * Add item to AARRequestPtc value
     * @throws \InvalidArgumentException
     * @param \StructType\AARRequestPtc $item
     * @return \ArrayType\ArrayOfAARRequestPtc
     */
    public function addToAARRequestPtc(\StructType\AARRequestPtc $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AARRequestPtc) {
            throw new \InvalidArgumentException(sprintf('The AARRequestPtc property can only contain items of type \StructType\AARRequestPtc, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AARRequestPtc[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AARRequestPtc|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AARRequestPtc|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AARRequestPtc|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AARRequestPtc|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AARRequestPtc|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AARRequestPtc
     */
    public function getAttributeName()
    {
        return 'AARRequestPtc';
    }
}
