<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewServiceQuote StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewServiceQuote
 * @subpackage Structs
 */
class ViewServiceQuote extends AbstractStructBase
{
    /**
     * The LogicalFlightID
     * @var int
     */
    public $LogicalFlightID;
    /**
     * The ServiceID
     * @var int
     */
    public $ServiceID;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The OperatingCarrier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OperatingCarrier;
    /**
     * The MarketingCarrier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $MarketingCarrier;
    /**
     * The CodeType
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodeType;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The AmountActive
     * @var bool
     */
    public $AmountActive;
    /**
     * The AmountType
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AmountType;
    /**
     * The CategoryID
     * @var int
     */
    public $CategoryID;
    /**
     * The SSRCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SSRCode;
    /**
     * The Display
     * @var bool
     */
    public $Display;
    /**
     * The MaxCountServiceLevel
     * @var int
     */
    public $MaxCountServiceLevel;
    /**
     * The Refundable
     * @var bool
     */
    public $Refundable;
    /**
     * The PNLActive
     * @var bool
     */
    public $PNLActive;
    /**
     * The CutoffHours
     * @var int
     */
    public $CutoffHours;
    /**
     * The Commissionable
     * @var bool
     */
    public $Commissionable;
    /**
     * The DisplayOrder
     * @var int
     */
    public $DisplayOrder;
    /**
     * The RevenueCategoryID
     * @var int
     */
    public $RevenueCategoryID;
    /**
     * The IATAStandardCodeType
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATAStandardCodeType;
    /**
     * The ServiceActive
     * @var bool
     */
    public $ServiceActive;
    /**
     * The MaxCountFlightLevel
     * @var int
     */
    public $MaxCountFlightLevel;
    /**
     * The QuantityAvailable
     * @var int
     */
    public $QuantityAvailable;
    /**
     * The StartSalesDays
     * @var int
     */
    public $StartSalesDays;
    /**
     * The ApplicableTaxes
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfApplicableTax
     */
    public $ApplicableTaxes;
    /**
     * The BoardingPassSsrOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BoardingPassSsrOrder;
    /**
     * The ServiceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ServiceType;
    /**
     * The PhysicalFlightID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PhysicalFlightID;
    /**
     * Constructor method for ViewServiceQuote
     * @uses ViewServiceQuote::setLogicalFlightID()
     * @uses ViewServiceQuote::setServiceID()
     * @uses ViewServiceQuote::setDepartureDate()
     * @uses ViewServiceQuote::setOperatingCarrier()
     * @uses ViewServiceQuote::setMarketingCarrier()
     * @uses ViewServiceQuote::setCodeType()
     * @uses ViewServiceQuote::setDescription()
     * @uses ViewServiceQuote::setCurrencyCode()
     * @uses ViewServiceQuote::setAmount()
     * @uses ViewServiceQuote::setAmountActive()
     * @uses ViewServiceQuote::setAmountType()
     * @uses ViewServiceQuote::setCategoryID()
     * @uses ViewServiceQuote::setSSRCode()
     * @uses ViewServiceQuote::setDisplay()
     * @uses ViewServiceQuote::setMaxCountServiceLevel()
     * @uses ViewServiceQuote::setRefundable()
     * @uses ViewServiceQuote::setPNLActive()
     * @uses ViewServiceQuote::setCutoffHours()
     * @uses ViewServiceQuote::setCommissionable()
     * @uses ViewServiceQuote::setDisplayOrder()
     * @uses ViewServiceQuote::setRevenueCategoryID()
     * @uses ViewServiceQuote::setIATAStandardCodeType()
     * @uses ViewServiceQuote::setServiceActive()
     * @uses ViewServiceQuote::setMaxCountFlightLevel()
     * @uses ViewServiceQuote::setQuantityAvailable()
     * @uses ViewServiceQuote::setStartSalesDays()
     * @uses ViewServiceQuote::setApplicableTaxes()
     * @uses ViewServiceQuote::setBoardingPassSsrOrder()
     * @uses ViewServiceQuote::setServiceType()
     * @uses ViewServiceQuote::setPhysicalFlightID()
     * @param int $logicalFlightID
     * @param int $serviceID
     * @param string $departureDate
     * @param string $operatingCarrier
     * @param string $marketingCarrier
     * @param string $codeType
     * @param string $description
     * @param string $currencyCode
     * @param float $amount
     * @param bool $amountActive
     * @param string $amountType
     * @param int $categoryID
     * @param string $sSRCode
     * @param bool $display
     * @param int $maxCountServiceLevel
     * @param bool $refundable
     * @param bool $pNLActive
     * @param int $cutoffHours
     * @param bool $commissionable
     * @param int $displayOrder
     * @param int $revenueCategoryID
     * @param string $iATAStandardCodeType
     * @param bool $serviceActive
     * @param int $maxCountFlightLevel
     * @param int $quantityAvailable
     * @param int $startSalesDays
     * @param \ArrayType\ArrayOfApplicableTax $applicableTaxes
     * @param int $boardingPassSsrOrder
     * @param int $serviceType
     * @param int $physicalFlightID
     */
    public function __construct($logicalFlightID = null, $serviceID = null, $departureDate = null, $operatingCarrier = null, $marketingCarrier = null, $codeType = null, $description = null, $currencyCode = null, $amount = null, $amountActive = null, $amountType = null, $categoryID = null, $sSRCode = null, $display = null, $maxCountServiceLevel = null, $refundable = null, $pNLActive = null, $cutoffHours = null, $commissionable = null, $displayOrder = null, $revenueCategoryID = null, $iATAStandardCodeType = null, $serviceActive = null, $maxCountFlightLevel = null, $quantityAvailable = null, $startSalesDays = null, \ArrayType\ArrayOfApplicableTax $applicableTaxes = null, $boardingPassSsrOrder = null, $serviceType = null, $physicalFlightID = null)
    {
        $this
            ->setLogicalFlightID($logicalFlightID)
            ->setServiceID($serviceID)
            ->setDepartureDate($departureDate)
            ->setOperatingCarrier($operatingCarrier)
            ->setMarketingCarrier($marketingCarrier)
            ->setCodeType($codeType)
            ->setDescription($description)
            ->setCurrencyCode($currencyCode)
            ->setAmount($amount)
            ->setAmountActive($amountActive)
            ->setAmountType($amountType)
            ->setCategoryID($categoryID)
            ->setSSRCode($sSRCode)
            ->setDisplay($display)
            ->setMaxCountServiceLevel($maxCountServiceLevel)
            ->setRefundable($refundable)
            ->setPNLActive($pNLActive)
            ->setCutoffHours($cutoffHours)
            ->setCommissionable($commissionable)
            ->setDisplayOrder($displayOrder)
            ->setRevenueCategoryID($revenueCategoryID)
            ->setIATAStandardCodeType($iATAStandardCodeType)
            ->setServiceActive($serviceActive)
            ->setMaxCountFlightLevel($maxCountFlightLevel)
            ->setQuantityAvailable($quantityAvailable)
            ->setStartSalesDays($startSalesDays)
            ->setApplicableTaxes($applicableTaxes)
            ->setBoardingPassSsrOrder($boardingPassSsrOrder)
            ->setServiceType($serviceType)
            ->setPhysicalFlightID($physicalFlightID);
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\ViewServiceQuote
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
    /**
     * Get ServiceID value
     * @return int|null
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param int $serviceID
     * @return \StructType\ViewServiceQuote
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceID) && !(is_int($serviceID) || ctype_digit($serviceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\ViewServiceQuote
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get OperatingCarrier value
     * @return string|null
     */
    public function getOperatingCarrier()
    {
        return $this->OperatingCarrier;
    }
    /**
     * Set OperatingCarrier value
     * @param string $operatingCarrier
     * @return \StructType\ViewServiceQuote
     */
    public function setOperatingCarrier($operatingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCarrier) && !is_string($operatingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingCarrier, true), gettype($operatingCarrier)), __LINE__);
        }
        $this->OperatingCarrier = $operatingCarrier;
        return $this;
    }
    /**
     * Get MarketingCarrier value
     * @return string|null
     */
    public function getMarketingCarrier()
    {
        return $this->MarketingCarrier;
    }
    /**
     * Set MarketingCarrier value
     * @param string $marketingCarrier
     * @return \StructType\ViewServiceQuote
     */
    public function setMarketingCarrier($marketingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCarrier) && !is_string($marketingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketingCarrier, true), gettype($marketingCarrier)), __LINE__);
        }
        $this->MarketingCarrier = $marketingCarrier;
        return $this;
    }
    /**
     * Get CodeType value
     * @return string|null
     */
    public function getCodeType()
    {
        return $this->CodeType;
    }
    /**
     * Set CodeType value
     * @param string $codeType
     * @return \StructType\ViewServiceQuote
     */
    public function setCodeType($codeType = null)
    {
        // validation for constraint: string
        if (!is_null($codeType) && !is_string($codeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeType, true), gettype($codeType)), __LINE__);
        }
        $this->CodeType = $codeType;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ViewServiceQuote
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\ViewServiceQuote
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ViewServiceQuote
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get AmountActive value
     * @return bool|null
     */
    public function getAmountActive()
    {
        return $this->AmountActive;
    }
    /**
     * Set AmountActive value
     * @param bool $amountActive
     * @return \StructType\ViewServiceQuote
     */
    public function setAmountActive($amountActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($amountActive) && !is_bool($amountActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($amountActive, true), gettype($amountActive)), __LINE__);
        }
        $this->AmountActive = $amountActive;
        return $this;
    }
    /**
     * Get AmountType value
     * @return string|null
     */
    public function getAmountType()
    {
        return $this->AmountType;
    }
    /**
     * Set AmountType value
     * @param string $amountType
     * @return \StructType\ViewServiceQuote
     */
    public function setAmountType($amountType = null)
    {
        // validation for constraint: string
        if (!is_null($amountType) && !is_string($amountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountType, true), gettype($amountType)), __LINE__);
        }
        $this->AmountType = $amountType;
        return $this;
    }
    /**
     * Get CategoryID value
     * @return int|null
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param int $categoryID
     * @return \StructType\ViewServiceQuote
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: int
        if (!is_null($categoryID) && !(is_int($categoryID) || ctype_digit($categoryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryID, true), gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Get SSRCode value
     * @return string|null
     */
    public function getSSRCode()
    {
        return $this->SSRCode;
    }
    /**
     * Set SSRCode value
     * @param string $sSRCode
     * @return \StructType\ViewServiceQuote
     */
    public function setSSRCode($sSRCode = null)
    {
        // validation for constraint: string
        if (!is_null($sSRCode) && !is_string($sSRCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSRCode, true), gettype($sSRCode)), __LINE__);
        }
        $this->SSRCode = $sSRCode;
        return $this;
    }
    /**
     * Get Display value
     * @return bool|null
     */
    public function getDisplay()
    {
        return $this->Display;
    }
    /**
     * Set Display value
     * @param bool $display
     * @return \StructType\ViewServiceQuote
     */
    public function setDisplay($display = null)
    {
        // validation for constraint: boolean
        if (!is_null($display) && !is_bool($display)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($display, true), gettype($display)), __LINE__);
        }
        $this->Display = $display;
        return $this;
    }
    /**
     * Get MaxCountServiceLevel value
     * @return int|null
     */
    public function getMaxCountServiceLevel()
    {
        return $this->MaxCountServiceLevel;
    }
    /**
     * Set MaxCountServiceLevel value
     * @param int $maxCountServiceLevel
     * @return \StructType\ViewServiceQuote
     */
    public function setMaxCountServiceLevel($maxCountServiceLevel = null)
    {
        // validation for constraint: int
        if (!is_null($maxCountServiceLevel) && !(is_int($maxCountServiceLevel) || ctype_digit($maxCountServiceLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxCountServiceLevel, true), gettype($maxCountServiceLevel)), __LINE__);
        }
        $this->MaxCountServiceLevel = $maxCountServiceLevel;
        return $this;
    }
    /**
     * Get Refundable value
     * @return bool|null
     */
    public function getRefundable()
    {
        return $this->Refundable;
    }
    /**
     * Set Refundable value
     * @param bool $refundable
     * @return \StructType\ViewServiceQuote
     */
    public function setRefundable($refundable = null)
    {
        // validation for constraint: boolean
        if (!is_null($refundable) && !is_bool($refundable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refundable, true), gettype($refundable)), __LINE__);
        }
        $this->Refundable = $refundable;
        return $this;
    }
    /**
     * Get PNLActive value
     * @return bool|null
     */
    public function getPNLActive()
    {
        return $this->PNLActive;
    }
    /**
     * Set PNLActive value
     * @param bool $pNLActive
     * @return \StructType\ViewServiceQuote
     */
    public function setPNLActive($pNLActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($pNLActive) && !is_bool($pNLActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pNLActive, true), gettype($pNLActive)), __LINE__);
        }
        $this->PNLActive = $pNLActive;
        return $this;
    }
    /**
     * Get CutoffHours value
     * @return int|null
     */
    public function getCutoffHours()
    {
        return $this->CutoffHours;
    }
    /**
     * Set CutoffHours value
     * @param int $cutoffHours
     * @return \StructType\ViewServiceQuote
     */
    public function setCutoffHours($cutoffHours = null)
    {
        // validation for constraint: int
        if (!is_null($cutoffHours) && !(is_int($cutoffHours) || ctype_digit($cutoffHours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cutoffHours, true), gettype($cutoffHours)), __LINE__);
        }
        $this->CutoffHours = $cutoffHours;
        return $this;
    }
    /**
     * Get Commissionable value
     * @return bool|null
     */
    public function getCommissionable()
    {
        return $this->Commissionable;
    }
    /**
     * Set Commissionable value
     * @param bool $commissionable
     * @return \StructType\ViewServiceQuote
     */
    public function setCommissionable($commissionable = null)
    {
        // validation for constraint: boolean
        if (!is_null($commissionable) && !is_bool($commissionable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($commissionable, true), gettype($commissionable)), __LINE__);
        }
        $this->Commissionable = $commissionable;
        return $this;
    }
    /**
     * Get DisplayOrder value
     * @return int|null
     */
    public function getDisplayOrder()
    {
        return $this->DisplayOrder;
    }
    /**
     * Set DisplayOrder value
     * @param int $displayOrder
     * @return \StructType\ViewServiceQuote
     */
    public function setDisplayOrder($displayOrder = null)
    {
        // validation for constraint: int
        if (!is_null($displayOrder) && !(is_int($displayOrder) || ctype_digit($displayOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($displayOrder, true), gettype($displayOrder)), __LINE__);
        }
        $this->DisplayOrder = $displayOrder;
        return $this;
    }
    /**
     * Get RevenueCategoryID value
     * @return int|null
     */
    public function getRevenueCategoryID()
    {
        return $this->RevenueCategoryID;
    }
    /**
     * Set RevenueCategoryID value
     * @param int $revenueCategoryID
     * @return \StructType\ViewServiceQuote
     */
    public function setRevenueCategoryID($revenueCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($revenueCategoryID) && !(is_int($revenueCategoryID) || ctype_digit($revenueCategoryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($revenueCategoryID, true), gettype($revenueCategoryID)), __LINE__);
        }
        $this->RevenueCategoryID = $revenueCategoryID;
        return $this;
    }
    /**
     * Get IATAStandardCodeType value
     * @return string|null
     */
    public function getIATAStandardCodeType()
    {
        return $this->IATAStandardCodeType;
    }
    /**
     * Set IATAStandardCodeType value
     * @param string $iATAStandardCodeType
     * @return \StructType\ViewServiceQuote
     */
    public function setIATAStandardCodeType($iATAStandardCodeType = null)
    {
        // validation for constraint: string
        if (!is_null($iATAStandardCodeType) && !is_string($iATAStandardCodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATAStandardCodeType, true), gettype($iATAStandardCodeType)), __LINE__);
        }
        $this->IATAStandardCodeType = $iATAStandardCodeType;
        return $this;
    }
    /**
     * Get ServiceActive value
     * @return bool|null
     */
    public function getServiceActive()
    {
        return $this->ServiceActive;
    }
    /**
     * Set ServiceActive value
     * @param bool $serviceActive
     * @return \StructType\ViewServiceQuote
     */
    public function setServiceActive($serviceActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($serviceActive) && !is_bool($serviceActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($serviceActive, true), gettype($serviceActive)), __LINE__);
        }
        $this->ServiceActive = $serviceActive;
        return $this;
    }
    /**
     * Get MaxCountFlightLevel value
     * @return int|null
     */
    public function getMaxCountFlightLevel()
    {
        return $this->MaxCountFlightLevel;
    }
    /**
     * Set MaxCountFlightLevel value
     * @param int $maxCountFlightLevel
     * @return \StructType\ViewServiceQuote
     */
    public function setMaxCountFlightLevel($maxCountFlightLevel = null)
    {
        // validation for constraint: int
        if (!is_null($maxCountFlightLevel) && !(is_int($maxCountFlightLevel) || ctype_digit($maxCountFlightLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxCountFlightLevel, true), gettype($maxCountFlightLevel)), __LINE__);
        }
        $this->MaxCountFlightLevel = $maxCountFlightLevel;
        return $this;
    }
    /**
     * Get QuantityAvailable value
     * @return int|null
     */
    public function getQuantityAvailable()
    {
        return $this->QuantityAvailable;
    }
    /**
     * Set QuantityAvailable value
     * @param int $quantityAvailable
     * @return \StructType\ViewServiceQuote
     */
    public function setQuantityAvailable($quantityAvailable = null)
    {
        // validation for constraint: int
        if (!is_null($quantityAvailable) && !(is_int($quantityAvailable) || ctype_digit($quantityAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityAvailable, true), gettype($quantityAvailable)), __LINE__);
        }
        $this->QuantityAvailable = $quantityAvailable;
        return $this;
    }
    /**
     * Get StartSalesDays value
     * @return int|null
     */
    public function getStartSalesDays()
    {
        return $this->StartSalesDays;
    }
    /**
     * Set StartSalesDays value
     * @param int $startSalesDays
     * @return \StructType\ViewServiceQuote
     */
    public function setStartSalesDays($startSalesDays = null)
    {
        // validation for constraint: int
        if (!is_null($startSalesDays) && !(is_int($startSalesDays) || ctype_digit($startSalesDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startSalesDays, true), gettype($startSalesDays)), __LINE__);
        }
        $this->StartSalesDays = $startSalesDays;
        return $this;
    }
    /**
     * Get ApplicableTaxes value
     * @return \ArrayType\ArrayOfApplicableTax|null
     */
    public function getApplicableTaxes()
    {
        return $this->ApplicableTaxes;
    }
    /**
     * Set ApplicableTaxes value
     * @param \ArrayType\ArrayOfApplicableTax $applicableTaxes
     * @return \StructType\ViewServiceQuote
     */
    public function setApplicableTaxes(\ArrayType\ArrayOfApplicableTax $applicableTaxes = null)
    {
        $this->ApplicableTaxes = $applicableTaxes;
        return $this;
    }
    /**
     * Get BoardingPassSsrOrder value
     * @return int|null
     */
    public function getBoardingPassSsrOrder()
    {
        return $this->BoardingPassSsrOrder;
    }
    /**
     * Set BoardingPassSsrOrder value
     * @param int $boardingPassSsrOrder
     * @return \StructType\ViewServiceQuote
     */
    public function setBoardingPassSsrOrder($boardingPassSsrOrder = null)
    {
        // validation for constraint: int
        if (!is_null($boardingPassSsrOrder) && !(is_int($boardingPassSsrOrder) || ctype_digit($boardingPassSsrOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($boardingPassSsrOrder, true), gettype($boardingPassSsrOrder)), __LINE__);
        }
        $this->BoardingPassSsrOrder = $boardingPassSsrOrder;
        return $this;
    }
    /**
     * Get ServiceType value
     * @return int|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @param int $serviceType
     * @return \StructType\ViewServiceQuote
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: int
        if (!is_null($serviceType) && !(is_int($serviceType) || ctype_digit($serviceType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceType, true), gettype($serviceType)), __LINE__);
        }
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Get PhysicalFlightID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPhysicalFlightID()
    {
        return isset($this->PhysicalFlightID) ? $this->PhysicalFlightID : null;
    }
    /**
     * Set PhysicalFlightID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $physicalFlightID
     * @return \StructType\ViewServiceQuote
     */
    public function setPhysicalFlightID($physicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($physicalFlightID) && !(is_int($physicalFlightID) || ctype_digit($physicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($physicalFlightID, true), gettype($physicalFlightID)), __LINE__);
        }
        if (is_null($physicalFlightID) || (is_array($physicalFlightID) && empty($physicalFlightID))) {
            unset($this->PhysicalFlightID);
        } else {
            $this->PhysicalFlightID = $physicalFlightID;
        }
        return $this;
    }
}
