<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SegmentDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SegmentDetail
 * @subpackage Structs
 */
class SegmentDetail extends AbstractStructBase
{
    /**
     * The LFID
     * @var int
     */
    public $LFID;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CarrierCode;
    /**
     * The ArrivalDate
     * @var string
     */
    public $ArrivalDate;
    /**
     * The Stops
     * @var int
     */
    public $Stops;
    /**
     * The FlightTime
     * @var float
     */
    public $FlightTime;
    /**
     * The AircraftType
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AircraftType;
    /**
     * The SellingCarrier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SellingCarrier;
    /**
     * The FlightNum
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FlightNum;
    /**
     * The OperatingCarrier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OperatingCarrier;
    /**
     * The OperatingFlightNum
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OperatingFlightNum;
    /**
     * The FlyMonday
     * @var bool
     */
    public $FlyMonday;
    /**
     * The FlyTuesday
     * @var bool
     */
    public $FlyTuesday;
    /**
     * The FlyWednesday
     * @var bool
     */
    public $FlyWednesday;
    /**
     * The FlyThursday
     * @var bool
     */
    public $FlyThursday;
    /**
     * The FlyFriday
     * @var bool
     */
    public $FlyFriday;
    /**
     * The FlySaturday
     * @var bool
     */
    public $FlySaturday;
    /**
     * The FlySunday
     * @var bool
     */
    public $FlySunday;
    /**
     * The AircraftDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AircraftDescription;
    /**
     * The DeiDisclosure
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeiDisclosure;
    /**
     * Constructor method for SegmentDetail
     * @uses SegmentDetail::setLFID()
     * @uses SegmentDetail::setOrigin()
     * @uses SegmentDetail::setDestination()
     * @uses SegmentDetail::setDepartureDate()
     * @uses SegmentDetail::setCarrierCode()
     * @uses SegmentDetail::setArrivalDate()
     * @uses SegmentDetail::setStops()
     * @uses SegmentDetail::setFlightTime()
     * @uses SegmentDetail::setAircraftType()
     * @uses SegmentDetail::setSellingCarrier()
     * @uses SegmentDetail::setFlightNum()
     * @uses SegmentDetail::setOperatingCarrier()
     * @uses SegmentDetail::setOperatingFlightNum()
     * @uses SegmentDetail::setFlyMonday()
     * @uses SegmentDetail::setFlyTuesday()
     * @uses SegmentDetail::setFlyWednesday()
     * @uses SegmentDetail::setFlyThursday()
     * @uses SegmentDetail::setFlyFriday()
     * @uses SegmentDetail::setFlySaturday()
     * @uses SegmentDetail::setFlySunday()
     * @uses SegmentDetail::setAircraftDescription()
     * @uses SegmentDetail::setDeiDisclosure()
     * @param int $lFID
     * @param string $origin
     * @param string $destination
     * @param string $departureDate
     * @param string $carrierCode
     * @param string $arrivalDate
     * @param int $stops
     * @param float $flightTime
     * @param string $aircraftType
     * @param string $sellingCarrier
     * @param string $flightNum
     * @param string $operatingCarrier
     * @param string $operatingFlightNum
     * @param bool $flyMonday
     * @param bool $flyTuesday
     * @param bool $flyWednesday
     * @param bool $flyThursday
     * @param bool $flyFriday
     * @param bool $flySaturday
     * @param bool $flySunday
     * @param string $aircraftDescription
     * @param string $deiDisclosure
     */
    public function __construct($lFID = null, $origin = null, $destination = null, $departureDate = null, $carrierCode = null, $arrivalDate = null, $stops = null, $flightTime = null, $aircraftType = null, $sellingCarrier = null, $flightNum = null, $operatingCarrier = null, $operatingFlightNum = null, $flyMonday = null, $flyTuesday = null, $flyWednesday = null, $flyThursday = null, $flyFriday = null, $flySaturday = null, $flySunday = null, $aircraftDescription = null, $deiDisclosure = null)
    {
        $this
            ->setLFID($lFID)
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setDepartureDate($departureDate)
            ->setCarrierCode($carrierCode)
            ->setArrivalDate($arrivalDate)
            ->setStops($stops)
            ->setFlightTime($flightTime)
            ->setAircraftType($aircraftType)
            ->setSellingCarrier($sellingCarrier)
            ->setFlightNum($flightNum)
            ->setOperatingCarrier($operatingCarrier)
            ->setOperatingFlightNum($operatingFlightNum)
            ->setFlyMonday($flyMonday)
            ->setFlyTuesday($flyTuesday)
            ->setFlyWednesday($flyWednesday)
            ->setFlyThursday($flyThursday)
            ->setFlyFriday($flyFriday)
            ->setFlySaturday($flySaturday)
            ->setFlySunday($flySunday)
            ->setAircraftDescription($aircraftDescription)
            ->setDeiDisclosure($deiDisclosure);
    }
    /**
     * Get LFID value
     * @return int|null
     */
    public function getLFID()
    {
        return $this->LFID;
    }
    /**
     * Set LFID value
     * @param int $lFID
     * @return \StructType\SegmentDetail
     */
    public function setLFID($lFID = null)
    {
        // validation for constraint: int
        if (!is_null($lFID) && !(is_int($lFID) || ctype_digit($lFID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lFID, true), gettype($lFID)), __LINE__);
        }
        $this->LFID = $lFID;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\SegmentDetail
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \StructType\SegmentDetail
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\SegmentDetail
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \StructType\SegmentDetail
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierCode, true), gettype($carrierCode)), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\SegmentDetail
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDate, true), gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get Stops value
     * @return int|null
     */
    public function getStops()
    {
        return $this->Stops;
    }
    /**
     * Set Stops value
     * @param int $stops
     * @return \StructType\SegmentDetail
     */
    public function setStops($stops = null)
    {
        // validation for constraint: int
        if (!is_null($stops) && !(is_int($stops) || ctype_digit($stops))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stops, true), gettype($stops)), __LINE__);
        }
        $this->Stops = $stops;
        return $this;
    }
    /**
     * Get FlightTime value
     * @return float|null
     */
    public function getFlightTime()
    {
        return $this->FlightTime;
    }
    /**
     * Set FlightTime value
     * @param float $flightTime
     * @return \StructType\SegmentDetail
     */
    public function setFlightTime($flightTime = null)
    {
        // validation for constraint: float
        if (!is_null($flightTime) && !(is_float($flightTime) || is_numeric($flightTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($flightTime, true), gettype($flightTime)), __LINE__);
        }
        $this->FlightTime = $flightTime;
        return $this;
    }
    /**
     * Get AircraftType value
     * @return string|null
     */
    public function getAircraftType()
    {
        return $this->AircraftType;
    }
    /**
     * Set AircraftType value
     * @param string $aircraftType
     * @return \StructType\SegmentDetail
     */
    public function setAircraftType($aircraftType = null)
    {
        // validation for constraint: string
        if (!is_null($aircraftType) && !is_string($aircraftType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aircraftType, true), gettype($aircraftType)), __LINE__);
        }
        $this->AircraftType = $aircraftType;
        return $this;
    }
    /**
     * Get SellingCarrier value
     * @return string|null
     */
    public function getSellingCarrier()
    {
        return $this->SellingCarrier;
    }
    /**
     * Set SellingCarrier value
     * @param string $sellingCarrier
     * @return \StructType\SegmentDetail
     */
    public function setSellingCarrier($sellingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($sellingCarrier) && !is_string($sellingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellingCarrier, true), gettype($sellingCarrier)), __LINE__);
        }
        $this->SellingCarrier = $sellingCarrier;
        return $this;
    }
    /**
     * Get FlightNum value
     * @return string|null
     */
    public function getFlightNum()
    {
        return $this->FlightNum;
    }
    /**
     * Set FlightNum value
     * @param string $flightNum
     * @return \StructType\SegmentDetail
     */
    public function setFlightNum($flightNum = null)
    {
        // validation for constraint: string
        if (!is_null($flightNum) && !is_string($flightNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNum, true), gettype($flightNum)), __LINE__);
        }
        $this->FlightNum = $flightNum;
        return $this;
    }
    /**
     * Get OperatingCarrier value
     * @return string|null
     */
    public function getOperatingCarrier()
    {
        return $this->OperatingCarrier;
    }
    /**
     * Set OperatingCarrier value
     * @param string $operatingCarrier
     * @return \StructType\SegmentDetail
     */
    public function setOperatingCarrier($operatingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCarrier) && !is_string($operatingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingCarrier, true), gettype($operatingCarrier)), __LINE__);
        }
        $this->OperatingCarrier = $operatingCarrier;
        return $this;
    }
    /**
     * Get OperatingFlightNum value
     * @return string|null
     */
    public function getOperatingFlightNum()
    {
        return $this->OperatingFlightNum;
    }
    /**
     * Set OperatingFlightNum value
     * @param string $operatingFlightNum
     * @return \StructType\SegmentDetail
     */
    public function setOperatingFlightNum($operatingFlightNum = null)
    {
        // validation for constraint: string
        if (!is_null($operatingFlightNum) && !is_string($operatingFlightNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingFlightNum, true), gettype($operatingFlightNum)), __LINE__);
        }
        $this->OperatingFlightNum = $operatingFlightNum;
        return $this;
    }
    /**
     * Get FlyMonday value
     * @return bool|null
     */
    public function getFlyMonday()
    {
        return $this->FlyMonday;
    }
    /**
     * Set FlyMonday value
     * @param bool $flyMonday
     * @return \StructType\SegmentDetail
     */
    public function setFlyMonday($flyMonday = null)
    {
        // validation for constraint: boolean
        if (!is_null($flyMonday) && !is_bool($flyMonday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($flyMonday, true), gettype($flyMonday)), __LINE__);
        }
        $this->FlyMonday = $flyMonday;
        return $this;
    }
    /**
     * Get FlyTuesday value
     * @return bool|null
     */
    public function getFlyTuesday()
    {
        return $this->FlyTuesday;
    }
    /**
     * Set FlyTuesday value
     * @param bool $flyTuesday
     * @return \StructType\SegmentDetail
     */
    public function setFlyTuesday($flyTuesday = null)
    {
        // validation for constraint: boolean
        if (!is_null($flyTuesday) && !is_bool($flyTuesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($flyTuesday, true), gettype($flyTuesday)), __LINE__);
        }
        $this->FlyTuesday = $flyTuesday;
        return $this;
    }
    /**
     * Get FlyWednesday value
     * @return bool|null
     */
    public function getFlyWednesday()
    {
        return $this->FlyWednesday;
    }
    /**
     * Set FlyWednesday value
     * @param bool $flyWednesday
     * @return \StructType\SegmentDetail
     */
    public function setFlyWednesday($flyWednesday = null)
    {
        // validation for constraint: boolean
        if (!is_null($flyWednesday) && !is_bool($flyWednesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($flyWednesday, true), gettype($flyWednesday)), __LINE__);
        }
        $this->FlyWednesday = $flyWednesday;
        return $this;
    }
    /**
     * Get FlyThursday value
     * @return bool|null
     */
    public function getFlyThursday()
    {
        return $this->FlyThursday;
    }
    /**
     * Set FlyThursday value
     * @param bool $flyThursday
     * @return \StructType\SegmentDetail
     */
    public function setFlyThursday($flyThursday = null)
    {
        // validation for constraint: boolean
        if (!is_null($flyThursday) && !is_bool($flyThursday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($flyThursday, true), gettype($flyThursday)), __LINE__);
        }
        $this->FlyThursday = $flyThursday;
        return $this;
    }
    /**
     * Get FlyFriday value
     * @return bool|null
     */
    public function getFlyFriday()
    {
        return $this->FlyFriday;
    }
    /**
     * Set FlyFriday value
     * @param bool $flyFriday
     * @return \StructType\SegmentDetail
     */
    public function setFlyFriday($flyFriday = null)
    {
        // validation for constraint: boolean
        if (!is_null($flyFriday) && !is_bool($flyFriday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($flyFriday, true), gettype($flyFriday)), __LINE__);
        }
        $this->FlyFriday = $flyFriday;
        return $this;
    }
    /**
     * Get FlySaturday value
     * @return bool|null
     */
    public function getFlySaturday()
    {
        return $this->FlySaturday;
    }
    /**
     * Set FlySaturday value
     * @param bool $flySaturday
     * @return \StructType\SegmentDetail
     */
    public function setFlySaturday($flySaturday = null)
    {
        // validation for constraint: boolean
        if (!is_null($flySaturday) && !is_bool($flySaturday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($flySaturday, true), gettype($flySaturday)), __LINE__);
        }
        $this->FlySaturday = $flySaturday;
        return $this;
    }
    /**
     * Get FlySunday value
     * @return bool|null
     */
    public function getFlySunday()
    {
        return $this->FlySunday;
    }
    /**
     * Set FlySunday value
     * @param bool $flySunday
     * @return \StructType\SegmentDetail
     */
    public function setFlySunday($flySunday = null)
    {
        // validation for constraint: boolean
        if (!is_null($flySunday) && !is_bool($flySunday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($flySunday, true), gettype($flySunday)), __LINE__);
        }
        $this->FlySunday = $flySunday;
        return $this;
    }
    /**
     * Get AircraftDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAircraftDescription()
    {
        return isset($this->AircraftDescription) ? $this->AircraftDescription : null;
    }
    /**
     * Set AircraftDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aircraftDescription
     * @return \StructType\SegmentDetail
     */
    public function setAircraftDescription($aircraftDescription = null)
    {
        // validation for constraint: string
        if (!is_null($aircraftDescription) && !is_string($aircraftDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aircraftDescription, true), gettype($aircraftDescription)), __LINE__);
        }
        if (is_null($aircraftDescription) || (is_array($aircraftDescription) && empty($aircraftDescription))) {
            unset($this->AircraftDescription);
        } else {
            $this->AircraftDescription = $aircraftDescription;
        }
        return $this;
    }
    /**
     * Get DeiDisclosure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeiDisclosure()
    {
        return isset($this->DeiDisclosure) ? $this->DeiDisclosure : null;
    }
    /**
     * Set DeiDisclosure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deiDisclosure
     * @return \StructType\SegmentDetail
     */
    public function setDeiDisclosure($deiDisclosure = null)
    {
        // validation for constraint: string
        if (!is_null($deiDisclosure) && !is_string($deiDisclosure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deiDisclosure, true), gettype($deiDisclosure)), __LINE__);
        }
        if (is_null($deiDisclosure) || (is_array($deiDisclosure) && empty($deiDisclosure))) {
            unset($this->DeiDisclosure);
        } else {
            $this->DeiDisclosure = $deiDisclosure;
        }
        return $this;
    }
}
