<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetFareType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetFareType
 * @subpackage Structs
 */
class RetFareType extends AbstractStructBase
{
    /**
     * The FareTypeID
     * @var int
     */
    public $FareTypeID;
    /**
     * The FareTypeName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FareTypeName;
    /**
     * The FilterRemove
     * @var bool
     */
    public $FilterRemove;
    /**
     * The RetFareInfos
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfRetFareInfo
     */
    public $RetFareInfos;
    /**
     * Constructor method for RetFareType
     * @uses RetFareType::setFareTypeID()
     * @uses RetFareType::setFareTypeName()
     * @uses RetFareType::setFilterRemove()
     * @uses RetFareType::setRetFareInfos()
     * @param int $fareTypeID
     * @param string $fareTypeName
     * @param bool $filterRemove
     * @param \ArrayType\ArrayOfRetFareInfo $retFareInfos
     */
    public function __construct($fareTypeID = null, $fareTypeName = null, $filterRemove = null, \ArrayType\ArrayOfRetFareInfo $retFareInfos = null)
    {
        $this
            ->setFareTypeID($fareTypeID)
            ->setFareTypeName($fareTypeName)
            ->setFilterRemove($filterRemove)
            ->setRetFareInfos($retFareInfos);
    }
    /**
     * Get FareTypeID value
     * @return int|null
     */
    public function getFareTypeID()
    {
        return $this->FareTypeID;
    }
    /**
     * Set FareTypeID value
     * @param int $fareTypeID
     * @return \StructType\RetFareType
     */
    public function setFareTypeID($fareTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($fareTypeID) && !(is_int($fareTypeID) || ctype_digit($fareTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fareTypeID, true), gettype($fareTypeID)), __LINE__);
        }
        $this->FareTypeID = $fareTypeID;
        return $this;
    }
    /**
     * Get FareTypeName value
     * @return string|null
     */
    public function getFareTypeName()
    {
        return $this->FareTypeName;
    }
    /**
     * Set FareTypeName value
     * @param string $fareTypeName
     * @return \StructType\RetFareType
     */
    public function setFareTypeName($fareTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($fareTypeName) && !is_string($fareTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareTypeName, true), gettype($fareTypeName)), __LINE__);
        }
        $this->FareTypeName = $fareTypeName;
        return $this;
    }
    /**
     * Get FilterRemove value
     * @return bool|null
     */
    public function getFilterRemove()
    {
        return $this->FilterRemove;
    }
    /**
     * Set FilterRemove value
     * @param bool $filterRemove
     * @return \StructType\RetFareType
     */
    public function setFilterRemove($filterRemove = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterRemove) && !is_bool($filterRemove)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filterRemove, true), gettype($filterRemove)), __LINE__);
        }
        $this->FilterRemove = $filterRemove;
        return $this;
    }
    /**
     * Get RetFareInfos value
     * @return \ArrayType\ArrayOfRetFareInfo|null
     */
    public function getRetFareInfos()
    {
        return $this->RetFareInfos;
    }
    /**
     * Set RetFareInfos value
     * @param \ArrayType\ArrayOfRetFareInfo $retFareInfos
     * @return \StructType\RetFareType
     */
    public function setRetFareInfos(\ArrayType\ArrayOfRetFareInfo $retFareInfos = null)
    {
        $this->RetFareInfos = $retFareInfos;
        return $this;
    }
}
