<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareQuoteRequestInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FareQuoteRequestInfo
 * @subpackage Structs
 */
class FareQuoteRequestInfo extends AbstractStructBase
{
    /**
     * The PassengerTypeID
     * @var int
     */
    public $PassengerTypeID;
    /**
     * The TotalSeatsRequired
     * @var int
     */
    public $TotalSeatsRequired;
    /**
     * Constructor method for FareQuoteRequestInfo
     * @uses FareQuoteRequestInfo::setPassengerTypeID()
     * @uses FareQuoteRequestInfo::setTotalSeatsRequired()
     * @param int $passengerTypeID
     * @param int $totalSeatsRequired
     */
    public function __construct($passengerTypeID = null, $totalSeatsRequired = null)
    {
        $this
            ->setPassengerTypeID($passengerTypeID)
            ->setTotalSeatsRequired($totalSeatsRequired);
    }
    /**
     * Get PassengerTypeID value
     * @return int|null
     */
    public function getPassengerTypeID()
    {
        return $this->PassengerTypeID;
    }
    /**
     * Set PassengerTypeID value
     * @param int $passengerTypeID
     * @return \StructType\FareQuoteRequestInfo
     */
    public function setPassengerTypeID($passengerTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($passengerTypeID) && !(is_int($passengerTypeID) || ctype_digit($passengerTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passengerTypeID, true), gettype($passengerTypeID)), __LINE__);
        }
        $this->PassengerTypeID = $passengerTypeID;
        return $this;
    }
    /**
     * Get TotalSeatsRequired value
     * @return int|null
     */
    public function getTotalSeatsRequired()
    {
        return $this->TotalSeatsRequired;
    }
    /**
     * Set TotalSeatsRequired value
     * @param int $totalSeatsRequired
     * @return \StructType\FareQuoteRequestInfo
     */
    public function setTotalSeatsRequired($totalSeatsRequired = null)
    {
        // validation for constraint: int
        if (!is_null($totalSeatsRequired) && !(is_int($totalSeatsRequired) || ctype_digit($totalSeatsRequired))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalSeatsRequired, true), gettype($totalSeatsRequired)), __LINE__);
        }
        $this->TotalSeatsRequired = $totalSeatsRequired;
        return $this;
    }
}
