<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FareDetail
 * @subpackage Structs
 */
class FareDetail extends AbstractStructBase
{
    /**
     * The FareTypeIdentifier
     * @var int
     */
    public $FareTypeIdentifier;
    /**
     * The FCCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FCCode;
    /**
     * The FBCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FBCode;
    /**
     * The FareScheduleID
     * @var int
     */
    public $FareScheduleID;
    /**
     * The PTCID
     * @var int
     */
    public $PTCID;
    /**
     * The FareTypeName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FareTypeName;
    /**
     * The BaseFareAmtInclTaxes
     * @var float
     */
    public $BaseFareAmtInclTaxes;
    /**
     * The BaseFareAmt
     * @var float
     */
    public $BaseFareAmt;
    /**
     * The FareAmtNoTaxes
     * @var float
     */
    public $FareAmtNoTaxes;
    /**
     * The FareAmt
     * @var float
     */
    public $FareAmt;
    /**
     * The DiscountAmt
     * @var float
     */
    public $DiscountAmt;
    /**
     * The PrivateFare
     * @var bool
     */
    public $PrivateFare;
    /**
     * Constructor method for FareDetail
     * @uses FareDetail::setFareTypeIdentifier()
     * @uses FareDetail::setFCCode()
     * @uses FareDetail::setFBCode()
     * @uses FareDetail::setFareScheduleID()
     * @uses FareDetail::setPTCID()
     * @uses FareDetail::setFareTypeName()
     * @uses FareDetail::setBaseFareAmtInclTaxes()
     * @uses FareDetail::setBaseFareAmt()
     * @uses FareDetail::setFareAmtNoTaxes()
     * @uses FareDetail::setFareAmt()
     * @uses FareDetail::setDiscountAmt()
     * @uses FareDetail::setPrivateFare()
     * @param int $fareTypeIdentifier
     * @param string $fCCode
     * @param string $fBCode
     * @param int $fareScheduleID
     * @param int $pTCID
     * @param string $fareTypeName
     * @param float $baseFareAmtInclTaxes
     * @param float $baseFareAmt
     * @param float $fareAmtNoTaxes
     * @param float $fareAmt
     * @param float $discountAmt
     * @param bool $privateFare
     */
    public function __construct($fareTypeIdentifier = null, $fCCode = null, $fBCode = null, $fareScheduleID = null, $pTCID = null, $fareTypeName = null, $baseFareAmtInclTaxes = null, $baseFareAmt = null, $fareAmtNoTaxes = null, $fareAmt = null, $discountAmt = null, $privateFare = null)
    {
        $this
            ->setFareTypeIdentifier($fareTypeIdentifier)
            ->setFCCode($fCCode)
            ->setFBCode($fBCode)
            ->setFareScheduleID($fareScheduleID)
            ->setPTCID($pTCID)
            ->setFareTypeName($fareTypeName)
            ->setBaseFareAmtInclTaxes($baseFareAmtInclTaxes)
            ->setBaseFareAmt($baseFareAmt)
            ->setFareAmtNoTaxes($fareAmtNoTaxes)
            ->setFareAmt($fareAmt)
            ->setDiscountAmt($discountAmt)
            ->setPrivateFare($privateFare);
    }
    /**
     * Get FareTypeIdentifier value
     * @return int|null
     */
    public function getFareTypeIdentifier()
    {
        return $this->FareTypeIdentifier;
    }
    /**
     * Set FareTypeIdentifier value
     * @param int $fareTypeIdentifier
     * @return \StructType\FareDetail
     */
    public function setFareTypeIdentifier($fareTypeIdentifier = null)
    {
        // validation for constraint: int
        if (!is_null($fareTypeIdentifier) && !(is_int($fareTypeIdentifier) || ctype_digit($fareTypeIdentifier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fareTypeIdentifier, true), gettype($fareTypeIdentifier)), __LINE__);
        }
        $this->FareTypeIdentifier = $fareTypeIdentifier;
        return $this;
    }
    /**
     * Get FCCode value
     * @return string|null
     */
    public function getFCCode()
    {
        return $this->FCCode;
    }
    /**
     * Set FCCode value
     * @param string $fCCode
     * @return \StructType\FareDetail
     */
    public function setFCCode($fCCode = null)
    {
        // validation for constraint: string
        if (!is_null($fCCode) && !is_string($fCCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fCCode, true), gettype($fCCode)), __LINE__);
        }
        $this->FCCode = $fCCode;
        return $this;
    }
    /**
     * Get FBCode value
     * @return string|null
     */
    public function getFBCode()
    {
        return $this->FBCode;
    }
    /**
     * Set FBCode value
     * @param string $fBCode
     * @return \StructType\FareDetail
     */
    public function setFBCode($fBCode = null)
    {
        // validation for constraint: string
        if (!is_null($fBCode) && !is_string($fBCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fBCode, true), gettype($fBCode)), __LINE__);
        }
        $this->FBCode = $fBCode;
        return $this;
    }
    /**
     * Get FareScheduleID value
     * @return int|null
     */
    public function getFareScheduleID()
    {
        return $this->FareScheduleID;
    }
    /**
     * Set FareScheduleID value
     * @param int $fareScheduleID
     * @return \StructType\FareDetail
     */
    public function setFareScheduleID($fareScheduleID = null)
    {
        // validation for constraint: int
        if (!is_null($fareScheduleID) && !(is_int($fareScheduleID) || ctype_digit($fareScheduleID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fareScheduleID, true), gettype($fareScheduleID)), __LINE__);
        }
        $this->FareScheduleID = $fareScheduleID;
        return $this;
    }
    /**
     * Get PTCID value
     * @return int|null
     */
    public function getPTCID()
    {
        return $this->PTCID;
    }
    /**
     * Set PTCID value
     * @param int $pTCID
     * @return \StructType\FareDetail
     */
    public function setPTCID($pTCID = null)
    {
        // validation for constraint: int
        if (!is_null($pTCID) && !(is_int($pTCID) || ctype_digit($pTCID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pTCID, true), gettype($pTCID)), __LINE__);
        }
        $this->PTCID = $pTCID;
        return $this;
    }
    /**
     * Get FareTypeName value
     * @return string|null
     */
    public function getFareTypeName()
    {
        return $this->FareTypeName;
    }
    /**
     * Set FareTypeName value
     * @param string $fareTypeName
     * @return \StructType\FareDetail
     */
    public function setFareTypeName($fareTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($fareTypeName) && !is_string($fareTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareTypeName, true), gettype($fareTypeName)), __LINE__);
        }
        $this->FareTypeName = $fareTypeName;
        return $this;
    }
    /**
     * Get BaseFareAmtInclTaxes value
     * @return float|null
     */
    public function getBaseFareAmtInclTaxes()
    {
        return $this->BaseFareAmtInclTaxes;
    }
    /**
     * Set BaseFareAmtInclTaxes value
     * @param float $baseFareAmtInclTaxes
     * @return \StructType\FareDetail
     */
    public function setBaseFareAmtInclTaxes($baseFareAmtInclTaxes = null)
    {
        // validation for constraint: float
        if (!is_null($baseFareAmtInclTaxes) && !(is_float($baseFareAmtInclTaxes) || is_numeric($baseFareAmtInclTaxes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseFareAmtInclTaxes, true), gettype($baseFareAmtInclTaxes)), __LINE__);
        }
        $this->BaseFareAmtInclTaxes = $baseFareAmtInclTaxes;
        return $this;
    }
    /**
     * Get BaseFareAmt value
     * @return float|null
     */
    public function getBaseFareAmt()
    {
        return $this->BaseFareAmt;
    }
    /**
     * Set BaseFareAmt value
     * @param float $baseFareAmt
     * @return \StructType\FareDetail
     */
    public function setBaseFareAmt($baseFareAmt = null)
    {
        // validation for constraint: float
        if (!is_null($baseFareAmt) && !(is_float($baseFareAmt) || is_numeric($baseFareAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseFareAmt, true), gettype($baseFareAmt)), __LINE__);
        }
        $this->BaseFareAmt = $baseFareAmt;
        return $this;
    }
    /**
     * Get FareAmtNoTaxes value
     * @return float|null
     */
    public function getFareAmtNoTaxes()
    {
        return $this->FareAmtNoTaxes;
    }
    /**
     * Set FareAmtNoTaxes value
     * @param float $fareAmtNoTaxes
     * @return \StructType\FareDetail
     */
    public function setFareAmtNoTaxes($fareAmtNoTaxes = null)
    {
        // validation for constraint: float
        if (!is_null($fareAmtNoTaxes) && !(is_float($fareAmtNoTaxes) || is_numeric($fareAmtNoTaxes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fareAmtNoTaxes, true), gettype($fareAmtNoTaxes)), __LINE__);
        }
        $this->FareAmtNoTaxes = $fareAmtNoTaxes;
        return $this;
    }
    /**
     * Get FareAmt value
     * @return float|null
     */
    public function getFareAmt()
    {
        return $this->FareAmt;
    }
    /**
     * Set FareAmt value
     * @param float $fareAmt
     * @return \StructType\FareDetail
     */
    public function setFareAmt($fareAmt = null)
    {
        // validation for constraint: float
        if (!is_null($fareAmt) && !(is_float($fareAmt) || is_numeric($fareAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fareAmt, true), gettype($fareAmt)), __LINE__);
        }
        $this->FareAmt = $fareAmt;
        return $this;
    }
    /**
     * Get DiscountAmt value
     * @return float|null
     */
    public function getDiscountAmt()
    {
        return $this->DiscountAmt;
    }
    /**
     * Set DiscountAmt value
     * @param float $discountAmt
     * @return \StructType\FareDetail
     */
    public function setDiscountAmt($discountAmt = null)
    {
        // validation for constraint: float
        if (!is_null($discountAmt) && !(is_float($discountAmt) || is_numeric($discountAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountAmt, true), gettype($discountAmt)), __LINE__);
        }
        $this->DiscountAmt = $discountAmt;
        return $this;
    }
    /**
     * Get PrivateFare value
     * @return bool|null
     */
    public function getPrivateFare()
    {
        return $this->PrivateFare;
    }
    /**
     * Set PrivateFare value
     * @param bool $privateFare
     * @return \StructType\FareDetail
     */
    public function setPrivateFare($privateFare = null)
    {
        // validation for constraint: boolean
        if (!is_null($privateFare) && !is_bool($privateFare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($privateFare, true), gettype($privateFare)), __LINE__);
        }
        $this->PrivateFare = $privateFare;
        return $this;
    }
}
