<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicableTaxDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ApplicableTaxDetail
 * @subpackage Structs
 */
class ApplicableTaxDetail extends AbstractStructBase
{
    /**
     * The TaxID
     * @var int
     */
    public $TaxID;
    /**
     * The Amt
     * @var float
     */
    public $Amt;
    /**
     * The InitiatingTaxID
     * @var int
     */
    public $InitiatingTaxID;
    /**
     * The CommissionAmount
     * @var float
     */
    public $CommissionAmount;
    /**
     * Constructor method for ApplicableTaxDetail
     * @uses ApplicableTaxDetail::setTaxID()
     * @uses ApplicableTaxDetail::setAmt()
     * @uses ApplicableTaxDetail::setInitiatingTaxID()
     * @uses ApplicableTaxDetail::setCommissionAmount()
     * @param int $taxID
     * @param float $amt
     * @param int $initiatingTaxID
     * @param float $commissionAmount
     */
    public function __construct($taxID = null, $amt = null, $initiatingTaxID = null, $commissionAmount = null)
    {
        $this
            ->setTaxID($taxID)
            ->setAmt($amt)
            ->setInitiatingTaxID($initiatingTaxID)
            ->setCommissionAmount($commissionAmount);
    }
    /**
     * Get TaxID value
     * @return int|null
     */
    public function getTaxID()
    {
        return $this->TaxID;
    }
    /**
     * Set TaxID value
     * @param int $taxID
     * @return \StructType\ApplicableTaxDetail
     */
    public function setTaxID($taxID = null)
    {
        // validation for constraint: int
        if (!is_null($taxID) && !(is_int($taxID) || ctype_digit($taxID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxID, true), gettype($taxID)), __LINE__);
        }
        $this->TaxID = $taxID;
        return $this;
    }
    /**
     * Get Amt value
     * @return float|null
     */
    public function getAmt()
    {
        return $this->Amt;
    }
    /**
     * Set Amt value
     * @param float $amt
     * @return \StructType\ApplicableTaxDetail
     */
    public function setAmt($amt = null)
    {
        // validation for constraint: float
        if (!is_null($amt) && !(is_float($amt) || is_numeric($amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amt, true), gettype($amt)), __LINE__);
        }
        $this->Amt = $amt;
        return $this;
    }
    /**
     * Get InitiatingTaxID value
     * @return int|null
     */
    public function getInitiatingTaxID()
    {
        return $this->InitiatingTaxID;
    }
    /**
     * Set InitiatingTaxID value
     * @param int $initiatingTaxID
     * @return \StructType\ApplicableTaxDetail
     */
    public function setInitiatingTaxID($initiatingTaxID = null)
    {
        // validation for constraint: int
        if (!is_null($initiatingTaxID) && !(is_int($initiatingTaxID) || ctype_digit($initiatingTaxID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($initiatingTaxID, true), gettype($initiatingTaxID)), __LINE__);
        }
        $this->InitiatingTaxID = $initiatingTaxID;
        return $this;
    }
    /**
     * Get CommissionAmount value
     * @return float|null
     */
    public function getCommissionAmount()
    {
        return $this->CommissionAmount;
    }
    /**
     * Set CommissionAmount value
     * @param float $commissionAmount
     * @return \StructType\ApplicableTaxDetail
     */
    public function setCommissionAmount($commissionAmount = null)
    {
        // validation for constraint: float
        if (!is_null($commissionAmount) && !(is_float($commissionAmount) || is_numeric($commissionAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionAmount, true), gettype($commissionAmount)), __LINE__);
        }
        $this->CommissionAmount = $commissionAmount;
        return $this;
    }
}
