<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdjustmentDetailBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdjustmentDetailBase
 * @subpackage Structs
 */
class AdjustmentDetailBase extends ServiceQuote
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The AdjustmentType
     * @var string
     */
    public $AdjustmentType;
    /**
     * The Level
     * @var string
     */
    public $Level;
    /**
     * Constructor method for AdjustmentDetailBase
     * @uses AdjustmentDetailBase::setAmount()
     * @uses AdjustmentDetailBase::setAdjustmentType()
     * @uses AdjustmentDetailBase::setLevel()
     * @param float $amount
     * @param string $adjustmentType
     * @param string $level
     */
    public function __construct($amount = null, $adjustmentType = null, $level = null)
    {
        $this
            ->setAmount($amount)
            ->setAdjustmentType($adjustmentType)
            ->setLevel($level);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\AdjustmentDetailBase
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get AdjustmentType value
     * @return string|null
     */
    public function getAdjustmentType()
    {
        return $this->AdjustmentType;
    }
    /**
     * Set AdjustmentType value
     * @uses \EnumType\AdjustmentDetailType::valueIsValid()
     * @uses \EnumType\AdjustmentDetailType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $adjustmentType
     * @return \StructType\AdjustmentDetailBase
     */
    public function setAdjustmentType($adjustmentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdjustmentDetailType::valueIsValid($adjustmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdjustmentDetailType', is_array($adjustmentType) ? implode(', ', $adjustmentType) : var_export($adjustmentType, true), implode(', ', \EnumType\AdjustmentDetailType::getValidValues())), __LINE__);
        }
        $this->AdjustmentType = $adjustmentType;
        return $this;
    }
    /**
     * Get Level value
     * @return string|null
     */
    public function getLevel()
    {
        return $this->Level;
    }
    /**
     * Set Level value
     * @uses \EnumType\AdjustmentLevel::valueIsValid()
     * @uses \EnumType\AdjustmentLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $level
     * @return \StructType\AdjustmentDetailBase
     */
    public function setLevel($level = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdjustmentLevel::valueIsValid($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdjustmentLevel', is_array($level) ? implode(', ', $level) : var_export($level, true), implode(', ', \EnumType\AdjustmentLevel::getValidValues())), __LINE__);
        }
        $this->Level = $level;
        return $this;
    }
}
