<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AARRequestPtc StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AARRequestPtc
 * @subpackage Structs
 */
class AARRequestPtc extends AbstractStructBase
{
    /**
     * The PassengerTypeID
     * @var int
     */
    public $PassengerTypeID;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for AARRequestPtc
     * @uses AARRequestPtc::setPassengerTypeID()
     * @uses AARRequestPtc::setQuantity()
     * @param int $passengerTypeID
     * @param int $quantity
     */
    public function __construct($passengerTypeID = null, $quantity = null)
    {
        $this
            ->setPassengerTypeID($passengerTypeID)
            ->setQuantity($quantity);
    }
    /**
     * Get PassengerTypeID value
     * @return int|null
     */
    public function getPassengerTypeID()
    {
        return $this->PassengerTypeID;
    }
    /**
     * Set PassengerTypeID value
     * @param int $passengerTypeID
     * @return \StructType\AARRequestPtc
     */
    public function setPassengerTypeID($passengerTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($passengerTypeID) && !(is_int($passengerTypeID) || ctype_digit($passengerTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passengerTypeID, true), gettype($passengerTypeID)), __LINE__);
        }
        $this->PassengerTypeID = $passengerTypeID;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\AARRequestPtc
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
}
