<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retrieve ServiceType
 * @subpackage Services
 */
class Retrieve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RetrieveFastFareSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveFastFareSearch $parameters
     * @return \StructType\RetrieveFastFareSearchResponse|bool
     */
    public function RetrieveFastFareSearch(\StructType\RetrieveFastFareSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveFastFareSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveFareQuote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveFareQuote $parameters
     * @return \StructType\RetrieveFareQuoteResponse|bool
     */
    public function RetrieveFareQuote(\StructType\RetrieveFareQuote $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveFareQuote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveFareQuoteDateRange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveFareQuoteDateRange $parameters
     * @return \StructType\RetrieveFareQuoteDateRangeResponse|bool
     */
    public function RetrieveFareQuoteDateRange(\StructType\RetrieveFareQuoteDateRange $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveFareQuoteDateRange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveServiceQuote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveServiceQuote $parameters
     * @return \StructType\RetrieveServiceQuoteResponse|bool
     */
    public function RetrieveServiceQuote(\StructType\RetrieveServiceQuote $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveServiceQuote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveServiceQuotes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveServiceQuotes $parameters
     * @return \StructType\RetrieveServiceQuotesResponse|bool
     */
    public function RetrieveServiceQuotes(\StructType\RetrieveServiceQuotes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveServiceQuotes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveSystemFareQuote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveSystemFareQuote $parameters
     * @return \StructType\RetrieveSystemFareQuoteResponse|bool
     */
    public function RetrieveSystemFareQuote(\StructType\RetrieveSystemFareQuote $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveSystemFareQuote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveFareQuoteShop
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveFareQuoteShop $parameters
     * @return \StructType\RetrieveFareQuoteShopResponse|bool
     */
    public function RetrieveFareQuoteShop(\StructType\RetrieveFareQuoteShop $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveFareQuoteShop($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveFareQuoteShopDateRange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveFareQuoteShopDateRange $parameters
     * @return \StructType\RetrieveFareQuoteShopDateRangeResponse|bool
     */
    public function RetrieveFareQuoteShopDateRange(\StructType\RetrieveFareQuoteShopDateRange $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveFareQuoteShopDateRange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveServiceSummaries
     * Meta information extracted from the WSDL
     * - documentation: <summary> gets the service summary info, this is for APIIBE-501 </summary> <param name="RetrieveServiceSummaryRequest">payload to determine response</param>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveServiceSummaries $parameters
     * @return \StructType\RetrieveServiceSummariesResponse|bool
     */
    public function RetrieveServiceSummaries(\StructType\RetrieveServiceSummaries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveServiceSummaries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveServiceQuoteShop
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveServiceQuoteShop $parameters
     * @return \StructType\RetrieveServiceQuoteShopResponse|bool
     */
    public function RetrieveServiceQuoteShop(\StructType\RetrieveServiceQuoteShop $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveServiceQuoteShop($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveAARQuote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAARQuote $parameters
     * @return \StructType\RetrieveAARQuoteResponse|bool
     */
    public function RetrieveAARQuote(\StructType\RetrieveAARQuote $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAARQuote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveFareBundleDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveFareBundleDetails $parameters
     * @return \StructType\RetrieveFareBundleDetailsResponse|bool
     */
    public function RetrieveFareBundleDetails(\StructType\RetrieveFareBundleDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveFareBundleDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveServiceBundleDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveServiceBundleDetails $parameters
     * @return \StructType\RetrieveServiceBundleDetailsResponse|bool
     */
    public function RetrieveServiceBundleDetails(\StructType\RetrieveServiceBundleDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveServiceBundleDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RetrieveAARQuoteResponse|\StructType\RetrieveFareBundleDetailsResponse|\StructType\RetrieveFareQuoteDateRangeResponse|\StructType\RetrieveFareQuoteResponse|\StructType\RetrieveFareQuoteShopDateRangeResponse|\StructType\RetrieveFareQuoteShopResponse|\StructType\RetrieveFastFareSearchResponse|\StructType\RetrieveServiceBundleDetailsResponse|\StructType\RetrieveServiceQuoteResponse|\StructType\RetrieveServiceQuoteShopResponse|\StructType\RetrieveServiceQuotesResponse|\StructType\RetrieveServiceSummariesResponse|\StructType\RetrieveSystemFareQuoteResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
