<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TripInfo
 * @subpackage Structs
 */
class TripInfo extends AbstractStructBase
{
    /**
     * The FlightDetailIdentifier
     * @var int
     */
    public $FlightDetailIdentifier;
    /**
     * The FareTypeInfos
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfFareTypeInfo
     */
    public $FareTypeInfos;
    /**
     * The CombinedTripInfos
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfCombinedTripInfo
     */
    public $CombinedTripInfos;
    /**
     * Constructor method for TripInfo
     * @uses TripInfo::setFlightDetailIdentifier()
     * @uses TripInfo::setFareTypeInfos()
     * @uses TripInfo::setCombinedTripInfos()
     * @param int $flightDetailIdentifier
     * @param \ArrayType\ArrayOfFareTypeInfo $fareTypeInfos
     * @param \ArrayType\ArrayOfCombinedTripInfo $combinedTripInfos
     */
    public function __construct($flightDetailIdentifier = null, \ArrayType\ArrayOfFareTypeInfo $fareTypeInfos = null, \ArrayType\ArrayOfCombinedTripInfo $combinedTripInfos = null)
    {
        $this
            ->setFlightDetailIdentifier($flightDetailIdentifier)
            ->setFareTypeInfos($fareTypeInfos)
            ->setCombinedTripInfos($combinedTripInfos);
    }
    /**
     * Get FlightDetailIdentifier value
     * @return int|null
     */
    public function getFlightDetailIdentifier()
    {
        return $this->FlightDetailIdentifier;
    }
    /**
     * Set FlightDetailIdentifier value
     * @param int $flightDetailIdentifier
     * @return \StructType\TripInfo
     */
    public function setFlightDetailIdentifier($flightDetailIdentifier = null)
    {
        // validation for constraint: int
        if (!is_null($flightDetailIdentifier) && !(is_int($flightDetailIdentifier) || ctype_digit($flightDetailIdentifier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($flightDetailIdentifier, true), gettype($flightDetailIdentifier)), __LINE__);
        }
        $this->FlightDetailIdentifier = $flightDetailIdentifier;
        return $this;
    }
    /**
     * Get FareTypeInfos value
     * @return \ArrayType\ArrayOfFareTypeInfo|null
     */
    public function getFareTypeInfos()
    {
        return $this->FareTypeInfos;
    }
    /**
     * Set FareTypeInfos value
     * @param \ArrayType\ArrayOfFareTypeInfo $fareTypeInfos
     * @return \StructType\TripInfo
     */
    public function setFareTypeInfos(\ArrayType\ArrayOfFareTypeInfo $fareTypeInfos = null)
    {
        $this->FareTypeInfos = $fareTypeInfos;
        return $this;
    }
    /**
     * Get CombinedTripInfos value
     * @return \ArrayType\ArrayOfCombinedTripInfo|null
     */
    public function getCombinedTripInfos()
    {
        return $this->CombinedTripInfos;
    }
    /**
     * Set CombinedTripInfos value
     * @param \ArrayType\ArrayOfCombinedTripInfo $combinedTripInfos
     * @return \StructType\TripInfo
     */
    public function setCombinedTripInfos(\ArrayType\ArrayOfCombinedTripInfo $combinedTripInfos = null)
    {
        $this->CombinedTripInfos = $combinedTripInfos;
        return $this;
    }
}
