<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceSummary StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ServiceSummary
 * @subpackage Structs
 */
class ServiceSummary extends AbstractStructBase
{
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Category;
    /**
     * The MarketingCarriers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $MarketingCarriers;
    /**
     * The OperatingCarriers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $OperatingCarriers;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * Constructor method for ServiceSummary
     * @uses ServiceSummary::setCategory()
     * @uses ServiceSummary::setMarketingCarriers()
     * @uses ServiceSummary::setOperatingCarriers()
     * @uses ServiceSummary::setCode()
     * @uses ServiceSummary::setDescription()
     * @param string $category
     * @param \ArrayType\ArrayOfstring $marketingCarriers
     * @param \ArrayType\ArrayOfstring $operatingCarriers
     * @param string $code
     * @param string $description
     */
    public function __construct($category = null, \ArrayType\ArrayOfstring $marketingCarriers = null, \ArrayType\ArrayOfstring $operatingCarriers = null, $code = null, $description = null)
    {
        $this
            ->setCategory($category)
            ->setMarketingCarriers($marketingCarriers)
            ->setOperatingCarriers($operatingCarriers)
            ->setCode($code)
            ->setDescription($description);
    }
    /**
     * Get Category value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategory()
    {
        return isset($this->Category) ? $this->Category : null;
    }
    /**
     * Set Category value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $category
     * @return \StructType\ServiceSummary
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        if (is_null($category) || (is_array($category) && empty($category))) {
            unset($this->Category);
        } else {
            $this->Category = $category;
        }
        return $this;
    }
    /**
     * Get MarketingCarriers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getMarketingCarriers()
    {
        return isset($this->MarketingCarriers) ? $this->MarketingCarriers : null;
    }
    /**
     * Set MarketingCarriers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $marketingCarriers
     * @return \StructType\ServiceSummary
     */
    public function setMarketingCarriers(\ArrayType\ArrayOfstring $marketingCarriers = null)
    {
        if (is_null($marketingCarriers) || (is_array($marketingCarriers) && empty($marketingCarriers))) {
            unset($this->MarketingCarriers);
        } else {
            $this->MarketingCarriers = $marketingCarriers;
        }
        return $this;
    }
    /**
     * Get OperatingCarriers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getOperatingCarriers()
    {
        return isset($this->OperatingCarriers) ? $this->OperatingCarriers : null;
    }
    /**
     * Set OperatingCarriers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $operatingCarriers
     * @return \StructType\ServiceSummary
     */
    public function setOperatingCarriers(\ArrayType\ArrayOfstring $operatingCarriers = null)
    {
        if (is_null($operatingCarriers) || (is_array($operatingCarriers) && empty($operatingCarriers))) {
            unset($this->OperatingCarriers);
        } else {
            $this->OperatingCarriers = $operatingCarriers;
        }
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\ServiceSummary
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ServiceSummary
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
