<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LegDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LegDetail
 * @subpackage Structs
 */
class LegDetail extends AbstractStructBase
{
    /**
     * The PFID
     * @var int
     */
    public $PFID;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The FlightNum
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FlightNum;
    /**
     * The International
     * @var bool
     */
    public $International;
    /**
     * The ArrivalDate
     * @var string
     */
    public $ArrivalDate;
    /**
     * The FlightTime
     * @var float
     */
    public $FlightTime;
    /**
     * The OperatingCarrier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OperatingCarrier;
    /**
     * The FromTerminal
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FromTerminal;
    /**
     * The ToTerminal
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ToTerminal;
    /**
     * The AircraftType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AircraftType;
    /**
     * The AircraftDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AircraftDescription;
    /**
     * The DeiDisclosure
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeiDisclosure;
    /**
     * The AircraftLayoutName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AircraftLayoutName;
    /**
     * The ServiceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceType;
    /**
     * The NonStopLogicalFlightId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NonStopLogicalFlightId;
    /**
     * Constructor method for LegDetail
     * @uses LegDetail::setPFID()
     * @uses LegDetail::setDepartureDate()
     * @uses LegDetail::setOrigin()
     * @uses LegDetail::setDestination()
     * @uses LegDetail::setFlightNum()
     * @uses LegDetail::setInternational()
     * @uses LegDetail::setArrivalDate()
     * @uses LegDetail::setFlightTime()
     * @uses LegDetail::setOperatingCarrier()
     * @uses LegDetail::setFromTerminal()
     * @uses LegDetail::setToTerminal()
     * @uses LegDetail::setAircraftType()
     * @uses LegDetail::setAircraftDescription()
     * @uses LegDetail::setDeiDisclosure()
     * @uses LegDetail::setAircraftLayoutName()
     * @uses LegDetail::setServiceType()
     * @uses LegDetail::setNonStopLogicalFlightId()
     * @param int $pFID
     * @param string $departureDate
     * @param string $origin
     * @param string $destination
     * @param string $flightNum
     * @param bool $international
     * @param string $arrivalDate
     * @param float $flightTime
     * @param string $operatingCarrier
     * @param string $fromTerminal
     * @param string $toTerminal
     * @param string $aircraftType
     * @param string $aircraftDescription
     * @param string $deiDisclosure
     * @param string $aircraftLayoutName
     * @param string $serviceType
     * @param int $nonStopLogicalFlightId
     */
    public function __construct($pFID = null, $departureDate = null, $origin = null, $destination = null, $flightNum = null, $international = null, $arrivalDate = null, $flightTime = null, $operatingCarrier = null, $fromTerminal = null, $toTerminal = null, $aircraftType = null, $aircraftDescription = null, $deiDisclosure = null, $aircraftLayoutName = null, $serviceType = null, $nonStopLogicalFlightId = null)
    {
        $this
            ->setPFID($pFID)
            ->setDepartureDate($departureDate)
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setFlightNum($flightNum)
            ->setInternational($international)
            ->setArrivalDate($arrivalDate)
            ->setFlightTime($flightTime)
            ->setOperatingCarrier($operatingCarrier)
            ->setFromTerminal($fromTerminal)
            ->setToTerminal($toTerminal)
            ->setAircraftType($aircraftType)
            ->setAircraftDescription($aircraftDescription)
            ->setDeiDisclosure($deiDisclosure)
            ->setAircraftLayoutName($aircraftLayoutName)
            ->setServiceType($serviceType)
            ->setNonStopLogicalFlightId($nonStopLogicalFlightId);
    }
    /**
     * Get PFID value
     * @return int|null
     */
    public function getPFID()
    {
        return $this->PFID;
    }
    /**
     * Set PFID value
     * @param int $pFID
     * @return \StructType\LegDetail
     */
    public function setPFID($pFID = null)
    {
        // validation for constraint: int
        if (!is_null($pFID) && !(is_int($pFID) || ctype_digit($pFID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pFID, true), gettype($pFID)), __LINE__);
        }
        $this->PFID = $pFID;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\LegDetail
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\LegDetail
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \StructType\LegDetail
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get FlightNum value
     * @return string|null
     */
    public function getFlightNum()
    {
        return $this->FlightNum;
    }
    /**
     * Set FlightNum value
     * @param string $flightNum
     * @return \StructType\LegDetail
     */
    public function setFlightNum($flightNum = null)
    {
        // validation for constraint: string
        if (!is_null($flightNum) && !is_string($flightNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNum, true), gettype($flightNum)), __LINE__);
        }
        $this->FlightNum = $flightNum;
        return $this;
    }
    /**
     * Get International value
     * @return bool|null
     */
    public function getInternational()
    {
        return $this->International;
    }
    /**
     * Set International value
     * @param bool $international
     * @return \StructType\LegDetail
     */
    public function setInternational($international = null)
    {
        // validation for constraint: boolean
        if (!is_null($international) && !is_bool($international)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($international, true), gettype($international)), __LINE__);
        }
        $this->International = $international;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\LegDetail
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDate, true), gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get FlightTime value
     * @return float|null
     */
    public function getFlightTime()
    {
        return $this->FlightTime;
    }
    /**
     * Set FlightTime value
     * @param float $flightTime
     * @return \StructType\LegDetail
     */
    public function setFlightTime($flightTime = null)
    {
        // validation for constraint: float
        if (!is_null($flightTime) && !(is_float($flightTime) || is_numeric($flightTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($flightTime, true), gettype($flightTime)), __LINE__);
        }
        $this->FlightTime = $flightTime;
        return $this;
    }
    /**
     * Get OperatingCarrier value
     * @return string|null
     */
    public function getOperatingCarrier()
    {
        return $this->OperatingCarrier;
    }
    /**
     * Set OperatingCarrier value
     * @param string $operatingCarrier
     * @return \StructType\LegDetail
     */
    public function setOperatingCarrier($operatingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCarrier) && !is_string($operatingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingCarrier, true), gettype($operatingCarrier)), __LINE__);
        }
        $this->OperatingCarrier = $operatingCarrier;
        return $this;
    }
    /**
     * Get FromTerminal value
     * @return string|null
     */
    public function getFromTerminal()
    {
        return $this->FromTerminal;
    }
    /**
     * Set FromTerminal value
     * @param string $fromTerminal
     * @return \StructType\LegDetail
     */
    public function setFromTerminal($fromTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($fromTerminal) && !is_string($fromTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromTerminal, true), gettype($fromTerminal)), __LINE__);
        }
        $this->FromTerminal = $fromTerminal;
        return $this;
    }
    /**
     * Get ToTerminal value
     * @return string|null
     */
    public function getToTerminal()
    {
        return $this->ToTerminal;
    }
    /**
     * Set ToTerminal value
     * @param string $toTerminal
     * @return \StructType\LegDetail
     */
    public function setToTerminal($toTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($toTerminal) && !is_string($toTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toTerminal, true), gettype($toTerminal)), __LINE__);
        }
        $this->ToTerminal = $toTerminal;
        return $this;
    }
    /**
     * Get AircraftType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAircraftType()
    {
        return isset($this->AircraftType) ? $this->AircraftType : null;
    }
    /**
     * Set AircraftType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aircraftType
     * @return \StructType\LegDetail
     */
    public function setAircraftType($aircraftType = null)
    {
        // validation for constraint: string
        if (!is_null($aircraftType) && !is_string($aircraftType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aircraftType, true), gettype($aircraftType)), __LINE__);
        }
        if (is_null($aircraftType) || (is_array($aircraftType) && empty($aircraftType))) {
            unset($this->AircraftType);
        } else {
            $this->AircraftType = $aircraftType;
        }
        return $this;
    }
    /**
     * Get AircraftDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAircraftDescription()
    {
        return isset($this->AircraftDescription) ? $this->AircraftDescription : null;
    }
    /**
     * Set AircraftDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aircraftDescription
     * @return \StructType\LegDetail
     */
    public function setAircraftDescription($aircraftDescription = null)
    {
        // validation for constraint: string
        if (!is_null($aircraftDescription) && !is_string($aircraftDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aircraftDescription, true), gettype($aircraftDescription)), __LINE__);
        }
        if (is_null($aircraftDescription) || (is_array($aircraftDescription) && empty($aircraftDescription))) {
            unset($this->AircraftDescription);
        } else {
            $this->AircraftDescription = $aircraftDescription;
        }
        return $this;
    }
    /**
     * Get DeiDisclosure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeiDisclosure()
    {
        return isset($this->DeiDisclosure) ? $this->DeiDisclosure : null;
    }
    /**
     * Set DeiDisclosure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deiDisclosure
     * @return \StructType\LegDetail
     */
    public function setDeiDisclosure($deiDisclosure = null)
    {
        // validation for constraint: string
        if (!is_null($deiDisclosure) && !is_string($deiDisclosure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deiDisclosure, true), gettype($deiDisclosure)), __LINE__);
        }
        if (is_null($deiDisclosure) || (is_array($deiDisclosure) && empty($deiDisclosure))) {
            unset($this->DeiDisclosure);
        } else {
            $this->DeiDisclosure = $deiDisclosure;
        }
        return $this;
    }
    /**
     * Get AircraftLayoutName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAircraftLayoutName()
    {
        return isset($this->AircraftLayoutName) ? $this->AircraftLayoutName : null;
    }
    /**
     * Set AircraftLayoutName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aircraftLayoutName
     * @return \StructType\LegDetail
     */
    public function setAircraftLayoutName($aircraftLayoutName = null)
    {
        // validation for constraint: string
        if (!is_null($aircraftLayoutName) && !is_string($aircraftLayoutName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aircraftLayoutName, true), gettype($aircraftLayoutName)), __LINE__);
        }
        if (is_null($aircraftLayoutName) || (is_array($aircraftLayoutName) && empty($aircraftLayoutName))) {
            unset($this->AircraftLayoutName);
        } else {
            $this->AircraftLayoutName = $aircraftLayoutName;
        }
        return $this;
    }
    /**
     * Get ServiceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceType()
    {
        return isset($this->ServiceType) ? $this->ServiceType : null;
    }
    /**
     * Set ServiceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceType
     * @return \StructType\LegDetail
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceType, true), gettype($serviceType)), __LINE__);
        }
        if (is_null($serviceType) || (is_array($serviceType) && empty($serviceType))) {
            unset($this->ServiceType);
        } else {
            $this->ServiceType = $serviceType;
        }
        return $this;
    }
    /**
     * Get NonStopLogicalFlightId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNonStopLogicalFlightId()
    {
        return isset($this->NonStopLogicalFlightId) ? $this->NonStopLogicalFlightId : null;
    }
    /**
     * Set NonStopLogicalFlightId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nonStopLogicalFlightId
     * @return \StructType\LegDetail
     */
    public function setNonStopLogicalFlightId($nonStopLogicalFlightId = null)
    {
        // validation for constraint: int
        if (!is_null($nonStopLogicalFlightId) && !(is_int($nonStopLogicalFlightId) || ctype_digit($nonStopLogicalFlightId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nonStopLogicalFlightId, true), gettype($nonStopLogicalFlightId)), __LINE__);
        }
        if (is_null($nonStopLogicalFlightId) || (is_array($nonStopLogicalFlightId) && empty($nonStopLogicalFlightId))) {
            unset($this->NonStopLogicalFlightId);
        } else {
            $this->NonStopLogicalFlightId = $nonStopLogicalFlightId;
        }
        return $this;
    }
}
