<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FareType
 * @subpackage Structs
 */
class FareType extends AbstractStructBase
{
    /**
     * The FareTypeID
     * @var int
     */
    public $FareTypeID;
    /**
     * The FareTypeName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FareTypeName;
    /**
     * The FilterRemove
     * @var bool
     */
    public $FilterRemove;
    /**
     * The FareInfos
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfFareInfo
     */
    public $FareInfos;
    /**
     * Constructor method for FareType
     * @uses FareType::setFareTypeID()
     * @uses FareType::setFareTypeName()
     * @uses FareType::setFilterRemove()
     * @uses FareType::setFareInfos()
     * @param int $fareTypeID
     * @param string $fareTypeName
     * @param bool $filterRemove
     * @param \ArrayType\ArrayOfFareInfo $fareInfos
     */
    public function __construct($fareTypeID = null, $fareTypeName = null, $filterRemove = null, \ArrayType\ArrayOfFareInfo $fareInfos = null)
    {
        $this
            ->setFareTypeID($fareTypeID)
            ->setFareTypeName($fareTypeName)
            ->setFilterRemove($filterRemove)
            ->setFareInfos($fareInfos);
    }
    /**
     * Get FareTypeID value
     * @return int|null
     */
    public function getFareTypeID()
    {
        return $this->FareTypeID;
    }
    /**
     * Set FareTypeID value
     * @param int $fareTypeID
     * @return \StructType\FareType
     */
    public function setFareTypeID($fareTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($fareTypeID) && !(is_int($fareTypeID) || ctype_digit($fareTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fareTypeID, true), gettype($fareTypeID)), __LINE__);
        }
        $this->FareTypeID = $fareTypeID;
        return $this;
    }
    /**
     * Get FareTypeName value
     * @return string|null
     */
    public function getFareTypeName()
    {
        return $this->FareTypeName;
    }
    /**
     * Set FareTypeName value
     * @param string $fareTypeName
     * @return \StructType\FareType
     */
    public function setFareTypeName($fareTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($fareTypeName) && !is_string($fareTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareTypeName, true), gettype($fareTypeName)), __LINE__);
        }
        $this->FareTypeName = $fareTypeName;
        return $this;
    }
    /**
     * Get FilterRemove value
     * @return bool|null
     */
    public function getFilterRemove()
    {
        return $this->FilterRemove;
    }
    /**
     * Set FilterRemove value
     * @param bool $filterRemove
     * @return \StructType\FareType
     */
    public function setFilterRemove($filterRemove = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterRemove) && !is_bool($filterRemove)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filterRemove, true), gettype($filterRemove)), __LINE__);
        }
        $this->FilterRemove = $filterRemove;
        return $this;
    }
    /**
     * Get FareInfos value
     * @return \ArrayType\ArrayOfFareInfo|null
     */
    public function getFareInfos()
    {
        return $this->FareInfos;
    }
    /**
     * Set FareInfos value
     * @param \ArrayType\ArrayOfFareInfo $fareInfos
     * @return \StructType\FareType
     */
    public function setFareInfos(\ArrayType\ArrayOfFareInfo $fareInfos = null)
    {
        $this->FareInfos = $fareInfos;
        return $this;
    }
}
