<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareShopAdjustment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FareShopAdjustment
 * @subpackage Structs
 */
class FareShopAdjustment extends TransactionInfoNoSession
{
    /**
     * The CurrencyOfFareQuote
     * @var string
     */
    public $CurrencyOfFareQuote;
    /**
     * The FareAdjustmentDetails
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfFareShopAdjustmentDetail
     */
    public $FareAdjustmentDetails;
    /**
     * The IataNumberOfRequestor
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IataNumberOfRequestor;
    /**
     * The IncludeCommissionInCharge
     * @var bool
     */
    public $IncludeCommissionInCharge;
    /**
     * Constructor method for FareShopAdjustment
     * @uses FareShopAdjustment::setCurrencyOfFareQuote()
     * @uses FareShopAdjustment::setFareAdjustmentDetails()
     * @uses FareShopAdjustment::setIataNumberOfRequestor()
     * @uses FareShopAdjustment::setIncludeCommissionInCharge()
     * @param string $currencyOfFareQuote
     * @param \ArrayType\ArrayOfFareShopAdjustmentDetail $fareAdjustmentDetails
     * @param string $iataNumberOfRequestor
     * @param bool $includeCommissionInCharge
     */
    public function __construct($currencyOfFareQuote = null, \ArrayType\ArrayOfFareShopAdjustmentDetail $fareAdjustmentDetails = null, $iataNumberOfRequestor = null, $includeCommissionInCharge = null)
    {
        $this
            ->setCurrencyOfFareQuote($currencyOfFareQuote)
            ->setFareAdjustmentDetails($fareAdjustmentDetails)
            ->setIataNumberOfRequestor($iataNumberOfRequestor)
            ->setIncludeCommissionInCharge($includeCommissionInCharge);
    }
    /**
     * Get CurrencyOfFareQuote value
     * @return string|null
     */
    public function getCurrencyOfFareQuote()
    {
        return $this->CurrencyOfFareQuote;
    }
    /**
     * Set CurrencyOfFareQuote value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currencyOfFareQuote
     * @return \StructType\FareShopAdjustment
     */
    public function setCurrencyOfFareQuote($currencyOfFareQuote = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($currencyOfFareQuote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($currencyOfFareQuote) ? implode(', ', $currencyOfFareQuote) : var_export($currencyOfFareQuote, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->CurrencyOfFareQuote = $currencyOfFareQuote;
        return $this;
    }
    /**
     * Get FareAdjustmentDetails value
     * @return \ArrayType\ArrayOfFareShopAdjustmentDetail|null
     */
    public function getFareAdjustmentDetails()
    {
        return $this->FareAdjustmentDetails;
    }
    /**
     * Set FareAdjustmentDetails value
     * @param \ArrayType\ArrayOfFareShopAdjustmentDetail $fareAdjustmentDetails
     * @return \StructType\FareShopAdjustment
     */
    public function setFareAdjustmentDetails(\ArrayType\ArrayOfFareShopAdjustmentDetail $fareAdjustmentDetails = null)
    {
        $this->FareAdjustmentDetails = $fareAdjustmentDetails;
        return $this;
    }
    /**
     * Get IataNumberOfRequestor value
     * @return string|null
     */
    public function getIataNumberOfRequestor()
    {
        return $this->IataNumberOfRequestor;
    }
    /**
     * Set IataNumberOfRequestor value
     * @param string $iataNumberOfRequestor
     * @return \StructType\FareShopAdjustment
     */
    public function setIataNumberOfRequestor($iataNumberOfRequestor = null)
    {
        // validation for constraint: string
        if (!is_null($iataNumberOfRequestor) && !is_string($iataNumberOfRequestor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iataNumberOfRequestor, true), gettype($iataNumberOfRequestor)), __LINE__);
        }
        $this->IataNumberOfRequestor = $iataNumberOfRequestor;
        return $this;
    }
    /**
     * Get IncludeCommissionInCharge value
     * @return bool|null
     */
    public function getIncludeCommissionInCharge()
    {
        return $this->IncludeCommissionInCharge;
    }
    /**
     * Set IncludeCommissionInCharge value
     * @param bool $includeCommissionInCharge
     * @return \StructType\FareShopAdjustment
     */
    public function setIncludeCommissionInCharge($includeCommissionInCharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeCommissionInCharge) && !is_bool($includeCommissionInCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeCommissionInCharge, true), gettype($includeCommissionInCharge)), __LINE__);
        }
        $this->IncludeCommissionInCharge = $includeCommissionInCharge;
        return $this;
    }
}
