<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CombinedTripInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CombinedTripInfo
 * @subpackage Structs
 */
class CombinedTripInfo extends AbstractStructBase
{
    /**
     * The FlightDetailIdentifier
     * @var int
     */
    public $FlightDetailIdentifier;
    /**
     * The FareTypeInfos
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfFareTypeInfo
     */
    public $FareTypeInfos;
    /**
     * Constructor method for CombinedTripInfo
     * @uses CombinedTripInfo::setFlightDetailIdentifier()
     * @uses CombinedTripInfo::setFareTypeInfos()
     * @param int $flightDetailIdentifier
     * @param \ArrayType\ArrayOfFareTypeInfo $fareTypeInfos
     */
    public function __construct($flightDetailIdentifier = null, \ArrayType\ArrayOfFareTypeInfo $fareTypeInfos = null)
    {
        $this
            ->setFlightDetailIdentifier($flightDetailIdentifier)
            ->setFareTypeInfos($fareTypeInfos);
    }
    /**
     * Get FlightDetailIdentifier value
     * @return int|null
     */
    public function getFlightDetailIdentifier()
    {
        return $this->FlightDetailIdentifier;
    }
    /**
     * Set FlightDetailIdentifier value
     * @param int $flightDetailIdentifier
     * @return \StructType\CombinedTripInfo
     */
    public function setFlightDetailIdentifier($flightDetailIdentifier = null)
    {
        // validation for constraint: int
        if (!is_null($flightDetailIdentifier) && !(is_int($flightDetailIdentifier) || ctype_digit($flightDetailIdentifier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($flightDetailIdentifier, true), gettype($flightDetailIdentifier)), __LINE__);
        }
        $this->FlightDetailIdentifier = $flightDetailIdentifier;
        return $this;
    }
    /**
     * Get FareTypeInfos value
     * @return \ArrayType\ArrayOfFareTypeInfo|null
     */
    public function getFareTypeInfos()
    {
        return $this->FareTypeInfos;
    }
    /**
     * Set FareTypeInfos value
     * @param \ArrayType\ArrayOfFareTypeInfo $fareTypeInfos
     * @return \StructType\CombinedTripInfo
     */
    public function setFareTypeInfos(\ArrayType\ArrayOfFareTypeInfo $fareTypeInfos = null)
    {
        $this->FareTypeInfos = $fareTypeInfos;
        return $this;
    }
}
