<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BundleServiceDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BundleServiceDetail
 * @subpackage Structs
 */
class BundleServiceDetail extends AbstractStructBase
{
    /**
     * The BundleGroupIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BundleGroupIndex;
    /**
     * The BundleQtyGroupIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BundleQtyGroupIndex;
    /**
     * The CategoryID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CategoryID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The GlCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GlCode;
    /**
     * The IsMaxinventory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsMaxinventory;
    /**
     * The ServiceID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ServiceID;
    /**
     * The SsrCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SsrCode;
    /**
     * Constructor method for BundleServiceDetail
     * @uses BundleServiceDetail::setBundleGroupIndex()
     * @uses BundleServiceDetail::setBundleQtyGroupIndex()
     * @uses BundleServiceDetail::setCategoryID()
     * @uses BundleServiceDetail::setDescription()
     * @uses BundleServiceDetail::setGlCode()
     * @uses BundleServiceDetail::setIsMaxinventory()
     * @uses BundleServiceDetail::setServiceID()
     * @uses BundleServiceDetail::setSsrCode()
     * @param int $bundleGroupIndex
     * @param int $bundleQtyGroupIndex
     * @param int $categoryID
     * @param string $description
     * @param string $glCode
     * @param bool $isMaxinventory
     * @param int $serviceID
     * @param string $ssrCode
     */
    public function __construct($bundleGroupIndex = null, $bundleQtyGroupIndex = null, $categoryID = null, $description = null, $glCode = null, $isMaxinventory = null, $serviceID = null, $ssrCode = null)
    {
        $this
            ->setBundleGroupIndex($bundleGroupIndex)
            ->setBundleQtyGroupIndex($bundleQtyGroupIndex)
            ->setCategoryID($categoryID)
            ->setDescription($description)
            ->setGlCode($glCode)
            ->setIsMaxinventory($isMaxinventory)
            ->setServiceID($serviceID)
            ->setSsrCode($ssrCode);
    }
    /**
     * Get BundleGroupIndex value
     * @return int|null
     */
    public function getBundleGroupIndex()
    {
        return $this->BundleGroupIndex;
    }
    /**
     * Set BundleGroupIndex value
     * @param int $bundleGroupIndex
     * @return \StructType\BundleServiceDetail
     */
    public function setBundleGroupIndex($bundleGroupIndex = null)
    {
        // validation for constraint: int
        if (!is_null($bundleGroupIndex) && !(is_int($bundleGroupIndex) || ctype_digit($bundleGroupIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bundleGroupIndex, true), gettype($bundleGroupIndex)), __LINE__);
        }
        $this->BundleGroupIndex = $bundleGroupIndex;
        return $this;
    }
    /**
     * Get BundleQtyGroupIndex value
     * @return int|null
     */
    public function getBundleQtyGroupIndex()
    {
        return $this->BundleQtyGroupIndex;
    }
    /**
     * Set BundleQtyGroupIndex value
     * @param int $bundleQtyGroupIndex
     * @return \StructType\BundleServiceDetail
     */
    public function setBundleQtyGroupIndex($bundleQtyGroupIndex = null)
    {
        // validation for constraint: int
        if (!is_null($bundleQtyGroupIndex) && !(is_int($bundleQtyGroupIndex) || ctype_digit($bundleQtyGroupIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bundleQtyGroupIndex, true), gettype($bundleQtyGroupIndex)), __LINE__);
        }
        $this->BundleQtyGroupIndex = $bundleQtyGroupIndex;
        return $this;
    }
    /**
     * Get CategoryID value
     * @return int|null
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param int $categoryID
     * @return \StructType\BundleServiceDetail
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: int
        if (!is_null($categoryID) && !(is_int($categoryID) || ctype_digit($categoryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryID, true), gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\BundleServiceDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get GlCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGlCode()
    {
        return isset($this->GlCode) ? $this->GlCode : null;
    }
    /**
     * Set GlCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $glCode
     * @return \StructType\BundleServiceDetail
     */
    public function setGlCode($glCode = null)
    {
        // validation for constraint: string
        if (!is_null($glCode) && !is_string($glCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($glCode, true), gettype($glCode)), __LINE__);
        }
        if (is_null($glCode) || (is_array($glCode) && empty($glCode))) {
            unset($this->GlCode);
        } else {
            $this->GlCode = $glCode;
        }
        return $this;
    }
    /**
     * Get IsMaxinventory value
     * @return bool|null
     */
    public function getIsMaxinventory()
    {
        return $this->IsMaxinventory;
    }
    /**
     * Set IsMaxinventory value
     * @param bool $isMaxinventory
     * @return \StructType\BundleServiceDetail
     */
    public function setIsMaxinventory($isMaxinventory = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMaxinventory) && !is_bool($isMaxinventory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMaxinventory, true), gettype($isMaxinventory)), __LINE__);
        }
        $this->IsMaxinventory = $isMaxinventory;
        return $this;
    }
    /**
     * Get ServiceID value
     * @return int|null
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param int $serviceID
     * @return \StructType\BundleServiceDetail
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceID) && !(is_int($serviceID) || ctype_digit($serviceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get SsrCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSsrCode()
    {
        return isset($this->SsrCode) ? $this->SsrCode : null;
    }
    /**
     * Set SsrCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ssrCode
     * @return \StructType\BundleServiceDetail
     */
    public function setSsrCode($ssrCode = null)
    {
        // validation for constraint: string
        if (!is_null($ssrCode) && !is_string($ssrCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ssrCode, true), gettype($ssrCode)), __LINE__);
        }
        if (is_null($ssrCode) || (is_array($ssrCode) && empty($ssrCode))) {
            unset($this->SsrCode);
        } else {
            $this->SsrCode = $ssrCode;
        }
        return $this;
    }
}
