<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewFareBundleDetailsResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewFareBundleDetailsResponse
 * @subpackage Structs
 */
class ViewFareBundleDetailsResponse extends AbstractStructBase
{
    /**
     * The BundleCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BundleCode;
    /**
     * The BundleDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BundleDescription;
    /**
     * The BundleGlCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BundleGlCode;
    /**
     * The BundleIataStdCodeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BundleIataStdCodeType;
    /**
     * The BundleId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BundleId;
    /**
     * The BundleIsMaxinventory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $BundleIsMaxinventory;
    /**
     * The BundleServiceDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBundleServiceDetail
     */
    public $BundleServiceDetails;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Version;
    /**
     * Constructor method for ViewFareBundleDetailsResponse
     * @uses ViewFareBundleDetailsResponse::setBundleCode()
     * @uses ViewFareBundleDetailsResponse::setBundleDescription()
     * @uses ViewFareBundleDetailsResponse::setBundleGlCode()
     * @uses ViewFareBundleDetailsResponse::setBundleIataStdCodeType()
     * @uses ViewFareBundleDetailsResponse::setBundleId()
     * @uses ViewFareBundleDetailsResponse::setBundleIsMaxinventory()
     * @uses ViewFareBundleDetailsResponse::setBundleServiceDetails()
     * @uses ViewFareBundleDetailsResponse::setExceptions()
     * @uses ViewFareBundleDetailsResponse::setVersion()
     * @param string $bundleCode
     * @param string $bundleDescription
     * @param string $bundleGlCode
     * @param string $bundleIataStdCodeType
     * @param int $bundleId
     * @param bool $bundleIsMaxinventory
     * @param \ArrayType\ArrayOfBundleServiceDetail $bundleServiceDetails
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @param string $version
     */
    public function __construct($bundleCode = null, $bundleDescription = null, $bundleGlCode = null, $bundleIataStdCodeType = null, $bundleId = null, $bundleIsMaxinventory = null, \ArrayType\ArrayOfBundleServiceDetail $bundleServiceDetails = null, \StructType\ExceptionInformation_Exceptions $exceptions = null, $version = null)
    {
        $this
            ->setBundleCode($bundleCode)
            ->setBundleDescription($bundleDescription)
            ->setBundleGlCode($bundleGlCode)
            ->setBundleIataStdCodeType($bundleIataStdCodeType)
            ->setBundleId($bundleId)
            ->setBundleIsMaxinventory($bundleIsMaxinventory)
            ->setBundleServiceDetails($bundleServiceDetails)
            ->setExceptions($exceptions)
            ->setVersion($version);
    }
    /**
     * Get BundleCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBundleCode()
    {
        return isset($this->BundleCode) ? $this->BundleCode : null;
    }
    /**
     * Set BundleCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bundleCode
     * @return \StructType\ViewFareBundleDetailsResponse
     */
    public function setBundleCode($bundleCode = null)
    {
        // validation for constraint: string
        if (!is_null($bundleCode) && !is_string($bundleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleCode, true), gettype($bundleCode)), __LINE__);
        }
        if (is_null($bundleCode) || (is_array($bundleCode) && empty($bundleCode))) {
            unset($this->BundleCode);
        } else {
            $this->BundleCode = $bundleCode;
        }
        return $this;
    }
    /**
     * Get BundleDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBundleDescription()
    {
        return isset($this->BundleDescription) ? $this->BundleDescription : null;
    }
    /**
     * Set BundleDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bundleDescription
     * @return \StructType\ViewFareBundleDetailsResponse
     */
    public function setBundleDescription($bundleDescription = null)
    {
        // validation for constraint: string
        if (!is_null($bundleDescription) && !is_string($bundleDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleDescription, true), gettype($bundleDescription)), __LINE__);
        }
        if (is_null($bundleDescription) || (is_array($bundleDescription) && empty($bundleDescription))) {
            unset($this->BundleDescription);
        } else {
            $this->BundleDescription = $bundleDescription;
        }
        return $this;
    }
    /**
     * Get BundleGlCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBundleGlCode()
    {
        return isset($this->BundleGlCode) ? $this->BundleGlCode : null;
    }
    /**
     * Set BundleGlCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bundleGlCode
     * @return \StructType\ViewFareBundleDetailsResponse
     */
    public function setBundleGlCode($bundleGlCode = null)
    {
        // validation for constraint: string
        if (!is_null($bundleGlCode) && !is_string($bundleGlCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleGlCode, true), gettype($bundleGlCode)), __LINE__);
        }
        if (is_null($bundleGlCode) || (is_array($bundleGlCode) && empty($bundleGlCode))) {
            unset($this->BundleGlCode);
        } else {
            $this->BundleGlCode = $bundleGlCode;
        }
        return $this;
    }
    /**
     * Get BundleIataStdCodeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBundleIataStdCodeType()
    {
        return isset($this->BundleIataStdCodeType) ? $this->BundleIataStdCodeType : null;
    }
    /**
     * Set BundleIataStdCodeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bundleIataStdCodeType
     * @return \StructType\ViewFareBundleDetailsResponse
     */
    public function setBundleIataStdCodeType($bundleIataStdCodeType = null)
    {
        // validation for constraint: string
        if (!is_null($bundleIataStdCodeType) && !is_string($bundleIataStdCodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleIataStdCodeType, true), gettype($bundleIataStdCodeType)), __LINE__);
        }
        if (is_null($bundleIataStdCodeType) || (is_array($bundleIataStdCodeType) && empty($bundleIataStdCodeType))) {
            unset($this->BundleIataStdCodeType);
        } else {
            $this->BundleIataStdCodeType = $bundleIataStdCodeType;
        }
        return $this;
    }
    /**
     * Get BundleId value
     * @return int|null
     */
    public function getBundleId()
    {
        return $this->BundleId;
    }
    /**
     * Set BundleId value
     * @param int $bundleId
     * @return \StructType\ViewFareBundleDetailsResponse
     */
    public function setBundleId($bundleId = null)
    {
        // validation for constraint: int
        if (!is_null($bundleId) && !(is_int($bundleId) || ctype_digit($bundleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bundleId, true), gettype($bundleId)), __LINE__);
        }
        $this->BundleId = $bundleId;
        return $this;
    }
    /**
     * Get BundleIsMaxinventory value
     * @return bool|null
     */
    public function getBundleIsMaxinventory()
    {
        return $this->BundleIsMaxinventory;
    }
    /**
     * Set BundleIsMaxinventory value
     * @param bool $bundleIsMaxinventory
     * @return \StructType\ViewFareBundleDetailsResponse
     */
    public function setBundleIsMaxinventory($bundleIsMaxinventory = null)
    {
        // validation for constraint: boolean
        if (!is_null($bundleIsMaxinventory) && !is_bool($bundleIsMaxinventory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bundleIsMaxinventory, true), gettype($bundleIsMaxinventory)), __LINE__);
        }
        $this->BundleIsMaxinventory = $bundleIsMaxinventory;
        return $this;
    }
    /**
     * Get BundleServiceDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBundleServiceDetail|null
     */
    public function getBundleServiceDetails()
    {
        return isset($this->BundleServiceDetails) ? $this->BundleServiceDetails : null;
    }
    /**
     * Set BundleServiceDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBundleServiceDetail $bundleServiceDetails
     * @return \StructType\ViewFareBundleDetailsResponse
     */
    public function setBundleServiceDetails(\ArrayType\ArrayOfBundleServiceDetail $bundleServiceDetails = null)
    {
        if (is_null($bundleServiceDetails) || (is_array($bundleServiceDetails) && empty($bundleServiceDetails))) {
            unset($this->BundleServiceDetails);
        } else {
            $this->BundleServiceDetails = $bundleServiceDetails;
        }
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ViewFareBundleDetailsResponse
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
    /**
     * Get Version value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVersion()
    {
        return isset($this->Version) ? $this->Version : null;
    }
    /**
     * Set Version value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $version
     * @return \StructType\ViewFareBundleDetailsResponse
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        if (is_null($version) || (is_array($version) && empty($version))) {
            unset($this->Version);
        } else {
            $this->Version = $version;
        }
        return $this;
    }
}
