<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionInfoNoSession StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionInfoNoSession
 * @subpackage Structs
 */
class TransactionInfoNoSession extends AbstractStructBase
{
    /**
     * The LogonID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LogonID;
    /**
     * The CarrierCodes
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfCarrierCode
     */
    public $CarrierCodes;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The ClientIPAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientIPAddress;
    /**
     * The TaPassword
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TaPassword;
    /**
     * The HistoricUserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HistoricUserName;
    /**
     * Constructor method for TransactionInfoNoSession
     * @uses TransactionInfoNoSession::setLogonID()
     * @uses TransactionInfoNoSession::setCarrierCodes()
     * @uses TransactionInfoNoSession::setPassword()
     * @uses TransactionInfoNoSession::setUserName()
     * @uses TransactionInfoNoSession::setClientIPAddress()
     * @uses TransactionInfoNoSession::setTaPassword()
     * @uses TransactionInfoNoSession::setHistoricUserName()
     * @param string $logonID
     * @param \ArrayType\ArrayOfCarrierCode $carrierCodes
     * @param string $password
     * @param string $userName
     * @param string $clientIPAddress
     * @param string $taPassword
     * @param string $historicUserName
     */
    public function __construct($logonID = null, \ArrayType\ArrayOfCarrierCode $carrierCodes = null, $password = null, $userName = null, $clientIPAddress = null, $taPassword = null, $historicUserName = null)
    {
        $this
            ->setLogonID($logonID)
            ->setCarrierCodes($carrierCodes)
            ->setPassword($password)
            ->setUserName($userName)
            ->setClientIPAddress($clientIPAddress)
            ->setTaPassword($taPassword)
            ->setHistoricUserName($historicUserName);
    }
    /**
     * Get LogonID value
     * @return string|null
     */
    public function getLogonID()
    {
        return $this->LogonID;
    }
    /**
     * Set LogonID value
     * @param string $logonID
     * @return \StructType\TransactionInfoNoSession
     */
    public function setLogonID($logonID = null)
    {
        // validation for constraint: string
        if (!is_null($logonID) && !is_string($logonID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logonID, true), gettype($logonID)), __LINE__);
        }
        $this->LogonID = $logonID;
        return $this;
    }
    /**
     * Get CarrierCodes value
     * @return \ArrayType\ArrayOfCarrierCode|null
     */
    public function getCarrierCodes()
    {
        return $this->CarrierCodes;
    }
    /**
     * Set CarrierCodes value
     * @param \ArrayType\ArrayOfCarrierCode $carrierCodes
     * @return \StructType\TransactionInfoNoSession
     */
    public function setCarrierCodes(\ArrayType\ArrayOfCarrierCode $carrierCodes = null)
    {
        $this->CarrierCodes = $carrierCodes;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\TransactionInfoNoSession
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\TransactionInfoNoSession
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get ClientIPAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientIPAddress()
    {
        return isset($this->ClientIPAddress) ? $this->ClientIPAddress : null;
    }
    /**
     * Set ClientIPAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientIPAddress
     * @return \StructType\TransactionInfoNoSession
     */
    public function setClientIPAddress($clientIPAddress = null)
    {
        // validation for constraint: string
        if (!is_null($clientIPAddress) && !is_string($clientIPAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIPAddress, true), gettype($clientIPAddress)), __LINE__);
        }
        if (is_null($clientIPAddress) || (is_array($clientIPAddress) && empty($clientIPAddress))) {
            unset($this->ClientIPAddress);
        } else {
            $this->ClientIPAddress = $clientIPAddress;
        }
        return $this;
    }
    /**
     * Get TaPassword value
     * @return string|null
     */
    public function getTaPassword()
    {
        return $this->TaPassword;
    }
    /**
     * Set TaPassword value
     * @param string $taPassword
     * @return \StructType\TransactionInfoNoSession
     */
    public function setTaPassword($taPassword = null)
    {
        // validation for constraint: string
        if (!is_null($taPassword) && !is_string($taPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taPassword, true), gettype($taPassword)), __LINE__);
        }
        $this->TaPassword = $taPassword;
        return $this;
    }
    /**
     * Get HistoricUserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHistoricUserName()
    {
        return isset($this->HistoricUserName) ? $this->HistoricUserName : null;
    }
    /**
     * Set HistoricUserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $historicUserName
     * @return \StructType\TransactionInfoNoSession
     */
    public function setHistoricUserName($historicUserName = null)
    {
        // validation for constraint: string
        if (!is_null($historicUserName) && !is_string($historicUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($historicUserName, true), gettype($historicUserName)), __LINE__);
        }
        if (is_null($historicUserName) || (is_array($historicUserName) && empty($historicUserName))) {
            unset($this->HistoricUserName);
        } else {
            $this->HistoricUserName = $historicUserName;
        }
        return $this;
    }
}
