<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TaxDetail
 * @subpackage Structs
 */
class TaxDetail extends AbstractStructBase
{
    /**
     * The TaxID
     * @var int
     */
    public $TaxID;
    /**
     * The TaxCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TaxCode;
    /**
     * The CodeType
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodeType;
    /**
     * The TaxCurr
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TaxCurr;
    /**
     * The TaxDesc
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TaxDesc;
    /**
     * The TaxType
     * @var int
     */
    public $TaxType;
    /**
     * The IsVat
     * @var bool
     */
    public $IsVat;
    /**
     * The IncludedInFare
     * @var bool
     */
    public $IncludedInFare;
    /**
     * The OriginalCurrency
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OriginalCurrency;
    /**
     * The ExchangeRate
     * @var float
     */
    public $ExchangeRate;
    /**
     * The ExchangeDate
     * @var string
     */
    public $ExchangeDate;
    /**
     * The Commissionable
     * @var bool
     */
    public $Commissionable;
    /**
     * Constructor method for TaxDetail
     * @uses TaxDetail::setTaxID()
     * @uses TaxDetail::setTaxCode()
     * @uses TaxDetail::setCodeType()
     * @uses TaxDetail::setTaxCurr()
     * @uses TaxDetail::setTaxDesc()
     * @uses TaxDetail::setTaxType()
     * @uses TaxDetail::setIsVat()
     * @uses TaxDetail::setIncludedInFare()
     * @uses TaxDetail::setOriginalCurrency()
     * @uses TaxDetail::setExchangeRate()
     * @uses TaxDetail::setExchangeDate()
     * @uses TaxDetail::setCommissionable()
     * @param int $taxID
     * @param string $taxCode
     * @param string $codeType
     * @param string $taxCurr
     * @param string $taxDesc
     * @param int $taxType
     * @param bool $isVat
     * @param bool $includedInFare
     * @param string $originalCurrency
     * @param float $exchangeRate
     * @param string $exchangeDate
     * @param bool $commissionable
     */
    public function __construct($taxID = null, $taxCode = null, $codeType = null, $taxCurr = null, $taxDesc = null, $taxType = null, $isVat = null, $includedInFare = null, $originalCurrency = null, $exchangeRate = null, $exchangeDate = null, $commissionable = null)
    {
        $this
            ->setTaxID($taxID)
            ->setTaxCode($taxCode)
            ->setCodeType($codeType)
            ->setTaxCurr($taxCurr)
            ->setTaxDesc($taxDesc)
            ->setTaxType($taxType)
            ->setIsVat($isVat)
            ->setIncludedInFare($includedInFare)
            ->setOriginalCurrency($originalCurrency)
            ->setExchangeRate($exchangeRate)
            ->setExchangeDate($exchangeDate)
            ->setCommissionable($commissionable);
    }
    /**
     * Get TaxID value
     * @return int|null
     */
    public function getTaxID()
    {
        return $this->TaxID;
    }
    /**
     * Set TaxID value
     * @param int $taxID
     * @return \StructType\TaxDetail
     */
    public function setTaxID($taxID = null)
    {
        // validation for constraint: int
        if (!is_null($taxID) && !(is_int($taxID) || ctype_digit($taxID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxID, true), gettype($taxID)), __LINE__);
        }
        $this->TaxID = $taxID;
        return $this;
    }
    /**
     * Get TaxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \StructType\TaxDetail
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCode, true), gettype($taxCode)), __LINE__);
        }
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Get CodeType value
     * @return string|null
     */
    public function getCodeType()
    {
        return $this->CodeType;
    }
    /**
     * Set CodeType value
     * @param string $codeType
     * @return \StructType\TaxDetail
     */
    public function setCodeType($codeType = null)
    {
        // validation for constraint: string
        if (!is_null($codeType) && !is_string($codeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeType, true), gettype($codeType)), __LINE__);
        }
        $this->CodeType = $codeType;
        return $this;
    }
    /**
     * Get TaxCurr value
     * @return string|null
     */
    public function getTaxCurr()
    {
        return $this->TaxCurr;
    }
    /**
     * Set TaxCurr value
     * @param string $taxCurr
     * @return \StructType\TaxDetail
     */
    public function setTaxCurr($taxCurr = null)
    {
        // validation for constraint: string
        if (!is_null($taxCurr) && !is_string($taxCurr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCurr, true), gettype($taxCurr)), __LINE__);
        }
        $this->TaxCurr = $taxCurr;
        return $this;
    }
    /**
     * Get TaxDesc value
     * @return string|null
     */
    public function getTaxDesc()
    {
        return $this->TaxDesc;
    }
    /**
     * Set TaxDesc value
     * @param string $taxDesc
     * @return \StructType\TaxDetail
     */
    public function setTaxDesc($taxDesc = null)
    {
        // validation for constraint: string
        if (!is_null($taxDesc) && !is_string($taxDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxDesc, true), gettype($taxDesc)), __LINE__);
        }
        $this->TaxDesc = $taxDesc;
        return $this;
    }
    /**
     * Get TaxType value
     * @return int|null
     */
    public function getTaxType()
    {
        return $this->TaxType;
    }
    /**
     * Set TaxType value
     * @param int $taxType
     * @return \StructType\TaxDetail
     */
    public function setTaxType($taxType = null)
    {
        // validation for constraint: int
        if (!is_null($taxType) && !(is_int($taxType) || ctype_digit($taxType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxType, true), gettype($taxType)), __LINE__);
        }
        $this->TaxType = $taxType;
        return $this;
    }
    /**
     * Get IsVat value
     * @return bool|null
     */
    public function getIsVat()
    {
        return $this->IsVat;
    }
    /**
     * Set IsVat value
     * @param bool $isVat
     * @return \StructType\TaxDetail
     */
    public function setIsVat($isVat = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVat) && !is_bool($isVat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVat, true), gettype($isVat)), __LINE__);
        }
        $this->IsVat = $isVat;
        return $this;
    }
    /**
     * Get IncludedInFare value
     * @return bool|null
     */
    public function getIncludedInFare()
    {
        return $this->IncludedInFare;
    }
    /**
     * Set IncludedInFare value
     * @param bool $includedInFare
     * @return \StructType\TaxDetail
     */
    public function setIncludedInFare($includedInFare = null)
    {
        // validation for constraint: boolean
        if (!is_null($includedInFare) && !is_bool($includedInFare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includedInFare, true), gettype($includedInFare)), __LINE__);
        }
        $this->IncludedInFare = $includedInFare;
        return $this;
    }
    /**
     * Get OriginalCurrency value
     * @return string|null
     */
    public function getOriginalCurrency()
    {
        return $this->OriginalCurrency;
    }
    /**
     * Set OriginalCurrency value
     * @param string $originalCurrency
     * @return \StructType\TaxDetail
     */
    public function setOriginalCurrency($originalCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($originalCurrency) && !is_string($originalCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalCurrency, true), gettype($originalCurrency)), __LINE__);
        }
        $this->OriginalCurrency = $originalCurrency;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \StructType\TaxDetail
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get ExchangeDate value
     * @return string|null
     */
    public function getExchangeDate()
    {
        return $this->ExchangeDate;
    }
    /**
     * Set ExchangeDate value
     * @param string $exchangeDate
     * @return \StructType\TaxDetail
     */
    public function setExchangeDate($exchangeDate = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeDate) && !is_string($exchangeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeDate, true), gettype($exchangeDate)), __LINE__);
        }
        $this->ExchangeDate = $exchangeDate;
        return $this;
    }
    /**
     * Get Commissionable value
     * @return bool|null
     */
    public function getCommissionable()
    {
        return $this->Commissionable;
    }
    /**
     * Set Commissionable value
     * @param bool $commissionable
     * @return \StructType\TaxDetail
     */
    public function setCommissionable($commissionable = null)
    {
        // validation for constraint: boolean
        if (!is_null($commissionable) && !is_bool($commissionable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($commissionable, true), gettype($commissionable)), __LINE__);
        }
        $this->Commissionable = $commissionable;
        return $this;
    }
}
