<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveFareQuote StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveFareQuote
 * @subpackage Structs
 */
class RetrieveFareQuote extends TransactionInfo
{
    /**
     * The RetrieveFareQuoteRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveFareQuote
     */
    public $RetrieveFareQuoteRequest;
    /**
     * The CurrencyOfFareQuote
     * @var string
     */
    public $CurrencyOfFareQuote;
    /**
     * The PromotionalCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PromotionalCode;
    /**
     * The IataNumberOfRequestor
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IataNumberOfRequestor;
    /**
     * The CorporationID
     * @var int
     */
    public $CorporationID;
    /**
     * The FareFilterMethod
     * @var string
     */
    public $FareFilterMethod;
    /**
     * The FareGroupMethod
     * @var string
     */
    public $FareGroupMethod;
    /**
     * The InventoryFilterMethod
     * @var string
     */
    public $InventoryFilterMethod;
    /**
     * The FareQuoteDetails
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfFareQuoteDetail
     */
    public $FareQuoteDetails;
    /**
     * The ProfileId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProfileId;
    /**
     * Constructor method for RetrieveFareQuote
     * @uses RetrieveFareQuote::setRetrieveFareQuoteRequest()
     * @uses RetrieveFareQuote::setCurrencyOfFareQuote()
     * @uses RetrieveFareQuote::setPromotionalCode()
     * @uses RetrieveFareQuote::setIataNumberOfRequestor()
     * @uses RetrieveFareQuote::setCorporationID()
     * @uses RetrieveFareQuote::setFareFilterMethod()
     * @uses RetrieveFareQuote::setFareGroupMethod()
     * @uses RetrieveFareQuote::setInventoryFilterMethod()
     * @uses RetrieveFareQuote::setFareQuoteDetails()
     * @uses RetrieveFareQuote::setProfileId()
     * @param \StructType\RetrieveFareQuote $retrieveFareQuoteRequest
     * @param string $currencyOfFareQuote
     * @param string $promotionalCode
     * @param string $iataNumberOfRequestor
     * @param int $corporationID
     * @param string $fareFilterMethod
     * @param string $fareGroupMethod
     * @param string $inventoryFilterMethod
     * @param \ArrayType\ArrayOfFareQuoteDetail $fareQuoteDetails
     * @param int $profileId
     */
    public function __construct(\StructType\RetrieveFareQuote $retrieveFareQuoteRequest = null, $currencyOfFareQuote = null, $promotionalCode = null, $iataNumberOfRequestor = null, $corporationID = null, $fareFilterMethod = null, $fareGroupMethod = null, $inventoryFilterMethod = null, \ArrayType\ArrayOfFareQuoteDetail $fareQuoteDetails = null, $profileId = null)
    {
        $this
            ->setRetrieveFareQuoteRequest($retrieveFareQuoteRequest)
            ->setCurrencyOfFareQuote($currencyOfFareQuote)
            ->setPromotionalCode($promotionalCode)
            ->setIataNumberOfRequestor($iataNumberOfRequestor)
            ->setCorporationID($corporationID)
            ->setFareFilterMethod($fareFilterMethod)
            ->setFareGroupMethod($fareGroupMethod)
            ->setInventoryFilterMethod($inventoryFilterMethod)
            ->setFareQuoteDetails($fareQuoteDetails)
            ->setProfileId($profileId);
    }
    /**
     * Get RetrieveFareQuoteRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveFareQuote|null
     */
    public function getRetrieveFareQuoteRequest()
    {
        return isset($this->RetrieveFareQuoteRequest) ? $this->RetrieveFareQuoteRequest : null;
    }
    /**
     * Set RetrieveFareQuoteRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveFareQuote $retrieveFareQuoteRequest
     * @return \StructType\RetrieveFareQuote
     */
    public function setRetrieveFareQuoteRequest(\StructType\RetrieveFareQuote $retrieveFareQuoteRequest = null)
    {
        if (is_null($retrieveFareQuoteRequest) || (is_array($retrieveFareQuoteRequest) && empty($retrieveFareQuoteRequest))) {
            unset($this->RetrieveFareQuoteRequest);
        } else {
            $this->RetrieveFareQuoteRequest = $retrieveFareQuoteRequest;
        }
        return $this;
    }
    /**
     * Get CurrencyOfFareQuote value
     * @return string|null
     */
    public function getCurrencyOfFareQuote()
    {
        return $this->CurrencyOfFareQuote;
    }
    /**
     * Set CurrencyOfFareQuote value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currencyOfFareQuote
     * @return \StructType\RetrieveFareQuote
     */
    public function setCurrencyOfFareQuote($currencyOfFareQuote = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($currencyOfFareQuote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($currencyOfFareQuote) ? implode(', ', $currencyOfFareQuote) : var_export($currencyOfFareQuote, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->CurrencyOfFareQuote = $currencyOfFareQuote;
        return $this;
    }
    /**
     * Get PromotionalCode value
     * @return string|null
     */
    public function getPromotionalCode()
    {
        return $this->PromotionalCode;
    }
    /**
     * Set PromotionalCode value
     * @param string $promotionalCode
     * @return \StructType\RetrieveFareQuote
     */
    public function setPromotionalCode($promotionalCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionalCode) && !is_string($promotionalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionalCode, true), gettype($promotionalCode)), __LINE__);
        }
        $this->PromotionalCode = $promotionalCode;
        return $this;
    }
    /**
     * Get IataNumberOfRequestor value
     * @return string|null
     */
    public function getIataNumberOfRequestor()
    {
        return $this->IataNumberOfRequestor;
    }
    /**
     * Set IataNumberOfRequestor value
     * @param string $iataNumberOfRequestor
     * @return \StructType\RetrieveFareQuote
     */
    public function setIataNumberOfRequestor($iataNumberOfRequestor = null)
    {
        // validation for constraint: string
        if (!is_null($iataNumberOfRequestor) && !is_string($iataNumberOfRequestor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iataNumberOfRequestor, true), gettype($iataNumberOfRequestor)), __LINE__);
        }
        $this->IataNumberOfRequestor = $iataNumberOfRequestor;
        return $this;
    }
    /**
     * Get CorporationID value
     * @return int|null
     */
    public function getCorporationID()
    {
        return $this->CorporationID;
    }
    /**
     * Set CorporationID value
     * @param int $corporationID
     * @return \StructType\RetrieveFareQuote
     */
    public function setCorporationID($corporationID = null)
    {
        // validation for constraint: int
        if (!is_null($corporationID) && !(is_int($corporationID) || ctype_digit($corporationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($corporationID, true), gettype($corporationID)), __LINE__);
        }
        $this->CorporationID = $corporationID;
        return $this;
    }
    /**
     * Get FareFilterMethod value
     * @return string|null
     */
    public function getFareFilterMethod()
    {
        return $this->FareFilterMethod;
    }
    /**
     * Set FareFilterMethod value
     * @uses \EnumType\Enums_FareFilterMethodType::valueIsValid()
     * @uses \EnumType\Enums_FareFilterMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fareFilterMethod
     * @return \StructType\RetrieveFareQuote
     */
    public function setFareFilterMethod($fareFilterMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enums_FareFilterMethodType::valueIsValid($fareFilterMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enums_FareFilterMethodType', is_array($fareFilterMethod) ? implode(', ', $fareFilterMethod) : var_export($fareFilterMethod, true), implode(', ', \EnumType\Enums_FareFilterMethodType::getValidValues())), __LINE__);
        }
        $this->FareFilterMethod = $fareFilterMethod;
        return $this;
    }
    /**
     * Get FareGroupMethod value
     * @return string|null
     */
    public function getFareGroupMethod()
    {
        return $this->FareGroupMethod;
    }
    /**
     * Set FareGroupMethod value
     * @uses \EnumType\Enums_FareGroupMethodType::valueIsValid()
     * @uses \EnumType\Enums_FareGroupMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fareGroupMethod
     * @return \StructType\RetrieveFareQuote
     */
    public function setFareGroupMethod($fareGroupMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enums_FareGroupMethodType::valueIsValid($fareGroupMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enums_FareGroupMethodType', is_array($fareGroupMethod) ? implode(', ', $fareGroupMethod) : var_export($fareGroupMethod, true), implode(', ', \EnumType\Enums_FareGroupMethodType::getValidValues())), __LINE__);
        }
        $this->FareGroupMethod = $fareGroupMethod;
        return $this;
    }
    /**
     * Get InventoryFilterMethod value
     * @return string|null
     */
    public function getInventoryFilterMethod()
    {
        return $this->InventoryFilterMethod;
    }
    /**
     * Set InventoryFilterMethod value
     * @uses \EnumType\Enums_InventoryFilterMethodType::valueIsValid()
     * @uses \EnumType\Enums_InventoryFilterMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $inventoryFilterMethod
     * @return \StructType\RetrieveFareQuote
     */
    public function setInventoryFilterMethod($inventoryFilterMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enums_InventoryFilterMethodType::valueIsValid($inventoryFilterMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enums_InventoryFilterMethodType', is_array($inventoryFilterMethod) ? implode(', ', $inventoryFilterMethod) : var_export($inventoryFilterMethod, true), implode(', ', \EnumType\Enums_InventoryFilterMethodType::getValidValues())), __LINE__);
        }
        $this->InventoryFilterMethod = $inventoryFilterMethod;
        return $this;
    }
    /**
     * Get FareQuoteDetails value
     * @return \ArrayType\ArrayOfFareQuoteDetail|null
     */
    public function getFareQuoteDetails()
    {
        return $this->FareQuoteDetails;
    }
    /**
     * Set FareQuoteDetails value
     * @param \ArrayType\ArrayOfFareQuoteDetail $fareQuoteDetails
     * @return \StructType\RetrieveFareQuote
     */
    public function setFareQuoteDetails(\ArrayType\ArrayOfFareQuoteDetail $fareQuoteDetails = null)
    {
        $this->FareQuoteDetails = $fareQuoteDetails;
        return $this;
    }
    /**
     * Get ProfileId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProfileId()
    {
        return isset($this->ProfileId) ? $this->ProfileId : null;
    }
    /**
     * Set ProfileId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $profileId
     * @return \StructType\RetrieveFareQuote
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !(is_int($profileId) || ctype_digit($profileId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileId, true), gettype($profileId)), __LINE__);
        }
        if (is_null($profileId) || (is_array($profileId) && empty($profileId))) {
            unset($this->ProfileId);
        } else {
            $this->ProfileId = $profileId;
        }
        return $this;
    }
}
