<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveAARQuote StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveAARQuote
 * @subpackage Structs
 */
class RetrieveAARQuote extends TransactionInfo
{
    /**
     * The RetrieveAARQuoteRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveAARQuote
     */
    public $RetrieveAARQuoteRequest;
    /**
     * The AARQuotes
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfAARQuote
     */
    public $AARQuotes;
    /**
     * The IsRoundTrip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRoundTrip;
    /**
     * The PricingEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PricingEvent;
    /**
     * Constructor method for RetrieveAARQuote
     * @uses RetrieveAARQuote::setRetrieveAARQuoteRequest()
     * @uses RetrieveAARQuote::setAARQuotes()
     * @uses RetrieveAARQuote::setIsRoundTrip()
     * @uses RetrieveAARQuote::setPricingEvent()
     * @param \StructType\RetrieveAARQuote $retrieveAARQuoteRequest
     * @param \ArrayType\ArrayOfAARQuote $aARQuotes
     * @param bool $isRoundTrip
     * @param int $pricingEvent
     */
    public function __construct(\StructType\RetrieveAARQuote $retrieveAARQuoteRequest = null, \ArrayType\ArrayOfAARQuote $aARQuotes = null, $isRoundTrip = null, $pricingEvent = null)
    {
        $this
            ->setRetrieveAARQuoteRequest($retrieveAARQuoteRequest)
            ->setAARQuotes($aARQuotes)
            ->setIsRoundTrip($isRoundTrip)
            ->setPricingEvent($pricingEvent);
    }
    /**
     * Get RetrieveAARQuoteRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveAARQuote|null
     */
    public function getRetrieveAARQuoteRequest()
    {
        return isset($this->RetrieveAARQuoteRequest) ? $this->RetrieveAARQuoteRequest : null;
    }
    /**
     * Set RetrieveAARQuoteRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveAARQuote $retrieveAARQuoteRequest
     * @return \StructType\RetrieveAARQuote
     */
    public function setRetrieveAARQuoteRequest(\StructType\RetrieveAARQuote $retrieveAARQuoteRequest = null)
    {
        if (is_null($retrieveAARQuoteRequest) || (is_array($retrieveAARQuoteRequest) && empty($retrieveAARQuoteRequest))) {
            unset($this->RetrieveAARQuoteRequest);
        } else {
            $this->RetrieveAARQuoteRequest = $retrieveAARQuoteRequest;
        }
        return $this;
    }
    /**
     * Get AARQuotes value
     * @return \ArrayType\ArrayOfAARQuote|null
     */
    public function getAARQuotes()
    {
        return $this->AARQuotes;
    }
    /**
     * Set AARQuotes value
     * @param \ArrayType\ArrayOfAARQuote $aARQuotes
     * @return \StructType\RetrieveAARQuote
     */
    public function setAARQuotes(\ArrayType\ArrayOfAARQuote $aARQuotes = null)
    {
        $this->AARQuotes = $aARQuotes;
        return $this;
    }
    /**
     * Get IsRoundTrip value
     * @return bool|null
     */
    public function getIsRoundTrip()
    {
        return $this->IsRoundTrip;
    }
    /**
     * Set IsRoundTrip value
     * @param bool $isRoundTrip
     * @return \StructType\RetrieveAARQuote
     */
    public function setIsRoundTrip($isRoundTrip = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRoundTrip) && !is_bool($isRoundTrip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRoundTrip, true), gettype($isRoundTrip)), __LINE__);
        }
        $this->IsRoundTrip = $isRoundTrip;
        return $this;
    }
    /**
     * Get PricingEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPricingEvent()
    {
        return isset($this->PricingEvent) ? $this->PricingEvent : null;
    }
    /**
     * Set PricingEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pricingEvent
     * @return \StructType\RetrieveAARQuote
     */
    public function setPricingEvent($pricingEvent = null)
    {
        // validation for constraint: int
        if (!is_null($pricingEvent) && !(is_int($pricingEvent) || ctype_digit($pricingEvent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricingEvent, true), gettype($pricingEvent)), __LINE__);
        }
        if (is_null($pricingEvent) || (is_array($pricingEvent) && empty($pricingEvent))) {
            unset($this->PricingEvent);
        } else {
            $this->PricingEvent = $pricingEvent;
        }
        return $this;
    }
}
