<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightLegDetailed StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FlightLegDetailed
 * @subpackage Structs
 */
class FlightLegDetailed extends AbstractStructBase
{
    /**
     * The LegIdentifier
     * @var int
     */
    public $LegIdentifier;
    /**
     * The OriginLocation
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OriginLocation;
    /**
     * The ArrivalLocation
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ArrivalLocation;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The ArrivalDate
     * @var string
     */
    public $ArrivalDate;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The FlightDuration
     * @var float
     */
    public $FlightDuration;
    /**
     * The AirCraftType
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AirCraftType;
    /**
     * The AirCraftDescription
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AirCraftDescription;
    /**
     * The SellingCarrier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SellingCarrier;
    /**
     * The OperatingCarrier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OperatingCarrier;
    /**
     * Constructor method for FlightLegDetailed
     * @uses FlightLegDetailed::setLegIdentifier()
     * @uses FlightLegDetailed::setOriginLocation()
     * @uses FlightLegDetailed::setArrivalLocation()
     * @uses FlightLegDetailed::setDepartureDate()
     * @uses FlightLegDetailed::setArrivalDate()
     * @uses FlightLegDetailed::setFlightNumber()
     * @uses FlightLegDetailed::setFlightDuration()
     * @uses FlightLegDetailed::setAirCraftType()
     * @uses FlightLegDetailed::setAirCraftDescription()
     * @uses FlightLegDetailed::setSellingCarrier()
     * @uses FlightLegDetailed::setOperatingCarrier()
     * @param int $legIdentifier
     * @param string $originLocation
     * @param string $arrivalLocation
     * @param string $departureDate
     * @param string $arrivalDate
     * @param string $flightNumber
     * @param float $flightDuration
     * @param string $airCraftType
     * @param string $airCraftDescription
     * @param string $sellingCarrier
     * @param string $operatingCarrier
     */
    public function __construct($legIdentifier = null, $originLocation = null, $arrivalLocation = null, $departureDate = null, $arrivalDate = null, $flightNumber = null, $flightDuration = null, $airCraftType = null, $airCraftDescription = null, $sellingCarrier = null, $operatingCarrier = null)
    {
        $this
            ->setLegIdentifier($legIdentifier)
            ->setOriginLocation($originLocation)
            ->setArrivalLocation($arrivalLocation)
            ->setDepartureDate($departureDate)
            ->setArrivalDate($arrivalDate)
            ->setFlightNumber($flightNumber)
            ->setFlightDuration($flightDuration)
            ->setAirCraftType($airCraftType)
            ->setAirCraftDescription($airCraftDescription)
            ->setSellingCarrier($sellingCarrier)
            ->setOperatingCarrier($operatingCarrier);
    }
    /**
     * Get LegIdentifier value
     * @return int|null
     */
    public function getLegIdentifier()
    {
        return $this->LegIdentifier;
    }
    /**
     * Set LegIdentifier value
     * @param int $legIdentifier
     * @return \StructType\FlightLegDetailed
     */
    public function setLegIdentifier($legIdentifier = null)
    {
        // validation for constraint: int
        if (!is_null($legIdentifier) && !(is_int($legIdentifier) || ctype_digit($legIdentifier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($legIdentifier, true), gettype($legIdentifier)), __LINE__);
        }
        $this->LegIdentifier = $legIdentifier;
        return $this;
    }
    /**
     * Get OriginLocation value
     * @return string|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param string $originLocation
     * @return \StructType\FlightLegDetailed
     */
    public function setOriginLocation($originLocation = null)
    {
        // validation for constraint: string
        if (!is_null($originLocation) && !is_string($originLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originLocation, true), gettype($originLocation)), __LINE__);
        }
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get ArrivalLocation value
     * @return string|null
     */
    public function getArrivalLocation()
    {
        return $this->ArrivalLocation;
    }
    /**
     * Set ArrivalLocation value
     * @param string $arrivalLocation
     * @return \StructType\FlightLegDetailed
     */
    public function setArrivalLocation($arrivalLocation = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalLocation) && !is_string($arrivalLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalLocation, true), gettype($arrivalLocation)), __LINE__);
        }
        $this->ArrivalLocation = $arrivalLocation;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\FlightLegDetailed
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\FlightLegDetailed
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDate, true), gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \StructType\FlightLegDetailed
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get FlightDuration value
     * @return float|null
     */
    public function getFlightDuration()
    {
        return $this->FlightDuration;
    }
    /**
     * Set FlightDuration value
     * @param float $flightDuration
     * @return \StructType\FlightLegDetailed
     */
    public function setFlightDuration($flightDuration = null)
    {
        // validation for constraint: float
        if (!is_null($flightDuration) && !(is_float($flightDuration) || is_numeric($flightDuration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($flightDuration, true), gettype($flightDuration)), __LINE__);
        }
        $this->FlightDuration = $flightDuration;
        return $this;
    }
    /**
     * Get AirCraftType value
     * @return string|null
     */
    public function getAirCraftType()
    {
        return $this->AirCraftType;
    }
    /**
     * Set AirCraftType value
     * @param string $airCraftType
     * @return \StructType\FlightLegDetailed
     */
    public function setAirCraftType($airCraftType = null)
    {
        // validation for constraint: string
        if (!is_null($airCraftType) && !is_string($airCraftType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airCraftType, true), gettype($airCraftType)), __LINE__);
        }
        $this->AirCraftType = $airCraftType;
        return $this;
    }
    /**
     * Get AirCraftDescription value
     * @return string|null
     */
    public function getAirCraftDescription()
    {
        return $this->AirCraftDescription;
    }
    /**
     * Set AirCraftDescription value
     * @param string $airCraftDescription
     * @return \StructType\FlightLegDetailed
     */
    public function setAirCraftDescription($airCraftDescription = null)
    {
        // validation for constraint: string
        if (!is_null($airCraftDescription) && !is_string($airCraftDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airCraftDescription, true), gettype($airCraftDescription)), __LINE__);
        }
        $this->AirCraftDescription = $airCraftDescription;
        return $this;
    }
    /**
     * Get SellingCarrier value
     * @return string|null
     */
    public function getSellingCarrier()
    {
        return $this->SellingCarrier;
    }
    /**
     * Set SellingCarrier value
     * @param string $sellingCarrier
     * @return \StructType\FlightLegDetailed
     */
    public function setSellingCarrier($sellingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($sellingCarrier) && !is_string($sellingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellingCarrier, true), gettype($sellingCarrier)), __LINE__);
        }
        $this->SellingCarrier = $sellingCarrier;
        return $this;
    }
    /**
     * Get OperatingCarrier value
     * @return string|null
     */
    public function getOperatingCarrier()
    {
        return $this->OperatingCarrier;
    }
    /**
     * Set OperatingCarrier value
     * @param string $operatingCarrier
     * @return \StructType\FlightLegDetailed
     */
    public function setOperatingCarrier($operatingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCarrier) && !is_string($operatingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingCarrier, true), gettype($operatingCarrier)), __LINE__);
        }
        $this->OperatingCarrier = $operatingCarrier;
        return $this;
    }
}
