<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FastFareSearchInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FastFareSearchInfo
 * @subpackage Structs
 */
class FastFareSearchInfo extends AbstractStructBase
{
    /**
     * The CurrencyOfFastFareSearch
     * @var string
     */
    public $CurrencyOfFastFareSearch;
    /**
     * The PromotionalCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PromotionalCode;
    /**
     * The IataNumberOfRequestor
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IataNumberOfRequestor;
    /**
     * The CabinToSearch
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CabinToSearch;
    /**
     * The InventoryTypeToSearch
     * @var string
     */
    public $InventoryTypeToSearch;
    /**
     * The FareFilterGrouping
     * @var string
     */
    public $FareFilterGrouping;
    /**
     * The FareFilterTypeToSearch
     * @var string
     */
    public $FareFilterTypeToSearch;
    /**
     * The DateSearchType
     * @var string
     */
    public $DateSearchType;
    /**
     * The FareSelectionType
     * @var string
     */
    public $FareSelectionType;
    /**
     * The FastFareSearchTripDetails
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfFastFareSearchTripDetail
     */
    public $FastFareSearchTripDetails;
    /**
     * Constructor method for FastFareSearchInfo
     * @uses FastFareSearchInfo::setCurrencyOfFastFareSearch()
     * @uses FastFareSearchInfo::setPromotionalCode()
     * @uses FastFareSearchInfo::setIataNumberOfRequestor()
     * @uses FastFareSearchInfo::setCabinToSearch()
     * @uses FastFareSearchInfo::setInventoryTypeToSearch()
     * @uses FastFareSearchInfo::setFareFilterGrouping()
     * @uses FastFareSearchInfo::setFareFilterTypeToSearch()
     * @uses FastFareSearchInfo::setDateSearchType()
     * @uses FastFareSearchInfo::setFareSelectionType()
     * @uses FastFareSearchInfo::setFastFareSearchTripDetails()
     * @param string $currencyOfFastFareSearch
     * @param string $promotionalCode
     * @param string $iataNumberOfRequestor
     * @param string $cabinToSearch
     * @param string $inventoryTypeToSearch
     * @param string $fareFilterGrouping
     * @param string $fareFilterTypeToSearch
     * @param string $dateSearchType
     * @param string $fareSelectionType
     * @param \ArrayType\ArrayOfFastFareSearchTripDetail $fastFareSearchTripDetails
     */
    public function __construct($currencyOfFastFareSearch = null, $promotionalCode = null, $iataNumberOfRequestor = null, $cabinToSearch = null, $inventoryTypeToSearch = null, $fareFilterGrouping = null, $fareFilterTypeToSearch = null, $dateSearchType = null, $fareSelectionType = null, \ArrayType\ArrayOfFastFareSearchTripDetail $fastFareSearchTripDetails = null)
    {
        $this
            ->setCurrencyOfFastFareSearch($currencyOfFastFareSearch)
            ->setPromotionalCode($promotionalCode)
            ->setIataNumberOfRequestor($iataNumberOfRequestor)
            ->setCabinToSearch($cabinToSearch)
            ->setInventoryTypeToSearch($inventoryTypeToSearch)
            ->setFareFilterGrouping($fareFilterGrouping)
            ->setFareFilterTypeToSearch($fareFilterTypeToSearch)
            ->setDateSearchType($dateSearchType)
            ->setFareSelectionType($fareSelectionType)
            ->setFastFareSearchTripDetails($fastFareSearchTripDetails);
    }
    /**
     * Get CurrencyOfFastFareSearch value
     * @return string|null
     */
    public function getCurrencyOfFastFareSearch()
    {
        return $this->CurrencyOfFastFareSearch;
    }
    /**
     * Set CurrencyOfFastFareSearch value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currencyOfFastFareSearch
     * @return \StructType\FastFareSearchInfo
     */
    public function setCurrencyOfFastFareSearch($currencyOfFastFareSearch = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($currencyOfFastFareSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($currencyOfFastFareSearch) ? implode(', ', $currencyOfFastFareSearch) : var_export($currencyOfFastFareSearch, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->CurrencyOfFastFareSearch = $currencyOfFastFareSearch;
        return $this;
    }
    /**
     * Get PromotionalCode value
     * @return string|null
     */
    public function getPromotionalCode()
    {
        return $this->PromotionalCode;
    }
    /**
     * Set PromotionalCode value
     * @param string $promotionalCode
     * @return \StructType\FastFareSearchInfo
     */
    public function setPromotionalCode($promotionalCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionalCode) && !is_string($promotionalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionalCode, true), gettype($promotionalCode)), __LINE__);
        }
        $this->PromotionalCode = $promotionalCode;
        return $this;
    }
    /**
     * Get IataNumberOfRequestor value
     * @return string|null
     */
    public function getIataNumberOfRequestor()
    {
        return $this->IataNumberOfRequestor;
    }
    /**
     * Set IataNumberOfRequestor value
     * @param string $iataNumberOfRequestor
     * @return \StructType\FastFareSearchInfo
     */
    public function setIataNumberOfRequestor($iataNumberOfRequestor = null)
    {
        // validation for constraint: string
        if (!is_null($iataNumberOfRequestor) && !is_string($iataNumberOfRequestor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iataNumberOfRequestor, true), gettype($iataNumberOfRequestor)), __LINE__);
        }
        $this->IataNumberOfRequestor = $iataNumberOfRequestor;
        return $this;
    }
    /**
     * Get CabinToSearch value
     * @return string|null
     */
    public function getCabinToSearch()
    {
        return $this->CabinToSearch;
    }
    /**
     * Set CabinToSearch value
     * @param string $cabinToSearch
     * @return \StructType\FastFareSearchInfo
     */
    public function setCabinToSearch($cabinToSearch = null)
    {
        // validation for constraint: string
        if (!is_null($cabinToSearch) && !is_string($cabinToSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinToSearch, true), gettype($cabinToSearch)), __LINE__);
        }
        $this->CabinToSearch = $cabinToSearch;
        return $this;
    }
    /**
     * Get InventoryTypeToSearch value
     * @return string|null
     */
    public function getInventoryTypeToSearch()
    {
        return $this->InventoryTypeToSearch;
    }
    /**
     * Set InventoryTypeToSearch value
     * @uses \EnumType\Enums_InventoryFilterMethodType::valueIsValid()
     * @uses \EnumType\Enums_InventoryFilterMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $inventoryTypeToSearch
     * @return \StructType\FastFareSearchInfo
     */
    public function setInventoryTypeToSearch($inventoryTypeToSearch = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enums_InventoryFilterMethodType::valueIsValid($inventoryTypeToSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enums_InventoryFilterMethodType', is_array($inventoryTypeToSearch) ? implode(', ', $inventoryTypeToSearch) : var_export($inventoryTypeToSearch, true), implode(', ', \EnumType\Enums_InventoryFilterMethodType::getValidValues())), __LINE__);
        }
        $this->InventoryTypeToSearch = $inventoryTypeToSearch;
        return $this;
    }
    /**
     * Get FareFilterGrouping value
     * @return string|null
     */
    public function getFareFilterGrouping()
    {
        return $this->FareFilterGrouping;
    }
    /**
     * Set FareFilterGrouping value
     * @uses \EnumType\Enums_FareFilterGroupingsMethodType::valueIsValid()
     * @uses \EnumType\Enums_FareFilterGroupingsMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fareFilterGrouping
     * @return \StructType\FastFareSearchInfo
     */
    public function setFareFilterGrouping($fareFilterGrouping = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enums_FareFilterGroupingsMethodType::valueIsValid($fareFilterGrouping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enums_FareFilterGroupingsMethodType', is_array($fareFilterGrouping) ? implode(', ', $fareFilterGrouping) : var_export($fareFilterGrouping, true), implode(', ', \EnumType\Enums_FareFilterGroupingsMethodType::getValidValues())), __LINE__);
        }
        $this->FareFilterGrouping = $fareFilterGrouping;
        return $this;
    }
    /**
     * Get FareFilterTypeToSearch value
     * @return string|null
     */
    public function getFareFilterTypeToSearch()
    {
        return $this->FareFilterTypeToSearch;
    }
    /**
     * Set FareFilterTypeToSearch value
     * @uses \EnumType\Enums_FareGroupMethodType::valueIsValid()
     * @uses \EnumType\Enums_FareGroupMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fareFilterTypeToSearch
     * @return \StructType\FastFareSearchInfo
     */
    public function setFareFilterTypeToSearch($fareFilterTypeToSearch = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enums_FareGroupMethodType::valueIsValid($fareFilterTypeToSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enums_FareGroupMethodType', is_array($fareFilterTypeToSearch) ? implode(', ', $fareFilterTypeToSearch) : var_export($fareFilterTypeToSearch, true), implode(', ', \EnumType\Enums_FareGroupMethodType::getValidValues())), __LINE__);
        }
        $this->FareFilterTypeToSearch = $fareFilterTypeToSearch;
        return $this;
    }
    /**
     * Get DateSearchType value
     * @return string|null
     */
    public function getDateSearchType()
    {
        return $this->DateSearchType;
    }
    /**
     * Set DateSearchType value
     * @uses \EnumType\Enums_DateSearchType::valueIsValid()
     * @uses \EnumType\Enums_DateSearchType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dateSearchType
     * @return \StructType\FastFareSearchInfo
     */
    public function setDateSearchType($dateSearchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enums_DateSearchType::valueIsValid($dateSearchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enums_DateSearchType', is_array($dateSearchType) ? implode(', ', $dateSearchType) : var_export($dateSearchType, true), implode(', ', \EnumType\Enums_DateSearchType::getValidValues())), __LINE__);
        }
        $this->DateSearchType = $dateSearchType;
        return $this;
    }
    /**
     * Get FareSelectionType value
     * @return string|null
     */
    public function getFareSelectionType()
    {
        return $this->FareSelectionType;
    }
    /**
     * Set FareSelectionType value
     * @uses \EnumType\Enums_FareSelectionType::valueIsValid()
     * @uses \EnumType\Enums_FareSelectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fareSelectionType
     * @return \StructType\FastFareSearchInfo
     */
    public function setFareSelectionType($fareSelectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enums_FareSelectionType::valueIsValid($fareSelectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enums_FareSelectionType', is_array($fareSelectionType) ? implode(', ', $fareSelectionType) : var_export($fareSelectionType, true), implode(', ', \EnumType\Enums_FareSelectionType::getValidValues())), __LINE__);
        }
        $this->FareSelectionType = $fareSelectionType;
        return $this;
    }
    /**
     * Get FastFareSearchTripDetails value
     * @return \ArrayType\ArrayOfFastFareSearchTripDetail|null
     */
    public function getFastFareSearchTripDetails()
    {
        return $this->FastFareSearchTripDetails;
    }
    /**
     * Set FastFareSearchTripDetails value
     * @param \ArrayType\ArrayOfFastFareSearchTripDetail $fastFareSearchTripDetails
     * @return \StructType\FastFareSearchInfo
     */
    public function setFastFareSearchTripDetails(\ArrayType\ArrayOfFastFareSearchTripDetail $fastFareSearchTripDetails = null)
    {
        $this->FastFareSearchTripDetails = $fastFareSearchTripDetails;
        return $this;
    }
}
