<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CombinableTrip StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CombinableTrip
 * @subpackage Structs
 */
class CombinableTrip extends AbstractStructBase
{
    /**
     * The CombinableFlights
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCombinableFlight
     */
    public $CombinableFlights;
    /**
     * The TripId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TripId;
    /**
     * Constructor method for CombinableTrip
     * @uses CombinableTrip::setCombinableFlights()
     * @uses CombinableTrip::setTripId()
     * @param \ArrayType\ArrayOfCombinableFlight $combinableFlights
     * @param int $tripId
     */
    public function __construct(\ArrayType\ArrayOfCombinableFlight $combinableFlights = null, $tripId = null)
    {
        $this
            ->setCombinableFlights($combinableFlights)
            ->setTripId($tripId);
    }
    /**
     * Get CombinableFlights value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCombinableFlight|null
     */
    public function getCombinableFlights()
    {
        return isset($this->CombinableFlights) ? $this->CombinableFlights : null;
    }
    /**
     * Set CombinableFlights value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCombinableFlight $combinableFlights
     * @return \StructType\CombinableTrip
     */
    public function setCombinableFlights(\ArrayType\ArrayOfCombinableFlight $combinableFlights = null)
    {
        if (is_null($combinableFlights) || (is_array($combinableFlights) && empty($combinableFlights))) {
            unset($this->CombinableFlights);
        } else {
            $this->CombinableFlights = $combinableFlights;
        }
        return $this;
    }
    /**
     * Get TripId value
     * @return int|null
     */
    public function getTripId()
    {
        return $this->TripId;
    }
    /**
     * Set TripId value
     * @param int $tripId
     * @return \StructType\CombinableTrip
     */
    public function setTripId($tripId = null)
    {
        // validation for constraint: int
        if (!is_null($tripId) && !(is_int($tripId) || ctype_digit($tripId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tripId, true), gettype($tripId)), __LINE__);
        }
        $this->TripId = $tripId;
        return $this;
    }
}
