<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseFareInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BaseFareInfo
 * @subpackage Structs
 */
class BaseFareInfo extends AbstractStructBase
{
    /**
     * The FareID
     * @var int
     */
    public $FareID;
    /**
     * The FCCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FCCode;
    /**
     * The FBCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FBCode;
    /**
     * The BaseFareAmtNoTaxes
     * @var float
     */
    public $BaseFareAmtNoTaxes;
    /**
     * The BaseFareAmt
     * @var float
     */
    public $BaseFareAmt;
    /**
     * The FareAmtNoTaxes
     * @var float
     */
    public $FareAmtNoTaxes;
    /**
     * The FareAmt
     * @var float
     */
    public $FareAmt;
    /**
     * The BaseFareAmtInclTax
     * @var float
     */
    public $BaseFareAmtInclTax;
    /**
     * The FareAmtInclTax
     * @var float
     */
    public $FareAmtInclTax;
    /**
     * The PvtFare
     * @var bool
     */
    public $PvtFare;
    /**
     * The PTCID
     * @var int
     */
    public $PTCID;
    /**
     * The Cabin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Cabin;
    /**
     * The SeatsAvailable
     * @var int
     */
    public $SeatsAvailable;
    /**
     * The InfantSeatsAvailable
     * @var int
     */
    public $InfantSeatsAvailable;
    /**
     * The FareScheduleID
     * @var int
     */
    public $FareScheduleID;
    /**
     * The PromotionID
     * @var int
     */
    public $PromotionID;
    /**
     * The RoundTrip
     * @var int
     */
    public $RoundTrip;
    /**
     * The DisplayFareAmt
     * @var float
     */
    public $DisplayFareAmt;
    /**
     * The DisplayTaxSum
     * @var float
     */
    public $DisplayTaxSum;
    /**
     * The SpecialMarketed
     * @var bool
     */
    public $SpecialMarketed;
    /**
     * The WaitList
     * @var bool
     */
    public $WaitList;
    /**
     * The SpaceAvailable
     * @var bool
     */
    public $SpaceAvailable;
    /**
     * The PositiveSpace
     * @var bool
     */
    public $PositiveSpace;
    /**
     * The PromotionCatID
     * @var int
     */
    public $PromotionCatID;
    /**
     * The CommissionAmount
     * @var float
     */
    public $CommissionAmount;
    /**
     * The PromotionAmount
     * @var float
     */
    public $PromotionAmount;
    /**
     * The ApplicableTaxDetails
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfApplicableTaxDetail
     */
    public $ApplicableTaxDetails;
    /**
     * The BundleCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BundleCode;
    /**
     * The OriginalCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalCurrency;
    /**
     * The ExchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ExchangeRate;
    /**
     * The ExchangeDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExchangeDate;
    /**
     * The CombinableTrips
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCombinableTrip
     */
    public $CombinableTrips;
    /**
     * Constructor method for BaseFareInfo
     * @uses BaseFareInfo::setFareID()
     * @uses BaseFareInfo::setFCCode()
     * @uses BaseFareInfo::setFBCode()
     * @uses BaseFareInfo::setBaseFareAmtNoTaxes()
     * @uses BaseFareInfo::setBaseFareAmt()
     * @uses BaseFareInfo::setFareAmtNoTaxes()
     * @uses BaseFareInfo::setFareAmt()
     * @uses BaseFareInfo::setBaseFareAmtInclTax()
     * @uses BaseFareInfo::setFareAmtInclTax()
     * @uses BaseFareInfo::setPvtFare()
     * @uses BaseFareInfo::setPTCID()
     * @uses BaseFareInfo::setCabin()
     * @uses BaseFareInfo::setSeatsAvailable()
     * @uses BaseFareInfo::setInfantSeatsAvailable()
     * @uses BaseFareInfo::setFareScheduleID()
     * @uses BaseFareInfo::setPromotionID()
     * @uses BaseFareInfo::setRoundTrip()
     * @uses BaseFareInfo::setDisplayFareAmt()
     * @uses BaseFareInfo::setDisplayTaxSum()
     * @uses BaseFareInfo::setSpecialMarketed()
     * @uses BaseFareInfo::setWaitList()
     * @uses BaseFareInfo::setSpaceAvailable()
     * @uses BaseFareInfo::setPositiveSpace()
     * @uses BaseFareInfo::setPromotionCatID()
     * @uses BaseFareInfo::setCommissionAmount()
     * @uses BaseFareInfo::setPromotionAmount()
     * @uses BaseFareInfo::setApplicableTaxDetails()
     * @uses BaseFareInfo::setBundleCode()
     * @uses BaseFareInfo::setOriginalCurrency()
     * @uses BaseFareInfo::setExchangeRate()
     * @uses BaseFareInfo::setExchangeDate()
     * @uses BaseFareInfo::setCombinableTrips()
     * @param int $fareID
     * @param string $fCCode
     * @param string $fBCode
     * @param float $baseFareAmtNoTaxes
     * @param float $baseFareAmt
     * @param float $fareAmtNoTaxes
     * @param float $fareAmt
     * @param float $baseFareAmtInclTax
     * @param float $fareAmtInclTax
     * @param bool $pvtFare
     * @param int $pTCID
     * @param string $cabin
     * @param int $seatsAvailable
     * @param int $infantSeatsAvailable
     * @param int $fareScheduleID
     * @param int $promotionID
     * @param int $roundTrip
     * @param float $displayFareAmt
     * @param float $displayTaxSum
     * @param bool $specialMarketed
     * @param bool $waitList
     * @param bool $spaceAvailable
     * @param bool $positiveSpace
     * @param int $promotionCatID
     * @param float $commissionAmount
     * @param float $promotionAmount
     * @param \ArrayType\ArrayOfApplicableTaxDetail $applicableTaxDetails
     * @param string $bundleCode
     * @param string $originalCurrency
     * @param float $exchangeRate
     * @param string $exchangeDate
     * @param \ArrayType\ArrayOfCombinableTrip $combinableTrips
     */
    public function __construct($fareID = null, $fCCode = null, $fBCode = null, $baseFareAmtNoTaxes = null, $baseFareAmt = null, $fareAmtNoTaxes = null, $fareAmt = null, $baseFareAmtInclTax = null, $fareAmtInclTax = null, $pvtFare = null, $pTCID = null, $cabin = null, $seatsAvailable = null, $infantSeatsAvailable = null, $fareScheduleID = null, $promotionID = null, $roundTrip = null, $displayFareAmt = null, $displayTaxSum = null, $specialMarketed = null, $waitList = null, $spaceAvailable = null, $positiveSpace = null, $promotionCatID = null, $commissionAmount = null, $promotionAmount = null, \ArrayType\ArrayOfApplicableTaxDetail $applicableTaxDetails = null, $bundleCode = null, $originalCurrency = null, $exchangeRate = null, $exchangeDate = null, \ArrayType\ArrayOfCombinableTrip $combinableTrips = null)
    {
        $this
            ->setFareID($fareID)
            ->setFCCode($fCCode)
            ->setFBCode($fBCode)
            ->setBaseFareAmtNoTaxes($baseFareAmtNoTaxes)
            ->setBaseFareAmt($baseFareAmt)
            ->setFareAmtNoTaxes($fareAmtNoTaxes)
            ->setFareAmt($fareAmt)
            ->setBaseFareAmtInclTax($baseFareAmtInclTax)
            ->setFareAmtInclTax($fareAmtInclTax)
            ->setPvtFare($pvtFare)
            ->setPTCID($pTCID)
            ->setCabin($cabin)
            ->setSeatsAvailable($seatsAvailable)
            ->setInfantSeatsAvailable($infantSeatsAvailable)
            ->setFareScheduleID($fareScheduleID)
            ->setPromotionID($promotionID)
            ->setRoundTrip($roundTrip)
            ->setDisplayFareAmt($displayFareAmt)
            ->setDisplayTaxSum($displayTaxSum)
            ->setSpecialMarketed($specialMarketed)
            ->setWaitList($waitList)
            ->setSpaceAvailable($spaceAvailable)
            ->setPositiveSpace($positiveSpace)
            ->setPromotionCatID($promotionCatID)
            ->setCommissionAmount($commissionAmount)
            ->setPromotionAmount($promotionAmount)
            ->setApplicableTaxDetails($applicableTaxDetails)
            ->setBundleCode($bundleCode)
            ->setOriginalCurrency($originalCurrency)
            ->setExchangeRate($exchangeRate)
            ->setExchangeDate($exchangeDate)
            ->setCombinableTrips($combinableTrips);
    }
    /**
     * Get FareID value
     * @return int|null
     */
    public function getFareID()
    {
        return $this->FareID;
    }
    /**
     * Set FareID value
     * @param int $fareID
     * @return \StructType\BaseFareInfo
     */
    public function setFareID($fareID = null)
    {
        // validation for constraint: int
        if (!is_null($fareID) && !(is_int($fareID) || ctype_digit($fareID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fareID, true), gettype($fareID)), __LINE__);
        }
        $this->FareID = $fareID;
        return $this;
    }
    /**
     * Get FCCode value
     * @return string|null
     */
    public function getFCCode()
    {
        return $this->FCCode;
    }
    /**
     * Set FCCode value
     * @param string $fCCode
     * @return \StructType\BaseFareInfo
     */
    public function setFCCode($fCCode = null)
    {
        // validation for constraint: string
        if (!is_null($fCCode) && !is_string($fCCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fCCode, true), gettype($fCCode)), __LINE__);
        }
        $this->FCCode = $fCCode;
        return $this;
    }
    /**
     * Get FBCode value
     * @return string|null
     */
    public function getFBCode()
    {
        return $this->FBCode;
    }
    /**
     * Set FBCode value
     * @param string $fBCode
     * @return \StructType\BaseFareInfo
     */
    public function setFBCode($fBCode = null)
    {
        // validation for constraint: string
        if (!is_null($fBCode) && !is_string($fBCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fBCode, true), gettype($fBCode)), __LINE__);
        }
        $this->FBCode = $fBCode;
        return $this;
    }
    /**
     * Get BaseFareAmtNoTaxes value
     * @return float|null
     */
    public function getBaseFareAmtNoTaxes()
    {
        return $this->BaseFareAmtNoTaxes;
    }
    /**
     * Set BaseFareAmtNoTaxes value
     * @param float $baseFareAmtNoTaxes
     * @return \StructType\BaseFareInfo
     */
    public function setBaseFareAmtNoTaxes($baseFareAmtNoTaxes = null)
    {
        // validation for constraint: float
        if (!is_null($baseFareAmtNoTaxes) && !(is_float($baseFareAmtNoTaxes) || is_numeric($baseFareAmtNoTaxes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseFareAmtNoTaxes, true), gettype($baseFareAmtNoTaxes)), __LINE__);
        }
        $this->BaseFareAmtNoTaxes = $baseFareAmtNoTaxes;
        return $this;
    }
    /**
     * Get BaseFareAmt value
     * @return float|null
     */
    public function getBaseFareAmt()
    {
        return $this->BaseFareAmt;
    }
    /**
     * Set BaseFareAmt value
     * @param float $baseFareAmt
     * @return \StructType\BaseFareInfo
     */
    public function setBaseFareAmt($baseFareAmt = null)
    {
        // validation for constraint: float
        if (!is_null($baseFareAmt) && !(is_float($baseFareAmt) || is_numeric($baseFareAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseFareAmt, true), gettype($baseFareAmt)), __LINE__);
        }
        $this->BaseFareAmt = $baseFareAmt;
        return $this;
    }
    /**
     * Get FareAmtNoTaxes value
     * @return float|null
     */
    public function getFareAmtNoTaxes()
    {
        return $this->FareAmtNoTaxes;
    }
    /**
     * Set FareAmtNoTaxes value
     * @param float $fareAmtNoTaxes
     * @return \StructType\BaseFareInfo
     */
    public function setFareAmtNoTaxes($fareAmtNoTaxes = null)
    {
        // validation for constraint: float
        if (!is_null($fareAmtNoTaxes) && !(is_float($fareAmtNoTaxes) || is_numeric($fareAmtNoTaxes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fareAmtNoTaxes, true), gettype($fareAmtNoTaxes)), __LINE__);
        }
        $this->FareAmtNoTaxes = $fareAmtNoTaxes;
        return $this;
    }
    /**
     * Get FareAmt value
     * @return float|null
     */
    public function getFareAmt()
    {
        return $this->FareAmt;
    }
    /**
     * Set FareAmt value
     * @param float $fareAmt
     * @return \StructType\BaseFareInfo
     */
    public function setFareAmt($fareAmt = null)
    {
        // validation for constraint: float
        if (!is_null($fareAmt) && !(is_float($fareAmt) || is_numeric($fareAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fareAmt, true), gettype($fareAmt)), __LINE__);
        }
        $this->FareAmt = $fareAmt;
        return $this;
    }
    /**
     * Get BaseFareAmtInclTax value
     * @return float|null
     */
    public function getBaseFareAmtInclTax()
    {
        return $this->BaseFareAmtInclTax;
    }
    /**
     * Set BaseFareAmtInclTax value
     * @param float $baseFareAmtInclTax
     * @return \StructType\BaseFareInfo
     */
    public function setBaseFareAmtInclTax($baseFareAmtInclTax = null)
    {
        // validation for constraint: float
        if (!is_null($baseFareAmtInclTax) && !(is_float($baseFareAmtInclTax) || is_numeric($baseFareAmtInclTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseFareAmtInclTax, true), gettype($baseFareAmtInclTax)), __LINE__);
        }
        $this->BaseFareAmtInclTax = $baseFareAmtInclTax;
        return $this;
    }
    /**
     * Get FareAmtInclTax value
     * @return float|null
     */
    public function getFareAmtInclTax()
    {
        return $this->FareAmtInclTax;
    }
    /**
     * Set FareAmtInclTax value
     * @param float $fareAmtInclTax
     * @return \StructType\BaseFareInfo
     */
    public function setFareAmtInclTax($fareAmtInclTax = null)
    {
        // validation for constraint: float
        if (!is_null($fareAmtInclTax) && !(is_float($fareAmtInclTax) || is_numeric($fareAmtInclTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fareAmtInclTax, true), gettype($fareAmtInclTax)), __LINE__);
        }
        $this->FareAmtInclTax = $fareAmtInclTax;
        return $this;
    }
    /**
     * Get PvtFare value
     * @return bool|null
     */
    public function getPvtFare()
    {
        return $this->PvtFare;
    }
    /**
     * Set PvtFare value
     * @param bool $pvtFare
     * @return \StructType\BaseFareInfo
     */
    public function setPvtFare($pvtFare = null)
    {
        // validation for constraint: boolean
        if (!is_null($pvtFare) && !is_bool($pvtFare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pvtFare, true), gettype($pvtFare)), __LINE__);
        }
        $this->PvtFare = $pvtFare;
        return $this;
    }
    /**
     * Get PTCID value
     * @return int|null
     */
    public function getPTCID()
    {
        return $this->PTCID;
    }
    /**
     * Set PTCID value
     * @param int $pTCID
     * @return \StructType\BaseFareInfo
     */
    public function setPTCID($pTCID = null)
    {
        // validation for constraint: int
        if (!is_null($pTCID) && !(is_int($pTCID) || ctype_digit($pTCID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pTCID, true), gettype($pTCID)), __LINE__);
        }
        $this->PTCID = $pTCID;
        return $this;
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param string $cabin
     * @return \StructType\BaseFareInfo
     */
    public function setCabin($cabin = null)
    {
        // validation for constraint: string
        if (!is_null($cabin) && !is_string($cabin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabin, true), gettype($cabin)), __LINE__);
        }
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get SeatsAvailable value
     * @return int|null
     */
    public function getSeatsAvailable()
    {
        return $this->SeatsAvailable;
    }
    /**
     * Set SeatsAvailable value
     * @param int $seatsAvailable
     * @return \StructType\BaseFareInfo
     */
    public function setSeatsAvailable($seatsAvailable = null)
    {
        // validation for constraint: int
        if (!is_null($seatsAvailable) && !(is_int($seatsAvailable) || ctype_digit($seatsAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatsAvailable, true), gettype($seatsAvailable)), __LINE__);
        }
        $this->SeatsAvailable = $seatsAvailable;
        return $this;
    }
    /**
     * Get InfantSeatsAvailable value
     * @return int|null
     */
    public function getInfantSeatsAvailable()
    {
        return $this->InfantSeatsAvailable;
    }
    /**
     * Set InfantSeatsAvailable value
     * @param int $infantSeatsAvailable
     * @return \StructType\BaseFareInfo
     */
    public function setInfantSeatsAvailable($infantSeatsAvailable = null)
    {
        // validation for constraint: int
        if (!is_null($infantSeatsAvailable) && !(is_int($infantSeatsAvailable) || ctype_digit($infantSeatsAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($infantSeatsAvailable, true), gettype($infantSeatsAvailable)), __LINE__);
        }
        $this->InfantSeatsAvailable = $infantSeatsAvailable;
        return $this;
    }
    /**
     * Get FareScheduleID value
     * @return int|null
     */
    public function getFareScheduleID()
    {
        return $this->FareScheduleID;
    }
    /**
     * Set FareScheduleID value
     * @param int $fareScheduleID
     * @return \StructType\BaseFareInfo
     */
    public function setFareScheduleID($fareScheduleID = null)
    {
        // validation for constraint: int
        if (!is_null($fareScheduleID) && !(is_int($fareScheduleID) || ctype_digit($fareScheduleID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fareScheduleID, true), gettype($fareScheduleID)), __LINE__);
        }
        $this->FareScheduleID = $fareScheduleID;
        return $this;
    }
    /**
     * Get PromotionID value
     * @return int|null
     */
    public function getPromotionID()
    {
        return $this->PromotionID;
    }
    /**
     * Set PromotionID value
     * @param int $promotionID
     * @return \StructType\BaseFareInfo
     */
    public function setPromotionID($promotionID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionID) && !(is_int($promotionID) || ctype_digit($promotionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($promotionID, true), gettype($promotionID)), __LINE__);
        }
        $this->PromotionID = $promotionID;
        return $this;
    }
    /**
     * Get RoundTrip value
     * @return int|null
     */
    public function getRoundTrip()
    {
        return $this->RoundTrip;
    }
    /**
     * Set RoundTrip value
     * @param int $roundTrip
     * @return \StructType\BaseFareInfo
     */
    public function setRoundTrip($roundTrip = null)
    {
        // validation for constraint: int
        if (!is_null($roundTrip) && !(is_int($roundTrip) || ctype_digit($roundTrip))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roundTrip, true), gettype($roundTrip)), __LINE__);
        }
        $this->RoundTrip = $roundTrip;
        return $this;
    }
    /**
     * Get DisplayFareAmt value
     * @return float|null
     */
    public function getDisplayFareAmt()
    {
        return $this->DisplayFareAmt;
    }
    /**
     * Set DisplayFareAmt value
     * @param float $displayFareAmt
     * @return \StructType\BaseFareInfo
     */
    public function setDisplayFareAmt($displayFareAmt = null)
    {
        // validation for constraint: float
        if (!is_null($displayFareAmt) && !(is_float($displayFareAmt) || is_numeric($displayFareAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($displayFareAmt, true), gettype($displayFareAmt)), __LINE__);
        }
        $this->DisplayFareAmt = $displayFareAmt;
        return $this;
    }
    /**
     * Get DisplayTaxSum value
     * @return float|null
     */
    public function getDisplayTaxSum()
    {
        return $this->DisplayTaxSum;
    }
    /**
     * Set DisplayTaxSum value
     * @param float $displayTaxSum
     * @return \StructType\BaseFareInfo
     */
    public function setDisplayTaxSum($displayTaxSum = null)
    {
        // validation for constraint: float
        if (!is_null($displayTaxSum) && !(is_float($displayTaxSum) || is_numeric($displayTaxSum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($displayTaxSum, true), gettype($displayTaxSum)), __LINE__);
        }
        $this->DisplayTaxSum = $displayTaxSum;
        return $this;
    }
    /**
     * Get SpecialMarketed value
     * @return bool|null
     */
    public function getSpecialMarketed()
    {
        return $this->SpecialMarketed;
    }
    /**
     * Set SpecialMarketed value
     * @param bool $specialMarketed
     * @return \StructType\BaseFareInfo
     */
    public function setSpecialMarketed($specialMarketed = null)
    {
        // validation for constraint: boolean
        if (!is_null($specialMarketed) && !is_bool($specialMarketed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($specialMarketed, true), gettype($specialMarketed)), __LINE__);
        }
        $this->SpecialMarketed = $specialMarketed;
        return $this;
    }
    /**
     * Get WaitList value
     * @return bool|null
     */
    public function getWaitList()
    {
        return $this->WaitList;
    }
    /**
     * Set WaitList value
     * @param bool $waitList
     * @return \StructType\BaseFareInfo
     */
    public function setWaitList($waitList = null)
    {
        // validation for constraint: boolean
        if (!is_null($waitList) && !is_bool($waitList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($waitList, true), gettype($waitList)), __LINE__);
        }
        $this->WaitList = $waitList;
        return $this;
    }
    /**
     * Get SpaceAvailable value
     * @return bool|null
     */
    public function getSpaceAvailable()
    {
        return $this->SpaceAvailable;
    }
    /**
     * Set SpaceAvailable value
     * @param bool $spaceAvailable
     * @return \StructType\BaseFareInfo
     */
    public function setSpaceAvailable($spaceAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($spaceAvailable) && !is_bool($spaceAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($spaceAvailable, true), gettype($spaceAvailable)), __LINE__);
        }
        $this->SpaceAvailable = $spaceAvailable;
        return $this;
    }
    /**
     * Get PositiveSpace value
     * @return bool|null
     */
    public function getPositiveSpace()
    {
        return $this->PositiveSpace;
    }
    /**
     * Set PositiveSpace value
     * @param bool $positiveSpace
     * @return \StructType\BaseFareInfo
     */
    public function setPositiveSpace($positiveSpace = null)
    {
        // validation for constraint: boolean
        if (!is_null($positiveSpace) && !is_bool($positiveSpace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($positiveSpace, true), gettype($positiveSpace)), __LINE__);
        }
        $this->PositiveSpace = $positiveSpace;
        return $this;
    }
    /**
     * Get PromotionCatID value
     * @return int|null
     */
    public function getPromotionCatID()
    {
        return $this->PromotionCatID;
    }
    /**
     * Set PromotionCatID value
     * @param int $promotionCatID
     * @return \StructType\BaseFareInfo
     */
    public function setPromotionCatID($promotionCatID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionCatID) && !(is_int($promotionCatID) || ctype_digit($promotionCatID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($promotionCatID, true), gettype($promotionCatID)), __LINE__);
        }
        $this->PromotionCatID = $promotionCatID;
        return $this;
    }
    /**
     * Get CommissionAmount value
     * @return float|null
     */
    public function getCommissionAmount()
    {
        return $this->CommissionAmount;
    }
    /**
     * Set CommissionAmount value
     * @param float $commissionAmount
     * @return \StructType\BaseFareInfo
     */
    public function setCommissionAmount($commissionAmount = null)
    {
        // validation for constraint: float
        if (!is_null($commissionAmount) && !(is_float($commissionAmount) || is_numeric($commissionAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionAmount, true), gettype($commissionAmount)), __LINE__);
        }
        $this->CommissionAmount = $commissionAmount;
        return $this;
    }
    /**
     * Get PromotionAmount value
     * @return float|null
     */
    public function getPromotionAmount()
    {
        return $this->PromotionAmount;
    }
    /**
     * Set PromotionAmount value
     * @param float $promotionAmount
     * @return \StructType\BaseFareInfo
     */
    public function setPromotionAmount($promotionAmount = null)
    {
        // validation for constraint: float
        if (!is_null($promotionAmount) && !(is_float($promotionAmount) || is_numeric($promotionAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($promotionAmount, true), gettype($promotionAmount)), __LINE__);
        }
        $this->PromotionAmount = $promotionAmount;
        return $this;
    }
    /**
     * Get ApplicableTaxDetails value
     * @return \ArrayType\ArrayOfApplicableTaxDetail|null
     */
    public function getApplicableTaxDetails()
    {
        return $this->ApplicableTaxDetails;
    }
    /**
     * Set ApplicableTaxDetails value
     * @param \ArrayType\ArrayOfApplicableTaxDetail $applicableTaxDetails
     * @return \StructType\BaseFareInfo
     */
    public function setApplicableTaxDetails(\ArrayType\ArrayOfApplicableTaxDetail $applicableTaxDetails = null)
    {
        $this->ApplicableTaxDetails = $applicableTaxDetails;
        return $this;
    }
    /**
     * Get BundleCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBundleCode()
    {
        return isset($this->BundleCode) ? $this->BundleCode : null;
    }
    /**
     * Set BundleCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bundleCode
     * @return \StructType\BaseFareInfo
     */
    public function setBundleCode($bundleCode = null)
    {
        // validation for constraint: string
        if (!is_null($bundleCode) && !is_string($bundleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleCode, true), gettype($bundleCode)), __LINE__);
        }
        if (is_null($bundleCode) || (is_array($bundleCode) && empty($bundleCode))) {
            unset($this->BundleCode);
        } else {
            $this->BundleCode = $bundleCode;
        }
        return $this;
    }
    /**
     * Get OriginalCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalCurrency()
    {
        return isset($this->OriginalCurrency) ? $this->OriginalCurrency : null;
    }
    /**
     * Set OriginalCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalCurrency
     * @return \StructType\BaseFareInfo
     */
    public function setOriginalCurrency($originalCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($originalCurrency) && !is_string($originalCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalCurrency, true), gettype($originalCurrency)), __LINE__);
        }
        if (is_null($originalCurrency) || (is_array($originalCurrency) && empty($originalCurrency))) {
            unset($this->OriginalCurrency);
        } else {
            $this->OriginalCurrency = $originalCurrency;
        }
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \StructType\BaseFareInfo
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get ExchangeDate value
     * @return string|null
     */
    public function getExchangeDate()
    {
        return $this->ExchangeDate;
    }
    /**
     * Set ExchangeDate value
     * @param string $exchangeDate
     * @return \StructType\BaseFareInfo
     */
    public function setExchangeDate($exchangeDate = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeDate) && !is_string($exchangeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeDate, true), gettype($exchangeDate)), __LINE__);
        }
        $this->ExchangeDate = $exchangeDate;
        return $this;
    }
    /**
     * Get CombinableTrips value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCombinableTrip|null
     */
    public function getCombinableTrips()
    {
        return isset($this->CombinableTrips) ? $this->CombinableTrips : null;
    }
    /**
     * Set CombinableTrips value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCombinableTrip $combinableTrips
     * @return \StructType\BaseFareInfo
     */
    public function setCombinableTrips(\ArrayType\ArrayOfCombinableTrip $combinableTrips = null)
    {
        if (is_null($combinableTrips) || (is_array($combinableTrips) && empty($combinableTrips))) {
            unset($this->CombinableTrips);
        } else {
            $this->CombinableTrips = $combinableTrips;
        }
        return $this;
    }
}
