<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTaxDetail ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfTaxDetail
 * @subpackage Arrays
 */
class ArrayOfTaxDetail extends AbstractStructArrayBase
{
    /**
     * The TaxDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TaxDetail[]
     */
    public $TaxDetail;
    /**
     * Constructor method for ArrayOfTaxDetail
     * @uses ArrayOfTaxDetail::setTaxDetail()
     * @param \StructType\TaxDetail[] $taxDetail
     */
    public function __construct(array $taxDetail = array())
    {
        $this
            ->setTaxDetail($taxDetail);
    }
    /**
     * Get TaxDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TaxDetail[]|null
     */
    public function getTaxDetail()
    {
        return isset($this->TaxDetail) ? $this->TaxDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxDetailForArrayConstraintsFromSetTaxDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTaxDetailTaxDetailItem) {
            // validation for constraint: itemType
            if (!$arrayOfTaxDetailTaxDetailItem instanceof \StructType\TaxDetail) {
                $invalidValues[] = is_object($arrayOfTaxDetailTaxDetailItem) ? get_class($arrayOfTaxDetailTaxDetailItem) : sprintf('%s(%s)', gettype($arrayOfTaxDetailTaxDetailItem), var_export($arrayOfTaxDetailTaxDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxDetail property can only contain items of type \StructType\TaxDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TaxDetail[] $taxDetail
     * @return \ArrayType\ArrayOfTaxDetail
     */
    public function setTaxDetail(array $taxDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($taxDetailArrayErrorMessage = self::validateTaxDetailForArrayConstraintsFromSetTaxDetail($taxDetail))) {
            throw new \InvalidArgumentException($taxDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($taxDetail) || (is_array($taxDetail) && empty($taxDetail))) {
            unset($this->TaxDetail);
        } else {
            $this->TaxDetail = $taxDetail;
        }
        return $this;
    }
    /**
     * Add item to TaxDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxDetail $item
     * @return \ArrayType\ArrayOfTaxDetail
     */
    public function addToTaxDetail(\StructType\TaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxDetail) {
            throw new \InvalidArgumentException(sprintf('The TaxDetail property can only contain items of type \StructType\TaxDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxDetail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TaxDetail|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TaxDetail|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TaxDetail|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TaxDetail|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TaxDetail|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TaxDetail
     */
    public function getAttributeName()
    {
        return 'TaxDetail';
    }
}
