<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServiceSummary ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfServiceSummary
 * @subpackage Arrays
 */
class ArrayOfServiceSummary extends AbstractStructArrayBase
{
    /**
     * The ServiceSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceSummary[]
     */
    public $ServiceSummary;
    /**
     * Constructor method for ArrayOfServiceSummary
     * @uses ArrayOfServiceSummary::setServiceSummary()
     * @param \StructType\ServiceSummary[] $serviceSummary
     */
    public function __construct(array $serviceSummary = array())
    {
        $this
            ->setServiceSummary($serviceSummary);
    }
    /**
     * Get ServiceSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceSummary[]|null
     */
    public function getServiceSummary()
    {
        return isset($this->ServiceSummary) ? $this->ServiceSummary : null;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceSummaryForArrayConstraintsFromSetServiceSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfServiceSummaryServiceSummaryItem) {
            // validation for constraint: itemType
            if (!$arrayOfServiceSummaryServiceSummaryItem instanceof \StructType\ServiceSummary) {
                $invalidValues[] = is_object($arrayOfServiceSummaryServiceSummaryItem) ? get_class($arrayOfServiceSummaryServiceSummaryItem) : sprintf('%s(%s)', gettype($arrayOfServiceSummaryServiceSummaryItem), var_export($arrayOfServiceSummaryServiceSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceSummary property can only contain items of type \StructType\ServiceSummary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceSummary[] $serviceSummary
     * @return \ArrayType\ArrayOfServiceSummary
     */
    public function setServiceSummary(array $serviceSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceSummaryArrayErrorMessage = self::validateServiceSummaryForArrayConstraintsFromSetServiceSummary($serviceSummary))) {
            throw new \InvalidArgumentException($serviceSummaryArrayErrorMessage, __LINE__);
        }
        if (is_null($serviceSummary) || (is_array($serviceSummary) && empty($serviceSummary))) {
            unset($this->ServiceSummary);
        } else {
            $this->ServiceSummary = $serviceSummary;
        }
        return $this;
    }
    /**
     * Add item to ServiceSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceSummary $item
     * @return \ArrayType\ArrayOfServiceSummary
     */
    public function addToServiceSummary(\StructType\ServiceSummary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceSummary) {
            throw new \InvalidArgumentException(sprintf('The ServiceSummary property can only contain items of type \StructType\ServiceSummary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceSummary[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ServiceSummary|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ServiceSummary|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ServiceSummary|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ServiceSummary|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ServiceSummary|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceSummary
     */
    public function getAttributeName()
    {
        return 'ServiceSummary';
    }
}
