<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewServiceBundleDetailsResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewServiceBundleDetailsResponse
 * @subpackage Structs
 */
class ViewServiceBundleDetailsResponse extends AbstractStructBase
{
    /**
     * The BundleDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BundleDescription;
    /**
     * The BundleGlCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BundleGlCode;
    /**
     * The BundleIataStdCodeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BundleIataStdCodeType;
    /**
     * The BundleId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BundleId;
    /**
     * The BundleIsMaxinventory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $BundleIsMaxinventory;
    /**
     * The BundleServiceDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBundleServiceDetail
     */
    public $BundleServiceDetails;
    /**
     * The BundleType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BundleType;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * The ServiceBundleCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceBundleCode;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Version;
    /**
     * Constructor method for ViewServiceBundleDetailsResponse
     * @uses ViewServiceBundleDetailsResponse::setBundleDescription()
     * @uses ViewServiceBundleDetailsResponse::setBundleGlCode()
     * @uses ViewServiceBundleDetailsResponse::setBundleIataStdCodeType()
     * @uses ViewServiceBundleDetailsResponse::setBundleId()
     * @uses ViewServiceBundleDetailsResponse::setBundleIsMaxinventory()
     * @uses ViewServiceBundleDetailsResponse::setBundleServiceDetails()
     * @uses ViewServiceBundleDetailsResponse::setBundleType()
     * @uses ViewServiceBundleDetailsResponse::setExceptions()
     * @uses ViewServiceBundleDetailsResponse::setServiceBundleCode()
     * @uses ViewServiceBundleDetailsResponse::setVersion()
     * @param string $bundleDescription
     * @param string $bundleGlCode
     * @param string $bundleIataStdCodeType
     * @param int $bundleId
     * @param bool $bundleIsMaxinventory
     * @param \ArrayType\ArrayOfBundleServiceDetail $bundleServiceDetails
     * @param int $bundleType
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @param string $serviceBundleCode
     * @param string $version
     */
    public function __construct($bundleDescription = null, $bundleGlCode = null, $bundleIataStdCodeType = null, $bundleId = null, $bundleIsMaxinventory = null, \ArrayType\ArrayOfBundleServiceDetail $bundleServiceDetails = null, $bundleType = null, \StructType\ExceptionInformation_Exceptions $exceptions = null, $serviceBundleCode = null, $version = null)
    {
        $this
            ->setBundleDescription($bundleDescription)
            ->setBundleGlCode($bundleGlCode)
            ->setBundleIataStdCodeType($bundleIataStdCodeType)
            ->setBundleId($bundleId)
            ->setBundleIsMaxinventory($bundleIsMaxinventory)
            ->setBundleServiceDetails($bundleServiceDetails)
            ->setBundleType($bundleType)
            ->setExceptions($exceptions)
            ->setServiceBundleCode($serviceBundleCode)
            ->setVersion($version);
    }
    /**
     * Get BundleDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBundleDescription()
    {
        return isset($this->BundleDescription) ? $this->BundleDescription : null;
    }
    /**
     * Set BundleDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bundleDescription
     * @return \StructType\ViewServiceBundleDetailsResponse
     */
    public function setBundleDescription($bundleDescription = null)
    {
        // validation for constraint: string
        if (!is_null($bundleDescription) && !is_string($bundleDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleDescription, true), gettype($bundleDescription)), __LINE__);
        }
        if (is_null($bundleDescription) || (is_array($bundleDescription) && empty($bundleDescription))) {
            unset($this->BundleDescription);
        } else {
            $this->BundleDescription = $bundleDescription;
        }
        return $this;
    }
    /**
     * Get BundleGlCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBundleGlCode()
    {
        return isset($this->BundleGlCode) ? $this->BundleGlCode : null;
    }
    /**
     * Set BundleGlCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bundleGlCode
     * @return \StructType\ViewServiceBundleDetailsResponse
     */
    public function setBundleGlCode($bundleGlCode = null)
    {
        // validation for constraint: string
        if (!is_null($bundleGlCode) && !is_string($bundleGlCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleGlCode, true), gettype($bundleGlCode)), __LINE__);
        }
        if (is_null($bundleGlCode) || (is_array($bundleGlCode) && empty($bundleGlCode))) {
            unset($this->BundleGlCode);
        } else {
            $this->BundleGlCode = $bundleGlCode;
        }
        return $this;
    }
    /**
     * Get BundleIataStdCodeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBundleIataStdCodeType()
    {
        return isset($this->BundleIataStdCodeType) ? $this->BundleIataStdCodeType : null;
    }
    /**
     * Set BundleIataStdCodeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bundleIataStdCodeType
     * @return \StructType\ViewServiceBundleDetailsResponse
     */
    public function setBundleIataStdCodeType($bundleIataStdCodeType = null)
    {
        // validation for constraint: string
        if (!is_null($bundleIataStdCodeType) && !is_string($bundleIataStdCodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleIataStdCodeType, true), gettype($bundleIataStdCodeType)), __LINE__);
        }
        if (is_null($bundleIataStdCodeType) || (is_array($bundleIataStdCodeType) && empty($bundleIataStdCodeType))) {
            unset($this->BundleIataStdCodeType);
        } else {
            $this->BundleIataStdCodeType = $bundleIataStdCodeType;
        }
        return $this;
    }
    /**
     * Get BundleId value
     * @return int|null
     */
    public function getBundleId()
    {
        return $this->BundleId;
    }
    /**
     * Set BundleId value
     * @param int $bundleId
     * @return \StructType\ViewServiceBundleDetailsResponse
     */
    public function setBundleId($bundleId = null)
    {
        // validation for constraint: int
        if (!is_null($bundleId) && !(is_int($bundleId) || ctype_digit($bundleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bundleId, true), gettype($bundleId)), __LINE__);
        }
        $this->BundleId = $bundleId;
        return $this;
    }
    /**
     * Get BundleIsMaxinventory value
     * @return bool|null
     */
    public function getBundleIsMaxinventory()
    {
        return $this->BundleIsMaxinventory;
    }
    /**
     * Set BundleIsMaxinventory value
     * @param bool $bundleIsMaxinventory
     * @return \StructType\ViewServiceBundleDetailsResponse
     */
    public function setBundleIsMaxinventory($bundleIsMaxinventory = null)
    {
        // validation for constraint: boolean
        if (!is_null($bundleIsMaxinventory) && !is_bool($bundleIsMaxinventory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bundleIsMaxinventory, true), gettype($bundleIsMaxinventory)), __LINE__);
        }
        $this->BundleIsMaxinventory = $bundleIsMaxinventory;
        return $this;
    }
    /**
     * Get BundleServiceDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBundleServiceDetail|null
     */
    public function getBundleServiceDetails()
    {
        return isset($this->BundleServiceDetails) ? $this->BundleServiceDetails : null;
    }
    /**
     * Set BundleServiceDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBundleServiceDetail $bundleServiceDetails
     * @return \StructType\ViewServiceBundleDetailsResponse
     */
    public function setBundleServiceDetails(\ArrayType\ArrayOfBundleServiceDetail $bundleServiceDetails = null)
    {
        if (is_null($bundleServiceDetails) || (is_array($bundleServiceDetails) && empty($bundleServiceDetails))) {
            unset($this->BundleServiceDetails);
        } else {
            $this->BundleServiceDetails = $bundleServiceDetails;
        }
        return $this;
    }
    /**
     * Get BundleType value
     * @return int|null
     */
    public function getBundleType()
    {
        return $this->BundleType;
    }
    /**
     * Set BundleType value
     * @param int $bundleType
     * @return \StructType\ViewServiceBundleDetailsResponse
     */
    public function setBundleType($bundleType = null)
    {
        // validation for constraint: int
        if (!is_null($bundleType) && !(is_int($bundleType) || ctype_digit($bundleType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bundleType, true), gettype($bundleType)), __LINE__);
        }
        $this->BundleType = $bundleType;
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ViewServiceBundleDetailsResponse
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
    /**
     * Get ServiceBundleCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceBundleCode()
    {
        return isset($this->ServiceBundleCode) ? $this->ServiceBundleCode : null;
    }
    /**
     * Set ServiceBundleCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceBundleCode
     * @return \StructType\ViewServiceBundleDetailsResponse
     */
    public function setServiceBundleCode($serviceBundleCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceBundleCode) && !is_string($serviceBundleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceBundleCode, true), gettype($serviceBundleCode)), __LINE__);
        }
        if (is_null($serviceBundleCode) || (is_array($serviceBundleCode) && empty($serviceBundleCode))) {
            unset($this->ServiceBundleCode);
        } else {
            $this->ServiceBundleCode = $serviceBundleCode;
        }
        return $this;
    }
    /**
     * Get Version value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVersion()
    {
        return isset($this->Version) ? $this->Version : null;
    }
    /**
     * Set Version value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $version
     * @return \StructType\ViewServiceBundleDetailsResponse
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        if (is_null($version) || (is_array($version) && empty($version))) {
            unset($this->Version);
        } else {
            $this->Version = $version;
        }
        return $this;
    }
}
