<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewFareQuote StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewFareQuote
 * @subpackage Structs
 */
class ViewFareQuote extends AbstractStructBase
{
    /**
     * The BogoPromotionApplied
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $BogoPromotionApplied;
    /**
     * The CommissionIncluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CommissionIncluded;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * The FlightSegments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfFlightSegment
     */
    public $FlightSegments;
    /**
     * The IsExternalPriced
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsExternalPriced;
    /**
     * The LegDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLegDetail
     */
    public $LegDetails;
    /**
     * The RequestedCorporationID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RequestedCorporationID;
    /**
     * The RequestedCurrencyOfFareQuote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestedCurrencyOfFareQuote;
    /**
     * The RequestedFareFilterMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RequestedFareFilterMethod;
    /**
     * The RequestedGroupMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RequestedGroupMethod;
    /**
     * The RequestedIataNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestedIataNumber;
    /**
     * The RequestedInventoryFilterMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RequestedInventoryFilterMethod;
    /**
     * The RequestedPromotionalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestedPromotionalCode;
    /**
     * The RequestedReservationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RequestedReservationChannel;
    /**
     * The SegmentDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSegmentDetail
     */
    public $SegmentDetails;
    /**
     * The TaxDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTaxDetail
     */
    public $TaxDetails;
    /**
     * Constructor method for ViewFareQuote
     * @uses ViewFareQuote::setBogoPromotionApplied()
     * @uses ViewFareQuote::setCommissionIncluded()
     * @uses ViewFareQuote::setExceptions()
     * @uses ViewFareQuote::setFlightSegments()
     * @uses ViewFareQuote::setIsExternalPriced()
     * @uses ViewFareQuote::setLegDetails()
     * @uses ViewFareQuote::setRequestedCorporationID()
     * @uses ViewFareQuote::setRequestedCurrencyOfFareQuote()
     * @uses ViewFareQuote::setRequestedFareFilterMethod()
     * @uses ViewFareQuote::setRequestedGroupMethod()
     * @uses ViewFareQuote::setRequestedIataNumber()
     * @uses ViewFareQuote::setRequestedInventoryFilterMethod()
     * @uses ViewFareQuote::setRequestedPromotionalCode()
     * @uses ViewFareQuote::setRequestedReservationChannel()
     * @uses ViewFareQuote::setSegmentDetails()
     * @uses ViewFareQuote::setTaxDetails()
     * @param bool $bogoPromotionApplied
     * @param bool $commissionIncluded
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @param \ArrayType\ArrayOfFlightSegment $flightSegments
     * @param bool $isExternalPriced
     * @param \ArrayType\ArrayOfLegDetail $legDetails
     * @param int $requestedCorporationID
     * @param string $requestedCurrencyOfFareQuote
     * @param int $requestedFareFilterMethod
     * @param int $requestedGroupMethod
     * @param string $requestedIataNumber
     * @param int $requestedInventoryFilterMethod
     * @param string $requestedPromotionalCode
     * @param int $requestedReservationChannel
     * @param \ArrayType\ArrayOfSegmentDetail $segmentDetails
     * @param \ArrayType\ArrayOfTaxDetail $taxDetails
     */
    public function __construct($bogoPromotionApplied = null, $commissionIncluded = null, \StructType\ExceptionInformation_Exceptions $exceptions = null, \ArrayType\ArrayOfFlightSegment $flightSegments = null, $isExternalPriced = null, \ArrayType\ArrayOfLegDetail $legDetails = null, $requestedCorporationID = null, $requestedCurrencyOfFareQuote = null, $requestedFareFilterMethod = null, $requestedGroupMethod = null, $requestedIataNumber = null, $requestedInventoryFilterMethod = null, $requestedPromotionalCode = null, $requestedReservationChannel = null, \ArrayType\ArrayOfSegmentDetail $segmentDetails = null, \ArrayType\ArrayOfTaxDetail $taxDetails = null)
    {
        $this
            ->setBogoPromotionApplied($bogoPromotionApplied)
            ->setCommissionIncluded($commissionIncluded)
            ->setExceptions($exceptions)
            ->setFlightSegments($flightSegments)
            ->setIsExternalPriced($isExternalPriced)
            ->setLegDetails($legDetails)
            ->setRequestedCorporationID($requestedCorporationID)
            ->setRequestedCurrencyOfFareQuote($requestedCurrencyOfFareQuote)
            ->setRequestedFareFilterMethod($requestedFareFilterMethod)
            ->setRequestedGroupMethod($requestedGroupMethod)
            ->setRequestedIataNumber($requestedIataNumber)
            ->setRequestedInventoryFilterMethod($requestedInventoryFilterMethod)
            ->setRequestedPromotionalCode($requestedPromotionalCode)
            ->setRequestedReservationChannel($requestedReservationChannel)
            ->setSegmentDetails($segmentDetails)
            ->setTaxDetails($taxDetails);
    }
    /**
     * Get BogoPromotionApplied value
     * @return bool|null
     */
    public function getBogoPromotionApplied()
    {
        return $this->BogoPromotionApplied;
    }
    /**
     * Set BogoPromotionApplied value
     * @param bool $bogoPromotionApplied
     * @return \StructType\ViewFareQuote
     */
    public function setBogoPromotionApplied($bogoPromotionApplied = null)
    {
        // validation for constraint: boolean
        if (!is_null($bogoPromotionApplied) && !is_bool($bogoPromotionApplied)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bogoPromotionApplied, true), gettype($bogoPromotionApplied)), __LINE__);
        }
        $this->BogoPromotionApplied = $bogoPromotionApplied;
        return $this;
    }
    /**
     * Get CommissionIncluded value
     * @return bool|null
     */
    public function getCommissionIncluded()
    {
        return $this->CommissionIncluded;
    }
    /**
     * Set CommissionIncluded value
     * @param bool $commissionIncluded
     * @return \StructType\ViewFareQuote
     */
    public function setCommissionIncluded($commissionIncluded = null)
    {
        // validation for constraint: boolean
        if (!is_null($commissionIncluded) && !is_bool($commissionIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($commissionIncluded, true), gettype($commissionIncluded)), __LINE__);
        }
        $this->CommissionIncluded = $commissionIncluded;
        return $this;
    }
    /**
     * Get Exceptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return isset($this->Exceptions) ? $this->Exceptions : null;
    }
    /**
     * Set Exceptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ViewFareQuote
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        if (is_null($exceptions) || (is_array($exceptions) && empty($exceptions))) {
            unset($this->Exceptions);
        } else {
            $this->Exceptions = $exceptions;
        }
        return $this;
    }
    /**
     * Get FlightSegments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfFlightSegment|null
     */
    public function getFlightSegments()
    {
        return isset($this->FlightSegments) ? $this->FlightSegments : null;
    }
    /**
     * Set FlightSegments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfFlightSegment $flightSegments
     * @return \StructType\ViewFareQuote
     */
    public function setFlightSegments(\ArrayType\ArrayOfFlightSegment $flightSegments = null)
    {
        if (is_null($flightSegments) || (is_array($flightSegments) && empty($flightSegments))) {
            unset($this->FlightSegments);
        } else {
            $this->FlightSegments = $flightSegments;
        }
        return $this;
    }
    /**
     * Get IsExternalPriced value
     * @return bool|null
     */
    public function getIsExternalPriced()
    {
        return $this->IsExternalPriced;
    }
    /**
     * Set IsExternalPriced value
     * @param bool $isExternalPriced
     * @return \StructType\ViewFareQuote
     */
    public function setIsExternalPriced($isExternalPriced = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExternalPriced) && !is_bool($isExternalPriced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExternalPriced, true), gettype($isExternalPriced)), __LINE__);
        }
        $this->IsExternalPriced = $isExternalPriced;
        return $this;
    }
    /**
     * Get LegDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLegDetail|null
     */
    public function getLegDetails()
    {
        return isset($this->LegDetails) ? $this->LegDetails : null;
    }
    /**
     * Set LegDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLegDetail $legDetails
     * @return \StructType\ViewFareQuote
     */
    public function setLegDetails(\ArrayType\ArrayOfLegDetail $legDetails = null)
    {
        if (is_null($legDetails) || (is_array($legDetails) && empty($legDetails))) {
            unset($this->LegDetails);
        } else {
            $this->LegDetails = $legDetails;
        }
        return $this;
    }
    /**
     * Get RequestedCorporationID value
     * @return int|null
     */
    public function getRequestedCorporationID()
    {
        return $this->RequestedCorporationID;
    }
    /**
     * Set RequestedCorporationID value
     * @param int $requestedCorporationID
     * @return \StructType\ViewFareQuote
     */
    public function setRequestedCorporationID($requestedCorporationID = null)
    {
        // validation for constraint: int
        if (!is_null($requestedCorporationID) && !(is_int($requestedCorporationID) || ctype_digit($requestedCorporationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestedCorporationID, true), gettype($requestedCorporationID)), __LINE__);
        }
        $this->RequestedCorporationID = $requestedCorporationID;
        return $this;
    }
    /**
     * Get RequestedCurrencyOfFareQuote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestedCurrencyOfFareQuote()
    {
        return isset($this->RequestedCurrencyOfFareQuote) ? $this->RequestedCurrencyOfFareQuote : null;
    }
    /**
     * Set RequestedCurrencyOfFareQuote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestedCurrencyOfFareQuote
     * @return \StructType\ViewFareQuote
     */
    public function setRequestedCurrencyOfFareQuote($requestedCurrencyOfFareQuote = null)
    {
        // validation for constraint: string
        if (!is_null($requestedCurrencyOfFareQuote) && !is_string($requestedCurrencyOfFareQuote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedCurrencyOfFareQuote, true), gettype($requestedCurrencyOfFareQuote)), __LINE__);
        }
        if (is_null($requestedCurrencyOfFareQuote) || (is_array($requestedCurrencyOfFareQuote) && empty($requestedCurrencyOfFareQuote))) {
            unset($this->RequestedCurrencyOfFareQuote);
        } else {
            $this->RequestedCurrencyOfFareQuote = $requestedCurrencyOfFareQuote;
        }
        return $this;
    }
    /**
     * Get RequestedFareFilterMethod value
     * @return int|null
     */
    public function getRequestedFareFilterMethod()
    {
        return $this->RequestedFareFilterMethod;
    }
    /**
     * Set RequestedFareFilterMethod value
     * @param int $requestedFareFilterMethod
     * @return \StructType\ViewFareQuote
     */
    public function setRequestedFareFilterMethod($requestedFareFilterMethod = null)
    {
        // validation for constraint: int
        if (!is_null($requestedFareFilterMethod) && !(is_int($requestedFareFilterMethod) || ctype_digit($requestedFareFilterMethod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestedFareFilterMethod, true), gettype($requestedFareFilterMethod)), __LINE__);
        }
        $this->RequestedFareFilterMethod = $requestedFareFilterMethod;
        return $this;
    }
    /**
     * Get RequestedGroupMethod value
     * @return int|null
     */
    public function getRequestedGroupMethod()
    {
        return $this->RequestedGroupMethod;
    }
    /**
     * Set RequestedGroupMethod value
     * @param int $requestedGroupMethod
     * @return \StructType\ViewFareQuote
     */
    public function setRequestedGroupMethod($requestedGroupMethod = null)
    {
        // validation for constraint: int
        if (!is_null($requestedGroupMethod) && !(is_int($requestedGroupMethod) || ctype_digit($requestedGroupMethod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestedGroupMethod, true), gettype($requestedGroupMethod)), __LINE__);
        }
        $this->RequestedGroupMethod = $requestedGroupMethod;
        return $this;
    }
    /**
     * Get RequestedIataNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestedIataNumber()
    {
        return isset($this->RequestedIataNumber) ? $this->RequestedIataNumber : null;
    }
    /**
     * Set RequestedIataNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestedIataNumber
     * @return \StructType\ViewFareQuote
     */
    public function setRequestedIataNumber($requestedIataNumber = null)
    {
        // validation for constraint: string
        if (!is_null($requestedIataNumber) && !is_string($requestedIataNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedIataNumber, true), gettype($requestedIataNumber)), __LINE__);
        }
        if (is_null($requestedIataNumber) || (is_array($requestedIataNumber) && empty($requestedIataNumber))) {
            unset($this->RequestedIataNumber);
        } else {
            $this->RequestedIataNumber = $requestedIataNumber;
        }
        return $this;
    }
    /**
     * Get RequestedInventoryFilterMethod value
     * @return int|null
     */
    public function getRequestedInventoryFilterMethod()
    {
        return $this->RequestedInventoryFilterMethod;
    }
    /**
     * Set RequestedInventoryFilterMethod value
     * @param int $requestedInventoryFilterMethod
     * @return \StructType\ViewFareQuote
     */
    public function setRequestedInventoryFilterMethod($requestedInventoryFilterMethod = null)
    {
        // validation for constraint: int
        if (!is_null($requestedInventoryFilterMethod) && !(is_int($requestedInventoryFilterMethod) || ctype_digit($requestedInventoryFilterMethod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestedInventoryFilterMethod, true), gettype($requestedInventoryFilterMethod)), __LINE__);
        }
        $this->RequestedInventoryFilterMethod = $requestedInventoryFilterMethod;
        return $this;
    }
    /**
     * Get RequestedPromotionalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestedPromotionalCode()
    {
        return isset($this->RequestedPromotionalCode) ? $this->RequestedPromotionalCode : null;
    }
    /**
     * Set RequestedPromotionalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestedPromotionalCode
     * @return \StructType\ViewFareQuote
     */
    public function setRequestedPromotionalCode($requestedPromotionalCode = null)
    {
        // validation for constraint: string
        if (!is_null($requestedPromotionalCode) && !is_string($requestedPromotionalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedPromotionalCode, true), gettype($requestedPromotionalCode)), __LINE__);
        }
        if (is_null($requestedPromotionalCode) || (is_array($requestedPromotionalCode) && empty($requestedPromotionalCode))) {
            unset($this->RequestedPromotionalCode);
        } else {
            $this->RequestedPromotionalCode = $requestedPromotionalCode;
        }
        return $this;
    }
    /**
     * Get RequestedReservationChannel value
     * @return int|null
     */
    public function getRequestedReservationChannel()
    {
        return $this->RequestedReservationChannel;
    }
    /**
     * Set RequestedReservationChannel value
     * @param int $requestedReservationChannel
     * @return \StructType\ViewFareQuote
     */
    public function setRequestedReservationChannel($requestedReservationChannel = null)
    {
        // validation for constraint: int
        if (!is_null($requestedReservationChannel) && !(is_int($requestedReservationChannel) || ctype_digit($requestedReservationChannel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestedReservationChannel, true), gettype($requestedReservationChannel)), __LINE__);
        }
        $this->RequestedReservationChannel = $requestedReservationChannel;
        return $this;
    }
    /**
     * Get SegmentDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSegmentDetail|null
     */
    public function getSegmentDetails()
    {
        return isset($this->SegmentDetails) ? $this->SegmentDetails : null;
    }
    /**
     * Set SegmentDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSegmentDetail $segmentDetails
     * @return \StructType\ViewFareQuote
     */
    public function setSegmentDetails(\ArrayType\ArrayOfSegmentDetail $segmentDetails = null)
    {
        if (is_null($segmentDetails) || (is_array($segmentDetails) && empty($segmentDetails))) {
            unset($this->SegmentDetails);
        } else {
            $this->SegmentDetails = $segmentDetails;
        }
        return $this;
    }
    /**
     * Get TaxDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTaxDetail|null
     */
    public function getTaxDetails()
    {
        return isset($this->TaxDetails) ? $this->TaxDetails : null;
    }
    /**
     * Set TaxDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTaxDetail $taxDetails
     * @return \StructType\ViewFareQuote
     */
    public function setTaxDetails(\ArrayType\ArrayOfTaxDetail $taxDetails = null)
    {
        if (is_null($taxDetails) || (is_array($taxDetails) && empty($taxDetails))) {
            unset($this->TaxDetails);
        } else {
            $this->TaxDetails = $taxDetails;
        }
        return $this;
    }
}
